/*  GIMP header image file format (INDEXED): xlock/logo2.h  */

static unsigned int width = 200;
static unsigned int height = 72;

/*  Call this macro repeatedly.  After each use, the pixel data can be extracted  */

#define HEADER_PIXEL(data,pixel) {\
  pixel[0] = header_data_cmap[(unsigned char)data[0]][0]; \
  pixel[1] = header_data_cmap[(unsigned char)data[0]][1]; \
  pixel[2] = header_data_cmap[(unsigned char)data[0]][2]; \
  data ++; }

static char header_data_cmap[256][3] = {
	{  4,  3,  7},
	{ 61,232, 62},
	{ 39,149, 44},
	{172, 49, 67},
	{ 17, 56, 22},
	{229,226,223},
	{ 32,110, 37},
	{ 94, 25, 35},
	{113, 46, 46},
	{ 22, 87, 27},
	{ 70,166, 74},
	{ 43, 11,142},
	{ 62,115,224},
	{ 37, 49,122},
	{ 71, 22, 27},
	{ 58,219, 58},
	{195, 67, 75},
	{108,102, 53},
	{215,177,130},
	{112, 53,157},
	{ 68, 53, 54},
	{ 54, 25, 13},
	{ 65, 82,113},
	{171, 62, 82},
	{ 38, 65,139},
	{115, 73, 53},
	{101,103,120},
	{ 12, 32, 28},
	{ 62,204, 62},
	{ 65, 69, 67},
	{ 77, 60,126},
	{166, 92, 30},
	{ 38, 10, 29},
	{ 93, 10,117},
	{ 76, 81,111},
	{148,103,130},
	{111, 66,154},
	{ 83,102, 96},
	{235,230,224},
	{ 79, 81,155},
	{109, 67, 94},
	{ 86, 60,171},
	{ 90, 55, 53},
	{143, 10,147},
	{ 73, 44,127},
	{ 21, 26, 32},
	{227,194,155},
	{113, 75, 84},
	{ 63, 84, 87},
	{108,103,172},
	{ 55,  8, 53},
	{160,154,146},
	{166,111, 60},
	{ 70,206, 70},
	{208, 68, 67},
	{ 78, 48,171},
	{ 97, 20,117},
	{ 20, 22, 28},
	{ 89, 69, 50},
	{ 96,128,130},
	{147, 84,107},
	{236,236,237},
	{151,106, 64},
	{182,179,188},
	{168,160,181},
	{ 47,179, 51},
	{ 66, 46, 77},
	{ 57,102,190},
	{ 28, 12, 24},
	{110, 77,153},
	{ 41, 48, 58},
	{ 93, 31,169},
	{132,108,133},
	{ 93, 67,121},
	{176,124,157},
	{ 80, 80,133},
	{ 67, 14, 64},
	{ 58, 58, 96},
	{ 89, 82, 50},
	{ 49, 31,135},
	{ 67, 31, 61},
	{113, 53, 80},
	{ 38, 34, 99},
	{ 44, 18,110},
	{242,242,242},
	{181,134, 81},
	{190,131, 76},
	{ 13, 15, 21},
	{ 78, 60,151},
	{108, 76,114},
	{121, 32,123},
	{ 50, 87,176},
	{ 95, 50,131},
	{111,120,127},
	{ 67, 30,185},
	{ 87, 70, 76},
	{219, 71, 76},
	{147, 84,165},
	{233,206,169},
	{ 78, 89,131},
	{ 47, 69, 90},
	{ 74, 49,153},
	{102,102,146},
	{147, 66,113},
	{ 83,102,116},
	{ 55,  6, 78},
	{ 72, 70,126},
	{150, 52, 99},
	{ 74, 58, 80},
	{201,196,207},
	{150,121,189},
	{130, 84,112},
	{ 24, 48, 90},
	{ 66, 26,134},
	{ 22,  7, 22},
	{ 89, 33,110},
	{214,136, 98},
	{111, 86,182},
	{ 53,204, 55},
	{ 91, 45, 97},
	{129,133,184},
	{172, 21,163},
	{ 61, 60,125},
	{132,107, 70},
	{170,113,125},
	{210,209,214},
	{ 96, 85,111},
	{ 55, 20, 97},
	{193,149, 97},
	{107, 88,116},
	{175, 69,182},
	{124, 28, 59},
	{216,182,193},
	{144,126,206},
	{ 41, 20, 69},
	{110, 44,111},
	{120,105,118},
	{108, 89,145},
	{ 57, 69,101},
	{ 94, 35,148},
	{152, 50,157},
	{ 70, 24,102},
	{148, 85, 34},
	{ 80, 47, 95},
	{ 93, 68,148},
	{ 86, 94, 89},
	{ 34, 33, 42},
	{ 88, 49,127},
	{ 58, 83,148},
	{ 42, 60, 94},
	{ 92, 90,134},
	{148,124,134},
	{  9, 10, 16},
	{ 88, 91,156},
	{254,254,254},
	{219,219,219},
	{ 91, 11, 84},
	{ 96, 80,134},
	{ 90, 62, 92},
	{ 85, 70, 99},
	{148, 67,161},
	{208,165,115},
	{112, 66,123},
	{230,202,166},
	{ 82, 82, 86},
	{ 62, 64,157},
	{194,102,210},
	{111, 88, 85},
	{ 70, 30,162},
	{ 58, 48,161},
	{137, 51,119},
	{202, 79,179},
	{ 82, 94,110},
	{245, 78, 78},
	{ 96, 84, 87},
	{112, 32,114},
	{130,110,177},
	{ 74, 58,101},
	{ 36,134, 41},
	{113,128, 90},
	{ 61, 70,126},
	{ 74, 69,168},
	{110, 66,193},
	{172,122, 71},
	{ 89, 32, 79},
	{119, 10,126},
	{106,114,120},
	{ 18,  6, 14},
	{ 84,101,140},
	{146,146, 78},
	{ 65, 46,100},
	{130, 90,145},
	{ 69, 34, 86},
	{ 98, 70, 99},
	{113, 88, 50},
	{ 39, 33, 74},
	{194,181,219},
	{ 93, 81,161},
	{ 70, 36,138},
	{202,122,158},
	{120,104,148},
	{ 91, 54, 95},
	{ 96, 50,174},
	{148,132, 80},
	{ 82, 71,127},
	{ 39, 21, 32},
	{169, 89,111},
	{126,130,128},
	{ 54, 34, 64},
	{131, 65, 94},
	{136, 45,149},
	{ 89,104,163},
	{140, 30,132},
	{ 79, 70,151},
	{ 13, 16, 48},
	{ 74, 52,126},
	{ 71, 13,101},
	{129, 86, 88},
	{ 57, 48,128},
	{101,  9,158},
	{ 17, 22, 73},
	{ 44, 47, 91},
	{143, 51, 50},
	{ 82, 90,112},
	{104, 34,115},
	{193,105,121},
	{111, 55,111},
	{ 69, 70, 97},
	{ 66, 83,133},
	{145,146,170},
	{120, 88,110},
	{234,207,175},
	{116,124,175},
	{108,104, 87},
	{169, 51,135},
	{ 58, 10,184},
	{ 89, 50,154},
	{ 87,117,134},
	{108, 87,165},
	{226,122,134},
	{114,103,119},
	{ 82, 98, 74},
	{ 91, 70,170},
	{ 70, 35,107},
	{  7,  6, 21},
	{ 90, 80,136},
	{102,114,146},
	{110,112,216},
	{ 29, 14, 68},
	{110, 31, 65},
	{ 53, 30, 47},
	{ 67, 11,145},
	{ 86, 82,110},
	{ 17, 33, 72},
	{ 55, 33,101},
	{255,255,255}
	};
static char header_data[] = {
	29,221,11,113,77,77,82,190,208,79,190,108,254,44,108,77,
	227,227,29,138,77,77,177,254,79,108,66,254,243,77,190,82,
	254,108,218,190,77,254,77,190,254,83,254,254,20,190,108,227,
	77,82,190,177,192,243,143,143,216,115,108,95,108,108,95,66,
	184,141,216,56,33,115,115,158,143,115,177,66,243,177,177,192,
	158,190,44,127,127,243,190,254,243,251,127,44,108,227,177,177,
	227,77,22,29,82,11,221,77,100,149,112,82,77,82,100,149,
	82,149,4,24,112,82,248,82,82,83,11,127,82,127,11,77,
	100,195,11,79,20,77,82,190,208,79,190,108,254,44,108,77,
	227,227,29,138,77,77,177,254,79,108,66,79,243,77,190,82,
	254,108,190,218,77,254,77,190,254,83,254,254,20,190,108,227,
	77,82,190,177,192,243,143,143,216,115,108,95,108,108,95,66,
	184,141,216,56,33,115,115,146,
	237,181,94,176,252,181,55,182,41,55,117,49,242,191,240,242,
	49,49,246,188,153,49,41,19,117,137,44,94,182,137,176,69,
	49,245,198,213,245,197,129,88,44,71,191,49,49,236,176,59,
	93,93,232,41,35,97,74,176,185,130,124,151,72,157,72,69,
	160,160,140,130,166,199,128,229,117,160,35,176,97,160,160,210,
	191,191,176,139,110,110,182,176,110,139,133,229,179,237,94,202,
	102,247,247,188,213,182,247,211,153,181,169,94,169,169,247,180,
	149,67,67,91,39,169,11,198,24,79,169,232,232,247,99,59,
	59,88,94,191,252,165,55,182,41,55,117,49,242,191,240,242,
	49,49,246,211,153,137,182,202,191,137,101,168,182,200,176,117,
	49,157,169,242,157,197,129,41,44,71,191,49,49,236,176,59,
	93,93,232,41,35,97,74,176,185,130,124,151,72,157,72,69,
	160,160,140,130,166,199,128,240,
	180,101,94,94,181,180,88,182,182,41,213,49,88,157,69,55,
	49,197,49,49,49,242,94,182,151,49,41,242,148,253,82,220,
	137,252,153,49,150,242,242,236,36,71,72,26,75,101,93,59,
	246,246,204,242,117,44,117,49,210,140,140,47,72,164,200,69,
	19,19,90,166,107,74,151,151,176,97,97,97,130,160,97,210,
	49,110,191,182,110,176,117,176,153,117,207,179,186,181,169,200,
	93,104,39,247,232,246,246,67,99,165,181,165,197,39,49,148,
	246,237,48,13,235,235,94,39,148,94,181,237,91,246,34,180,
	148,88,94,55,181,165,213,182,182,41,213,49,88,157,69,55,
	49,197,49,49,49,242,94,182,110,137,242,242,200,49,41,144,
	49,150,102,247,137,197,242,236,36,71,72,26,75,101,93,59,
	246,246,204,242,117,44,117,49,210,140,140,47,72,164,200,69,
	19,19,90,166,107,74,151,20,
	79,41,202,101,126,77,79,235,168,242,39,39,213,197,55,71,
	242,55,238,197,165,44,120,70,108,221,253,253,220,13,27,0,
	0,195,34,180,215,204,198,30,245,88,240,223,106,236,129,104,
	22,75,88,88,115,69,191,93,36,226,35,62,174,243,147,111,
	230,47,209,160,35,128,203,186,176,191,191,97,71,71,97,35,
	186,136,238,182,117,30,150,246,237,188,59,37,181,169,41,129,
	102,93,228,180,228,148,188,67,237,188,148,24,104,188,99,24,
	24,165,13,11,235,94,99,172,180,79,181,228,24,153,218,83,
	169,55,55,101,126,77,79,235,168,242,39,39,213,197,55,71,
	242,55,153,153,165,169,41,242,26,75,197,153,26,213,44,144,
	150,252,252,106,30,242,44,30,157,88,200,145,106,236,129,104,
	22,75,88,88,115,69,191,93,36,226,35,62,174,243,147,111,
	230,47,209,103,35,85,207,146,
	190,94,235,44,20,79,83,168,236,238,39,165,88,55,94,242,
	101,101,245,204,26,27,70,87,152,214,152,220,220,91,12,91,
	152,0,187,221,221,204,190,164,145,22,34,48,106,198,44,254,
	122,213,144,44,113,162,129,129,92,92,89,230,201,56,139,92,
	73,111,135,175,19,151,186,72,93,89,69,191,160,191,93,136,
	179,129,157,215,144,102,93,186,172,172,37,227,190,213,202,101,
	106,150,169,213,99,104,237,104,148,148,165,82,148,24,24,13,
	13,165,165,169,79,67,104,99,180,169,75,22,24,228,106,181,
	215,235,11,44,20,79,83,168,236,238,39,165,88,55,94,242,
	101,101,157,204,30,213,242,197,150,150,39,75,204,169,101,242,
	106,180,34,122,180,252,215,126,241,22,34,172,122,44,44,254,
	122,213,144,44,113,162,129,129,92,92,89,230,201,56,139,92,
	73,111,135,139,19,151,233,146,
	11,235,202,157,221,83,243,79,113,215,213,213,169,94,101,204,
	215,101,150,164,45,87,214,214,253,214,214,24,12,12,12,12,
	67,112,0,0,87,77,195,108,48,227,138,227,218,147,139,101,
	177,213,218,113,251,139,191,215,144,126,233,136,115,135,191,167,
	89,135,219,56,36,203,123,233,129,89,240,136,174,233,186,93,
	150,137,73,204,129,26,186,104,106,228,99,215,101,144,44,39,
	188,223,169,153,104,104,22,138,218,218,218,169,165,169,79,79,
	24,165,122,169,169,228,148,24,24,79,83,79,79,55,41,169,
	113,235,55,159,190,83,243,79,113,215,213,213,169,94,101,245,
	44,236,137,245,213,39,242,157,106,150,88,88,88,218,88,75,
	75,99,227,122,106,204,254,164,241,22,138,22,218,147,139,101,
	177,213,218,113,251,139,191,215,144,126,233,136,115,135,191,167,
	69,135,185,56,36,203,123,146,
	113,168,137,126,190,79,218,11,83,55,144,242,198,236,39,245,
	198,180,146,87,244,244,214,152,214,24,12,12,12,12,12,12,
	12,12,24,152,0,114,82,221,100,77,218,100,218,41,115,145,
	26,159,30,157,41,36,137,126,233,137,89,201,115,230,167,159,
	159,119,210,19,230,207,179,93,240,72,240,240,129,240,37,252,
	252,26,157,150,233,145,188,37,106,204,22,254,55,198,30,237,
	104,213,101,153,75,24,82,79,79,242,157,44,122,169,169,165,
	13,79,11,169,165,67,228,24,106,168,235,168,113,235,113,55,
	198,113,150,252,218,79,218,11,83,55,144,242,198,55,245,75,
	198,101,150,204,181,245,39,99,213,153,44,94,236,197,39,99,
	150,172,172,180,122,218,83,106,180,122,122,138,101,92,44,150,
	233,227,30,157,41,36,137,126,233,137,89,201,115,230,167,95,
	159,119,19,210,230,207,186,146,
	44,197,49,153,122,218,218,79,251,168,101,215,236,197,126,232,
	70,0,244,0,152,152,214,24,12,12,12,12,12,12,12,12,
	12,12,12,91,214,0,0,77,82,221,106,77,254,113,113,145,
	22,34,122,198,30,129,150,223,126,243,224,139,193,17,145,177,
	193,201,210,226,72,179,186,129,126,230,137,126,201,230,129,40,
	240,167,129,30,252,223,75,22,245,213,228,30,144,122,150,237,
	188,218,215,150,39,169,153,157,169,197,122,13,39,181,99,104,
	213,94,94,213,75,99,228,39,148,83,168,88,88,55,144,102,
	41,41,197,150,77,218,218,79,251,168,236,215,55,157,245,39,
	55,242,157,242,181,213,39,106,39,181,55,88,157,245,180,99,
	75,22,227,180,106,165,218,204,122,122,204,138,79,198,113,26,
	22,34,30,198,30,129,150,223,126,243,224,139,193,17,145,177,
	193,226,90,162,123,179,233,146,
	82,102,211,153,122,198,11,11,235,41,39,144,55,88,223,152,
	0,0,244,244,112,91,12,12,67,91,67,24,24,91,12,12,
	12,12,12,12,12,112,0,0,205,221,77,221,79,147,106,223,
	138,30,147,254,26,241,26,44,251,147,129,126,126,126,158,243,
	119,90,219,170,123,240,233,167,119,162,150,157,144,240,233,204,
	126,30,201,215,157,34,30,30,252,198,99,34,104,228,237,99,
	106,198,204,104,180,55,242,75,204,181,198,213,228,165,228,180,
	13,94,242,211,22,101,113,79,165,94,101,228,39,144,159,164,
	218,153,172,153,215,198,11,235,235,101,153,144,139,213,88,169,
	41,75,202,71,165,88,144,215,213,101,198,153,150,75,228,99,
	204,88,254,77,180,106,13,34,75,181,227,77,168,215,106,172,
	138,30,147,254,26,241,26,44,251,147,129,126,126,126,158,243,
	147,90,219,19,72,233,167,146,
	218,153,49,204,41,198,71,71,251,88,213,55,34,45,0,244,
	244,152,253,91,67,24,253,253,253,214,214,214,244,0,0,220,
	112,67,12,12,12,12,24,214,0,0,149,221,243,218,34,48,
	190,198,113,190,227,227,147,216,162,191,158,190,126,95,143,201,
	224,33,56,97,17,167,230,252,115,230,240,145,129,129,129,252,
	145,157,177,159,150,150,106,218,30,88,252,106,34,180,99,180,
	218,73,150,188,180,213,204,228,101,169,150,188,39,180,106,165,
	181,41,55,99,99,181,55,150,39,44,197,39,181,168,144,204,
	122,245,153,30,88,198,168,71,251,88,213,55,236,242,181,41,
	55,202,168,202,137,102,197,153,153,181,204,145,223,150,39,77,
	168,198,198,213,30,218,165,180,228,180,22,122,101,44,150,48,
	215,198,113,190,227,227,147,216,162,191,158,190,126,95,143,201,
	224,33,185,60,17,174,129,57,
	215,41,41,113,168,251,71,71,71,55,169,29,244,0,0,244,
	253,91,12,91,220,244,152,244,244,214,0,0,244,244,0,244,
	244,244,214,112,12,12,12,67,253,244,0,214,221,82,34,100,
	79,236,71,251,216,139,71,115,47,162,44,157,95,177,119,119,
	219,185,97,62,233,167,89,157,89,240,174,174,230,159,157,104,
	26,252,223,150,145,223,30,101,144,73,177,252,157,204,75,106,
	122,150,223,148,148,75,75,237,197,34,145,180,106,213,215,30,
	169,169,41,211,188,39,169,153,39,169,144,88,181,55,242,204,
	41,101,88,79,71,251,139,71,71,55,169,94,202,238,99,150,
	197,41,41,137,245,213,39,204,75,153,242,144,41,44,236,44,
	168,139,202,30,106,106,180,180,148,22,138,180,88,13,188,22,
	254,41,71,251,216,139,71,115,47,162,44,157,159,177,119,119,
	56,219,60,151,17,167,162,57,
	113,94,242,202,71,71,202,139,19,138,45,0,0,244,214,91,
	12,12,24,152,0,0,0,0,244,253,112,24,253,220,214,152,
	87,152,244,244,214,12,12,12,12,24,214,0,0,195,77,221,
	251,141,115,168,89,30,216,56,135,141,147,136,89,254,139,115,
	33,56,103,179,186,193,143,89,145,167,47,158,69,30,102,241,
	34,106,252,223,164,149,215,44,44,177,159,144,198,218,215,122,
	88,75,172,228,180,39,228,104,227,26,75,218,169,198,113,44,
	181,198,169,181,148,122,106,153,39,88,41,55,41,79,245,75,
	55,113,41,55,71,71,202,71,19,197,242,202,242,181,213,157,
	39,144,102,153,44,41,245,144,41,101,55,168,198,41,144,147,
	168,41,69,144,204,122,24,180,180,180,13,122,79,218,34,13,
	251,56,224,168,157,73,216,56,135,141,147,136,89,254,139,115,
	219,56,103,203,233,89,143,45,
	215,169,242,242,202,202,69,69,104,0,0,244,112,24,67,12,
	12,24,214,0,0,0,244,13,12,12,12,12,12,12,12,253,
	152,220,0,0,152,253,12,12,12,12,12,149,244,244,70,176,
	105,40,119,141,240,89,193,89,162,226,136,233,78,108,73,115,
	185,103,60,17,233,158,126,129,95,252,159,73,243,73,126,126,
	44,192,159,126,34,29,30,88,30,164,164,245,122,75,75,34,
	44,218,75,204,44,106,99,228,122,150,180,180,245,41,55,69,
	238,55,41,69,242,165,213,215,39,153,157,202,41,215,245,197,
	88,94,88,242,202,202,69,69,41,41,242,41,36,39,153,69,
	202,71,41,242,139,242,150,242,55,198,236,236,69,137,126,213,
	252,99,126,75,150,75,77,165,180,122,221,218,79,30,177,79,
	216,111,135,113,136,89,162,89,162,201,136,233,78,108,158,115,
	185,103,111,233,233,177,193,146,
	88,182,49,242,202,202,30,45,0,0,253,91,12,12,12,12,
	24,214,0,214,244,214,12,12,12,12,12,12,12,12,12,12,
	27,253,214,244,244,214,12,12,12,12,12,12,67,45,0,152,
	83,115,192,193,167,158,41,190,113,89,186,145,159,108,192,141,
	210,209,191,17,145,119,174,145,77,89,89,73,30,102,164,215,
	226,147,158,77,77,122,243,243,30,126,215,254,30,99,106,75,
	79,213,204,101,83,218,223,106,218,165,30,245,41,55,198,137,
	144,94,41,19,41,197,153,242,197,153,39,236,200,49,99,137,
	197,181,117,242,202,202,36,69,89,197,137,69,144,197,213,71,
	94,168,242,41,202,19,168,168,19,69,117,242,197,245,75,39,
	188,223,22,180,180,106,195,214,152,0,0,0,244,57,195,251,
	251,44,115,230,167,193,88,215,113,89,186,145,159,143,192,80,
	210,170,217,17,145,143,47,57,
	122,242,117,55,236,227,152,0,0,13,12,12,12,12,12,12,
	253,87,244,220,0,91,12,12,12,12,12,12,12,12,12,12,
	12,24,253,0,0,214,67,12,12,12,12,12,12,12,112,0,
	0,141,227,164,29,127,141,115,144,126,240,26,34,20,108,192,
	175,56,217,233,174,92,167,104,126,157,147,158,174,129,215,201,
	89,30,129,34,106,177,127,115,95,159,190,101,126,223,75,99,
	44,102,223,198,198,145,172,228,34,106,197,88,55,41,197,211,
	102,153,242,55,242,153,99,197,242,39,39,101,137,188,172,242,
	242,213,213,169,202,202,41,41,197,137,137,19,101,153,197,71,
	202,242,150,144,182,219,219,19,102,200,69,41,242,197,197,39,
	34,138,122,218,248,244,0,51,125,5,61,155,109,229,0,0,
	105,198,157,145,164,192,216,0,0,159,233,26,48,20,215,192,
	90,56,35,17,129,201,126,146,
	88,238,238,202,37,244,244,253,67,12,12,12,12,12,12,67,
	13,152,152,244,220,12,12,12,12,12,12,12,12,12,12,12,
	12,12,27,244,0,214,12,12,12,12,12,12,12,12,12,91,
	152,0,29,252,127,243,226,40,89,174,145,37,145,164,215,141,
	56,156,35,17,174,40,89,227,78,201,113,89,145,245,243,162,
	95,164,164,227,122,44,251,135,89,190,251,44,158,227,34,227,
	218,172,223,215,157,104,172,22,165,122,215,198,236,102,186,213,
	213,102,242,41,136,59,211,153,137,211,188,181,49,153,165,41,
	144,242,238,236,69,182,182,197,137,102,39,71,144,102,69,71,
	69,102,150,182,69,55,97,72,186,102,99,238,137,126,150,150,
	213,30,254,244,0,109,61,84,84,61,61,61,5,5,155,51,
	0,68,29,95,113,115,0,84,61,0,29,241,145,164,215,141,
	56,156,35,194,174,158,126,57,
	30,117,238,70,0,244,82,91,12,12,12,12,12,12,12,12,
	253,214,244,244,253,12,12,12,12,12,12,91,27,112,67,12,
	12,12,12,12,91,24,12,12,12,12,12,12,12,12,12,12,
	12,70,87,0,216,115,115,216,215,73,73,252,58,190,141,33,
	219,56,123,78,78,89,92,113,119,44,143,129,159,215,108,157,
	164,29,73,215,147,141,113,167,174,113,113,73,204,34,34,218,
	138,228,223,227,223,37,22,22,218,180,106,101,144,200,197,168,
	41,242,204,188,93,59,237,213,153,246,153,213,238,197,30,69,
	36,197,157,139,182,242,197,197,69,182,139,41,238,238,55,71,
	69,145,245,94,19,144,238,191,36,236,204,197,242,69,238,197,
	75,221,0,145,5,61,61,61,61,5,5,5,5,5,155,125,
	63,29,0,208,141,175,0,84,61,38,0,66,29,143,141,216,
	219,56,17,194,78,89,119,68,
	44,242,242,146,187,131,14,82,91,12,12,12,12,12,12,12,
	91,152,0,244,214,24,12,12,12,12,12,112,0,244,220,91,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	67,91,59,187,105,216,76,42,174,159,44,198,192,127,192,81,
	56,56,217,95,201,158,119,40,193,143,147,201,243,143,193,73,
	126,164,159,215,159,215,159,174,95,141,92,89,164,34,227,106,
	228,180,106,122,106,228,228,228,213,99,181,44,41,102,75,88,
	153,102,211,246,237,246,213,168,88,245,211,153,238,88,242,150,
	41,41,242,236,36,102,211,238,242,55,182,69,157,181,139,202,
	137,145,213,71,69,102,150,240,240,200,200,137,236,147,144,150,
	177,0,207,61,84,61,5,125,125,109,109,125,155,155,5,5,
	125,63,145,0,105,156,0,84,125,125,84,0,205,127,192,81,
	56,56,167,95,201,226,243,205,
	101,117,117,45,244,16,23,187,152,180,12,12,12,12,12,12,
	12,112,244,0,214,12,12,12,12,12,67,214,0,244,244,152,
	24,12,12,12,12,12,12,12,12,12,12,12,12,12,12,48,
	112,29,65,0,76,143,81,167,78,159,40,73,158,243,201,201,
	33,224,230,167,73,201,143,193,233,201,201,115,92,162,42,66,
	164,164,29,177,159,177,159,108,66,143,193,252,164,228,75,227,
	30,165,213,165,180,228,22,172,204,39,181,88,88,188,188,102,
	59,59,211,211,39,153,236,202,197,117,238,181,88,39,49,238,
	144,117,197,117,197,49,211,102,197,41,137,137,157,213,144,144,
	238,153,181,113,36,137,204,137,204,197,144,202,139,144,238,188,
	114,26,61,84,61,155,63,164,57,0,0,152,93,63,5,155,
	155,109,63,164,68,226,0,84,125,64,5,154,0,134,143,201,
	156,224,230,167,204,201,66,205,
	122,49,197,205,187,96,173,222,187,244,13,12,12,12,12,12,
	12,12,152,214,244,253,12,12,12,12,12,112,244,0,0,0,
	244,220,112,12,12,12,12,12,12,12,12,12,12,91,100,70,
	53,15,9,187,250,250,250,58,29,158,192,226,40,108,108,143,
	33,226,47,58,108,158,193,226,162,243,19,139,36,47,158,95,
	108,48,29,66,215,159,204,190,44,201,177,159,164,34,138,218,
	221,254,77,122,75,150,104,22,198,79,165,101,144,39,211,211,
	237,59,99,39,153,242,251,71,150,153,242,215,245,102,153,30,
	88,238,242,238,102,211,26,102,144,41,137,137,197,197,245,69,
	150,102,242,88,137,102,197,150,41,117,69,144,69,200,186,70,
	0,5,84,61,155,229,152,114,20,77,221,221,20,87,229,155,
	5,155,63,63,0,250,0,84,155,64,155,61,38,0,66,66,
	33,209,47,58,108,158,226,57,
	204,238,242,205,187,96,173,173,16,187,0,146,67,12,12,12,
	12,12,112,244,214,0,220,12,12,12,12,12,112,0,0,0,
	0,214,24,12,12,12,12,12,12,12,12,91,27,45,9,1,
	1,1,9,32,205,205,250,29,108,66,143,72,109,154,154,154,
	154,154,154,196,143,109,154,154,154,154,154,154,154,154,154,154,
	154,154,192,176,154,154,154,113,139,44,157,61,154,229,218,34,
	88,213,34,106,75,204,39,180,235,41,137,101,242,246,102,197,
	211,211,246,109,154,154,154,154,61,64,238,181,246,186,150,197,
	153,197,181,102,102,197,99,153,144,157,238,36,69,89,88,238,
	172,150,144,144,102,150,242,144,139,36,137,104,26,26,102,244,
	63,84,61,125,207,152,195,83,208,108,254,44,115,216,32,207,
	155,5,125,63,229,187,0,84,155,51,155,5,63,0,66,192,
	33,209,58,42,143,158,92,114,
	180,197,242,146,187,54,173,173,173,96,68,0,152,24,12,12,
	12,12,12,214,244,244,0,0,91,12,12,67,91,0,0,0,
	244,24,12,12,12,12,12,12,12,91,4,152,70,1,1,1,
	15,15,4,187,146,146,205,20,66,141,109,154,154,154,154,154,
	154,154,154,109,119,132,154,154,154,154,154,154,154,154,154,154,
	154,154,190,176,154,154,154,216,141,119,63,154,109,190,215,157,
	44,30,34,99,213,218,101,165,235,242,150,144,238,153,106,41,
	153,153,120,154,154,154,154,154,154,154,63,213,26,104,39,41,
	150,144,88,102,153,215,117,197,41,236,55,55,144,236,55,238,
	188,137,202,204,159,218,101,55,219,19,150,104,237,26,227,0,
	61,84,155,109,152,57,134,216,215,193,190,108,177,243,119,205,
	51,5,155,109,63,0,0,84,155,64,125,61,0,57,208,127,
	33,217,47,193,143,135,141,114,
	227,41,55,214,187,96,173,173,173,173,173,114,0,187,146,12,
	12,12,12,24,244,244,0,0,0,0,152,220,0,0,0,0,
	112,12,12,12,12,12,12,91,27,244,152,2,1,1,1,1,
	15,1,152,248,57,45,134,250,80,35,154,154,154,125,230,80,
	56,47,217,72,184,115,56,216,224,191,154,154,154,109,158,95,
	108,143,243,72,154,154,154,113,36,229,154,125,245,159,106,215,
	127,218,99,99,196,154,133,181,101,153,104,245,150,172,153,157,
	102,242,120,64,211,211,102,154,154,154,154,229,188,188,99,41,
	188,55,44,153,188,30,19,242,197,197,242,238,144,55,242,150,
	237,69,115,204,188,245,238,197,236,191,102,186,172,150,66,51,
	84,61,109,207,87,221,215,158,215,252,22,164,159,201,108,95,
	45,125,38,125,63,233,0,84,125,64,155,0,57,250,208,80,
	56,47,25,158,184,115,56,114,
	106,94,242,57,0,173,173,173,173,173,173,173,114,114,244,244,
	91,12,12,12,67,87,244,0,244,0,0,0,0,0,112,91,
	12,12,12,12,12,67,100,152,0,9,1,1,1,1,1,1,
	1,1,152,114,205,45,205,205,105,154,154,154,155,66,143,216,
	135,25,143,115,141,224,135,226,162,123,154,154,154,109,158,158,
	66,113,115,200,154,154,154,47,72,154,154,64,34,227,190,218,
	236,204,188,180,196,154,229,150,126,188,188,188,153,228,102,204,
	102,165,197,211,188,153,39,229,154,154,154,229,188,99,75,245,
	197,198,242,64,109,196,196,176,238,232,109,109,176,69,150,99,
	172,236,71,238,126,204,144,144,150,237,172,26,245,215,214,125,
	84,125,109,70,195,218,30,243,44,157,164,252,30,147,143,159,
	20,179,61,155,63,51,0,61,155,64,125,5,0,250,243,216,
	135,25,184,115,141,224,224,68,
	215,41,246,214,0,96,173,173,173,173,173,173,96,32,14,187,
	187,148,12,12,12,12,67,253,244,244,244,0,244,67,12,12,
	12,12,12,24,112,87,0,9,15,1,1,1,1,15,1,1,
	1,15,0,187,68,45,134,248,191,154,154,154,240,192,135,251,
	81,40,184,40,92,209,92,47,89,167,154,154,154,109,40,66,
	127,201,92,35,154,154,154,164,154,154,109,34,164,190,44,30,
	44,215,204,122,109,154,229,237,37,228,99,150,242,41,197,101,
	242,237,246,188,39,39,242,155,154,154,155,49,153,188,99,211,
	181,41,211,246,155,154,154,63,120,84,154,63,144,150,197,101,
	165,169,236,69,204,213,213,137,26,37,104,172,88,30,87,5,
	84,109,109,45,208,77,126,193,144,108,177,190,159,252,204,193,
	143,146,61,5,109,64,0,84,155,64,155,109,0,250,184,251,
	81,40,192,40,135,162,226,205,
	169,117,237,87,114,96,173,173,173,173,173,173,173,54,32,222,
	14,244,220,67,12,12,12,12,12,12,12,67,12,12,12,12,
	12,112,27,27,0,45,28,1,1,1,1,15,1,1,1,1,
	1,15,244,114,57,146,205,208,72,154,154,154,201,143,7,156,
	209,81,56,135,135,111,111,162,201,47,154,154,154,109,95,66,
	115,147,105,110,154,154,154,63,154,154,229,30,215,44,113,41,
	101,213,34,204,109,154,229,228,88,169,99,153,88,88,150,75,
	102,237,211,211,211,197,242,154,154,154,63,39,188,211,211,153,
	55,242,211,181,64,154,154,155,63,154,154,202,144,197,150,197,
	153,69,55,242,204,197,197,150,172,34,104,104,204,159,152,38,
	84,125,63,87,108,227,129,193,30,164,108,243,95,34,177,143,
	190,87,38,5,109,63,0,84,155,64,125,0,205,250,14,33,
	209,81,56,81,135,217,89,205,
	44,117,211,87,187,54,173,173,173,173,173,173,173,173,16,114,
	3,23,244,152,91,12,12,12,12,12,12,12,12,12,12,112,
	220,214,244,152,10,15,1,1,1,1,1,1,1,1,1,1,
	15,65,0,68,57,45,250,208,136,154,154,154,119,141,184,219,
	60,35,97,35,135,25,167,201,40,194,154,154,154,109,58,77,
	115,147,73,229,154,154,154,154,154,154,155,144,215,122,106,126,
	109,154,154,154,154,154,154,154,154,154,109,148,165,188,49,39,
	150,237,211,246,211,49,154,154,154,63,165,181,39,148,153,188,
	88,197,153,165,182,109,154,154,154,154,176,182,55,41,102,102,
	102,153,101,144,150,75,213,204,197,30,106,150,106,30,0,155,
	38,125,64,152,66,227,147,127,143,129,147,251,184,254,83,243,
	66,57,5,5,109,64,0,84,125,64,155,0,127,127,184,219,
	8,175,33,209,135,47,47,57,
	79,242,102,87,114,54,173,173,173,173,23,173,173,173,173,16,
	114,3,173,8,244,253,12,12,12,12,12,12,12,24,253,70,
	87,0,9,28,1,1,1,1,1,1,1,1,118,27,1,1,
	1,4,244,57,68,68,205,205,136,154,154,154,8,158,81,219,
	163,154,154,46,56,111,25,58,40,193,154,154,154,109,215,243,
	177,158,201,207,154,154,154,125,154,154,154,196,190,204,75,22,
	109,154,154,154,154,154,154,154,154,154,109,153,188,102,197,41,
	153,237,211,102,232,154,154,154,63,148,148,153,99,39,188,188,
	101,41,153,106,157,133,154,154,154,196,139,69,236,137,245,153,
	99,39,165,30,26,150,122,242,236,79,218,108,21,21,21,142,
	52,52,31,21,21,21,21,21,21,21,21,21,21,21,21,21,
	21,21,31,183,52,142,0,61,155,64,125,0,21,42,119,185,
	217,249,90,103,56,111,58,205,
	79,181,197,57,114,3,173,173,173,173,152,7,96,173,173,173,
	16,187,3,173,23,114,214,24,12,12,12,12,112,112,220,152,
	57,65,15,1,1,1,1,1,1,1,2,4,4,4,1,1,
	15,27,0,114,114,114,134,76,162,154,154,154,163,58,119,33,
	109,154,154,132,56,111,58,42,192,143,154,154,154,196,216,115,
	95,20,127,176,154,154,154,216,154,154,154,154,64,150,172,99,
	22,150,113,30,109,154,229,92,168,126,237,99,39,144,55,71,
	150,237,211,246,154,154,61,211,104,99,188,67,228,99,99,165,
	198,165,242,213,236,202,155,154,154,125,191,144,198,117,75,150,
	172,75,88,165,99,106,39,197,215,177,106,21,161,5,38,231,
	231,231,98,46,46,46,18,18,161,161,161,161,18,18,18,46,
	18,46,18,46,46,18,0,84,155,51,155,125,0,66,80,33,
	194,81,170,90,56,217,42,57,
	198,197,242,68,50,131,173,173,173,23,187,0,187,14,96,173,
	173,16,114,131,173,54,205,152,24,67,12,91,27,152,0,6,
	28,1,1,1,1,1,1,15,1,65,152,0,27,15,1,1,
	15,87,214,114,68,32,134,50,156,125,154,154,154,123,216,90,
	109,154,154,196,226,35,25,184,127,108,154,154,154,196,115,58,
	95,254,215,151,154,154,154,19,191,154,154,154,155,26,252,122,
	30,88,254,126,109,154,133,215,159,233,37,228,242,41,251,71,
	157,188,120,154,154,61,197,211,67,99,188,153,99,229,154,154,
	154,120,213,165,235,196,154,154,154,154,196,144,144,117,137,172,
	99,39,213,245,106,213,153,213,213,150,252,21,38,231,98,46,
	46,18,18,161,161,128,128,86,183,183,183,183,183,86,85,85,
	85,128,85,128,86,86,0,84,155,64,125,155,109,0,141,175,
	194,119,90,175,19,62,25,68,
	198,49,238,87,14,7,173,173,173,7,68,0,0,0,187,222,
	173,173,54,32,7,173,54,14,114,244,4,9,0,87,2,1,
	1,1,1,1,1,1,1,1,15,87,87,0,9,1,1,1,
	15,0,248,68,248,205,192,76,115,160,154,154,154,154,163,74,
	231,154,154,132,60,123,47,184,81,81,154,154,154,132,89,42,
	66,216,201,110,154,154,154,193,143,155,154,154,154,196,106,30,
	101,177,106,104,109,154,229,150,252,26,22,99,204,144,55,182,
	137,228,154,154,154,154,154,154,154,154,154,229,91,229,154,154,
	154,229,117,101,133,154,61,155,154,154,154,240,73,41,157,99,
	39,88,204,252,122,218,39,213,153,75,106,21,38,98,98,46,
	18,161,161,161,128,128,85,183,52,52,52,52,52,183,85,85,
	85,86,85,128,86,183,0,84,155,63,5,38,0,205,76,210,
	81,185,185,210,60,123,40,68,
	79,242,242,57,156,14,173,173,173,205,187,187,187,187,0,0,
	7,16,173,54,205,7,96,173,8,87,6,2,65,1,1,1,
	1,15,9,15,1,15,1,1,9,152,152,87,15,1,15,1,
	65,0,114,68,68,21,208,105,119,56,97,5,154,154,154,154,
	154,154,154,132,47,123,81,135,135,224,154,154,154,109,201,108,
	141,251,184,72,154,154,154,122,177,136,61,154,154,154,64,30,
	44,150,172,172,196,154,229,48,22,227,99,153,122,41,213,245,
	26,102,154,154,154,154,154,154,154,154,154,229,180,232,154,154,
	154,133,41,238,125,154,133,55,109,154,154,154,236,147,150,26,
	75,169,204,34,169,169,153,106,150,22,48,14,38,98,98,46,
	18,18,161,161,128,128,85,183,183,52,52,52,183,183,85,85,
	85,85,85,85,86,86,0,84,125,63,155,87,250,76,33,185,
	185,43,43,234,47,123,119,68,
	79,197,246,87,131,50,173,173,173,187,0,187,187,0,0,0,
	0,187,222,173,54,14,21,54,222,57,6,1,1,1,1,178,
	87,27,9,1,1,1,1,178,0,0,0,178,15,1,1,1,
	2,0,187,114,32,134,76,216,135,47,123,123,230,132,132,132,
	132,132,199,74,123,25,40,170,175,249,109,109,196,74,230,42,
	156,143,174,72,109,132,63,147,159,215,200,109,109,109,109,200,
	101,126,48,99,229,109,93,138,48,213,106,213,79,101,91,153,
	153,39,109,109,109,125,125,109,196,196,196,49,94,153,109,109,
	196,232,211,64,109,133,238,150,176,196,109,109,232,75,164,104,
	197,165,34,99,228,39,213,88,75,122,122,21,38,98,98,46,
	18,161,161,161,128,86,85,183,52,52,52,52,183,183,86,85,
	85,128,128,128,85,85,0,84,125,109,61,125,0,76,185,43,
	43,103,60,86,123,47,226,205,
	94,197,211,152,131,32,173,173,173,3,7,0,0,0,0,0,
	0,0,0,187,7,3,249,76,222,57,4,15,15,1,118,4,
	0,152,2,15,1,1,65,0,0,0,4,1,1,1,1,1,
	9,0,114,114,205,208,250,141,185,135,47,230,162,90,43,121,
	225,206,170,124,194,47,184,156,209,217,58,42,216,33,147,126,
	167,78,29,77,192,216,251,201,159,177,66,227,29,227,48,77,
	190,106,34,13,254,245,153,148,180,198,168,101,55,153,188,49,
	39,242,182,157,188,211,91,165,169,41,55,181,242,117,181,242,
	94,242,153,181,242,197,137,39,242,94,19,75,228,106,204,213,
	106,106,223,99,122,122,169,215,36,113,143,14,38,98,163,46,
	18,18,161,161,128,128,85,183,183,52,183,52,183,183,85,85,
	85,85,85,128,86,183,0,84,155,109,38,125,63,0,185,121,
	225,206,107,35,194,47,184,114,
	113,41,213,87,131,32,173,173,173,173,173,23,32,32,0,0,
	0,0,0,0,0,7,173,3,222,45,152,2,1,1,15,27,
	87,87,6,65,1,15,27,0,0,57,2,1,1,1,1,1,
	27,0,32,32,32,50,105,33,185,107,81,224,226,212,43,234,
	116,206,90,209,47,175,33,170,123,42,80,216,184,226,95,78,
	164,29,77,190,243,115,201,167,164,227,177,30,77,159,34,77,
	177,204,126,204,144,252,75,180,165,198,168,242,73,102,188,39,
	242,55,168,41,204,180,165,242,197,39,153,49,181,88,55,101,
	198,55,181,41,242,238,99,99,197,71,36,157,122,30,215,101,
	106,223,223,180,77,213,101,215,101,181,157,21,38,163,163,46,
	161,18,161,161,128,128,86,183,52,52,52,183,183,85,85,85,
	85,128,85,128,85,86,0,84,125,109,84,125,63,0,33,3,
	116,23,210,209,217,224,33,32,
	88,49,136,187,7,187,173,173,173,173,173,173,54,68,0,0,
	0,0,0,0,0,187,173,173,222,146,152,2,1,1,15,27,
	152,87,6,6,118,9,0,0,0,178,1,15,1,1,1,1,
	27,0,114,32,50,105,156,33,185,206,142,111,111,175,212,3,
	124,128,85,203,123,167,217,40,81,184,175,81,40,58,66,80,
	108,159,215,215,177,159,29,241,29,190,177,30,215,204,159,218,
	44,215,215,168,55,218,180,148,242,168,139,147,44,245,181,101,
	88,168,202,137,26,39,99,211,228,39,153,153,181,197,39,197,
	197,153,26,144,144,242,228,237,197,198,129,150,102,150,122,213,
	245,213,101,169,101,101,79,168,168,198,198,14,38,163,46,46,
	18,161,161,161,128,85,85,183,52,52,52,52,52,183,86,85,
	85,85,85,85,123,58,0,84,155,125,84,155,109,0,216,222,
	151,128,85,203,123,167,47,205,
	22,211,186,0,156,187,96,173,173,173,173,173,173,205,0,0,
	0,0,0,0,0,114,173,173,222,45,0,2,1,1,118,27,
	87,152,6,9,65,152,0,0,27,1,1,1,1,1,1,15,
	152,0,114,32,50,7,224,81,206,52,123,217,111,224,90,210,
	97,151,183,123,123,217,25,184,185,210,25,42,119,192,141,192,
	158,108,143,143,108,177,77,227,29,190,243,198,243,215,204,44,
	79,215,44,113,198,122,99,22,101,113,162,144,144,252,169,197,
	69,69,182,136,240,39,197,153,122,153,188,180,39,153,39,39,
	211,153,150,55,202,144,75,172,213,88,150,150,245,245,106,88,
	122,165,101,198,94,169,41,144,219,219,33,21,38,98,163,46,
	161,18,161,128,128,85,86,183,52,62,52,52,183,183,183,85,
	85,85,52,20,0,109,38,38,38,61,84,109,109,0,114,56,
	60,151,62,123,123,217,25,114,
	22,39,238,187,7,32,173,173,173,173,173,173,173,68,0,0,
	0,0,0,187,114,7,173,173,23,57,152,2,1,1,65,152,
	0,152,6,4,4,0,0,152,118,15,1,1,1,1,1,118,
	244,187,114,32,205,14,42,194,194,194,25,92,219,71,90,212,
	234,212,90,222,131,219,90,135,131,90,224,42,95,158,58,40,
	29,108,190,158,159,143,127,119,158,44,198,243,113,243,30,218,
	213,129,243,157,145,241,37,228,113,101,40,92,26,150,144,240,
	242,242,88,238,75,165,181,39,148,211,39,165,181,39,165,153,
	188,228,242,94,41,69,213,242,88,181,99,75,181,99,181,122,
	106,213,213,30,197,245,126,204,168,36,201,14,38,163,163,18,
	18,161,161,161,128,85,183,52,52,62,62,62,52,183,183,183,
	86,62,45,64,61,61,155,155,155,155,155,155,125,125,207,187,
	224,212,90,222,131,219,175,68,
	218,55,41,187,7,50,173,173,173,173,173,173,173,187,0,0,
	187,8,32,187,0,7,173,173,222,27,0,65,15,1,2,0,
	0,152,6,4,0,0,0,9,1,1,1,1,1,1,1,65,
	152,114,32,105,50,105,42,78,249,135,249,175,90,97,225,90,
	234,171,225,103,210,90,111,47,81,81,142,25,58,177,42,40,
	143,192,127,243,66,192,141,196,196,196,191,115,115,201,201,122,
	252,204,190,157,99,223,223,77,113,165,198,141,150,150,41,213,
	213,153,64,109,125,64,211,211,197,181,165,101,39,153,153,211,
	88,169,55,71,117,238,150,242,198,39,148,213,236,39,88,30,
	153,213,169,101,245,106,22,180,115,115,115,21,38,231,98,46,
	18,18,161,161,128,128,85,85,52,52,183,52,183,183,85,85,
	123,187,63,154,38,155,155,155,155,155,155,5,155,155,125,63,
	187,135,225,103,210,90,162,205,
	79,242,19,187,156,21,173,173,173,173,173,173,173,152,187,0,
	187,54,173,173,21,114,3,173,222,57,0,178,1,1,2,152,
	0,0,9,0,0,0,152,65,15,1,1,1,1,1,1,6,
	244,248,68,114,76,76,81,25,56,212,212,219,212,206,160,90,
	121,212,130,206,107,60,123,58,108,40,154,154,154,38,127,192,
	141,191,154,154,51,108,243,154,154,84,110,113,119,89,159,177,
	215,106,159,177,22,22,122,218,88,126,55,144,26,39,215,88,
	153,237,125,154,154,125,211,99,165,101,197,153,39,39,188,153,
	94,41,41,69,153,75,26,204,144,188,172,215,101,213,106,204,
	99,180,218,88,204,180,228,180,44,243,201,14,38,98,163,18,
	18,161,161,128,128,85,183,52,52,62,52,52,52,183,183,183,
	57,63,84,5,155,155,155,155,155,155,5,155,5,155,155,125,
	63,187,170,60,103,60,123,57,
	180,49,41,187,76,32,173,173,173,173,173,173,173,0,0,0,
	187,96,173,173,96,173,173,173,222,152,0,6,1,1,2,152,
	0,152,27,0,0,0,0,152,65,1,1,1,1,1,1,4,
	152,114,205,68,76,7,92,119,175,140,43,121,121,210,60,160,
	212,206,128,85,124,62,194,56,184,243,64,154,154,154,64,95,
	58,109,154,51,95,243,127,154,154,154,72,92,159,252,78,227,
	159,126,106,190,177,30,30,106,75,75,165,157,157,157,144,242,
	197,39,109,154,154,109,41,169,41,213,153,153,165,181,153,99,
	39,238,41,41,238,153,150,204,150,99,22,122,88,213,153,153,
	99,75,122,75,75,204,75,180,30,44,201,21,38,98,98,18,
	18,18,161,128,128,85,85,52,52,52,52,52,183,183,183,20,
	207,84,61,155,155,125,125,125,125,125,125,125,125,125,155,155,
	125,207,208,52,124,62,78,32,
	106,41,44,187,14,32,96,173,173,173,173,173,96,244,0,187,
	114,173,173,173,173,173,173,173,222,87,0,178,1,1,2,0,
	0,0,0,0,0,27,27,152,0,4,118,1,1,1,1,27,
	0,205,205,205,105,156,249,209,60,160,103,225,128,74,123,217,
	210,206,60,171,130,31,17,25,209,81,47,154,154,154,154,58,
	155,154,125,126,108,190,141,154,154,154,229,174,158,95,95,122,
	190,106,34,177,88,215,218,34,122,44,44,190,215,242,44,245,
	237,211,109,154,154,109,197,41,242,26,186,153,165,153,211,99,
	39,88,115,41,215,157,157,157,99,106,39,181,215,215,75,227,
	188,213,106,252,227,77,122,122,34,30,143,14,38,98,98,46,
	18,18,161,161,161,85,85,183,52,62,52,52,52,52,123,0,
	61,84,155,155,155,125,155,155,155,5,155,5,5,84,5,5,
	5,125,0,81,234,62,194,205,
	30,101,69,68,32,50,173,173,173,173,173,173,54,0,0,0,
	50,173,173,173,173,173,173,173,222,152,0,65,1,1,2,0,
	0,0,0,87,9,0,87,87,152,0,0,65,1,1,15,27,
	0,68,57,32,105,156,217,60,170,81,124,35,85,189,189,209,
	212,130,81,103,85,123,8,56,156,156,184,72,154,154,154,38,
	154,154,200,190,20,254,83,154,154,154,151,66,243,190,143,63,
	196,196,109,77,44,190,204,34,30,44,176,109,109,109,109,207,
	246,228,109,154,154,109,238,245,157,109,109,93,39,245,34,99,
	39,101,242,144,73,150,245,157,245,39,106,122,215,88,245,75,
	99,138,106,75,227,122,180,34,138,138,77,21,38,98,46,18,
	161,18,161,128,128,86,183,183,52,52,52,52,183,183,58,63,
	84,155,155,155,155,125,155,155,155,155,5,155,5,84,5,155,
	5,125,207,250,62,123,8,114,
	122,197,69,187,32,32,173,173,173,173,173,173,54,187,0,0,
	7,173,173,173,173,173,173,173,222,87,152,65,1,1,2,152,
	0,0,0,15,15,2,0,152,0,152,152,0,27,1,15,87,
	0,114,32,32,76,184,17,233,103,124,52,74,85,203,111,212,
	103,35,36,160,203,203,35,162,185,219,184,119,154,154,154,154,
	154,196,113,215,108,192,141,154,154,154,72,141,251,133,154,154,
	154,154,154,154,229,204,150,252,215,125,154,154,154,154,154,125,
	204,88,109,154,154,109,102,232,61,154,63,150,181,122,39,181,
	213,213,69,204,245,150,204,150,153,153,99,34,204,204,106,138,
	99,39,180,138,227,227,122,180,138,227,108,14,38,98,46,46,
	161,161,128,128,85,85,183,62,62,62,62,52,52,183,146,5,
	38,155,155,155,155,125,5,155,5,155,155,5,155,84,5,5,
	5,38,64,114,233,203,230,205,
	122,245,75,187,114,32,173,173,173,173,173,173,54,187,0,0,
	3,173,173,173,173,173,173,173,8,152,152,118,1,1,2,152,
	0,0,118,1,1,1,65,152,0,0,0,0,0,9,65,27,
	0,205,205,205,14,7,194,17,40,151,124,60,60,209,224,212,
	52,35,90,206,151,151,123,136,90,90,135,184,89,154,154,154,
	154,35,115,73,201,254,243,154,154,154,176,139,36,154,154,154,
	125,61,154,154,154,240,252,227,64,154,154,154,109,109,125,196,
	202,202,109,154,154,109,245,229,154,154,120,75,79,204,150,122,
	245,204,75,34,75,153,99,211,172,172,172,188,22,77,122,180,
	22,180,180,34,34,122,122,99,227,204,254,21,38,163,46,18,
	161,18,161,128,85,85,52,52,31,62,31,62,62,52,87,84,
	155,155,155,155,155,61,84,84,84,84,84,84,84,84,5,5,
	5,5,109,0,167,123,136,146,
	227,172,172,187,114,50,173,173,173,173,173,173,23,0,0,0,
	222,173,173,173,173,173,173,173,222,0,0,15,1,1,178,0,
	0,0,15,1,15,1,1,1,65,87,0,152,2,15,1,27,
	152,68,57,32,105,216,158,47,226,35,103,43,212,103,175,43,
	140,212,43,206,183,124,209,209,222,60,62,217,201,154,154,154,
	154,110,115,115,216,141,115,154,154,154,97,115,155,154,154,155,
	77,159,61,154,154,125,245,102,154,154,154,125,172,88,139,139,
	139,19,196,154,154,109,120,154,154,229,237,99,106,102,150,213,
	150,22,99,228,150,106,75,99,104,48,172,22,77,82,218,180,
	77,180,75,106,106,218,77,227,180,218,250,14,38,163,98,18,
	18,161,161,128,128,85,183,52,62,62,52,52,52,183,0,84,
	155,155,155,155,155,155,155,155,155,5,155,5,155,5,5,5,
	5,38,63,0,194,35,81,205,
	77,153,211,32,32,32,173,173,173,173,173,173,222,187,0,0,
	3,173,173,173,173,173,173,173,8,152,0,15,1,1,6,0,
	0,152,1,1,1,1,1,1,1,118,4,9,1,1,15,27,
	0,187,187,114,50,156,217,135,185,210,234,212,239,52,103,234,
	160,43,43,103,217,81,40,103,90,249,40,58,217,154,154,154,
	154,125,191,92,193,69,147,154,154,154,151,158,154,154,154,176,
	34,26,109,154,154,154,30,120,154,154,154,150,213,198,251,33,
	137,136,125,154,154,155,155,154,154,229,99,99,150,102,172,150,
	204,99,172,180,213,218,106,172,99,188,148,180,218,77,88,106,
	204,106,106,227,190,82,218,227,180,221,190,21,38,98,163,18,
	18,161,161,128,128,85,85,183,52,52,52,52,183,52,0,84,
	155,155,155,155,5,155,5,5,5,155,5,5,5,5,5,5,
	5,155,109,0,20,8,81,205,
	190,150,150,205,3,14,173,173,173,173,173,173,96,187,0,0,
	3,173,173,173,173,173,173,173,8,152,0,15,1,1,9,0,
	0,87,1,1,1,1,1,1,1,15,1,1,1,1,65,152,
	0,68,134,32,50,7,25,56,107,225,103,103,85,62,111,206,
	35,234,225,86,25,249,158,25,249,123,25,58,154,154,154,154,
	154,154,64,240,123,230,143,154,154,154,151,201,154,154,154,151,
	150,223,109,154,154,154,215,133,154,154,154,245,101,251,71,111,
	186,172,109,154,154,61,61,154,154,154,232,153,181,75,204,165,
	215,75,39,30,88,44,245,252,106,180,122,213,88,198,215,30,
	106,122,77,77,122,218,204,34,106,122,159,14,38,163,163,46,
	161,161,161,128,128,85,183,52,62,62,62,62,52,52,87,84,
	155,155,155,155,5,155,5,155,155,125,125,5,5,5,5,5,
	5,155,109,187,66,184,158,205,
	77,238,215,37,7,32,3,173,173,173,173,173,173,173,187,0,
	3,173,173,173,173,173,173,173,8,0,152,1,1,1,9,152,
	0,4,1,1,1,1,1,1,1,1,1,1,1,15,4,152,
	205,57,114,105,14,158,119,185,60,209,90,86,189,72,140,140,
	60,107,225,206,212,43,131,119,81,58,78,151,154,38,56,154,
	154,154,154,203,240,164,174,154,154,154,120,33,38,154,154,63,
	73,213,125,154,154,38,204,93,154,154,154,191,113,198,137,93,
	233,26,125,154,154,109,196,154,154,154,63,41,150,246,122,88,
	75,245,218,106,213,252,126,218,30,39,228,99,180,213,172,99,
	75,106,204,106,75,106,75,227,180,106,227,21,38,46,46,18,
	161,161,161,128,85,85,183,183,52,52,52,52,183,183,146,61,
	5,5,155,5,155,5,109,63,0,0,149,84,84,5,5,5,
	5,155,63,114,7,185,7,32,
	180,102,150,26,179,87,114,14,16,173,173,173,173,173,96,14,
	3,173,173,173,173,173,173,173,184,0,27,1,1,1,4,0,
	152,9,1,1,1,1,1,1,1,1,1,1,118,4,70,0,
	0,114,187,32,250,20,184,185,103,217,103,52,207,35,140,43,
	209,124,124,131,234,3,52,209,42,58,78,154,154,51,47,72,
	154,154,154,109,158,158,95,154,154,154,229,115,64,154,154,154,
	64,125,154,154,154,133,41,204,155,154,154,154,176,133,51,64,
	165,197,109,154,154,109,229,61,154,154,154,133,102,99,75,137,
	153,99,157,150,213,102,22,30,150,150,22,172,99,34,172,99,
	180,34,138,180,227,34,227,34,34,99,227,14,38,163,163,18,
	161,161,128,128,85,183,52,52,62,62,62,52,52,183,58,51,
	84,155,155,5,155,125,63,0,17,42,29,0,84,84,5,5,
	155,125,93,32,131,107,31,205,
	149,211,102,213,13,57,57,0,114,131,173,173,173,173,173,173,
	173,173,173,173,173,173,173,173,8,0,4,1,1,15,87,152,
	27,6,1,1,1,1,1,1,1,1,1,178,27,70,87,0,
	187,57,205,205,146,20,7,7,183,123,62,35,72,124,170,43,
	206,62,123,60,222,52,31,142,25,20,51,154,196,81,193,159,
	154,154,154,154,200,113,115,154,154,154,151,56,162,64,154,154,
	84,154,154,154,133,113,89,89,200,125,154,154,154,154,154,125,
	242,242,196,154,154,109,188,120,154,154,154,154,93,34,237,223,
	180,153,150,213,218,99,172,180,106,180,228,99,22,34,48,100,
	228,180,34,99,99,22,180,34,22,180,29,250,183,128,161,86,
	86,86,52,52,52,31,142,25,25,142,25,142,142,142,25,0,
	84,5,155,155,5,125,0,194,42,21,250,17,93,61,61,5,
	155,109,0,20,249,52,142,205,
	22,102,150,122,159,29,48,20,187,68,131,173,173,173,173,173,
	173,173,173,173,173,173,173,173,14,0,9,1,1,1,9,87,
	9,15,1,1,1,1,1,15,1,15,9,87,152,0,21,114,
	87,205,57,205,250,66,76,249,123,72,217,60,209,209,43,43,
	206,25,25,217,40,131,60,42,42,72,196,196,192,42,108,159,
	136,109,109,132,51,162,115,196,196,109,129,143,230,186,186,109,
	125,109,109,201,198,129,186,145,177,168,110,196,109,109,109,64,
	157,69,64,109,109,64,188,99,64,196,109,125,109,39,99,99,
	104,104,245,122,75,246,172,122,126,39,99,34,34,153,172,228,
	228,138,228,22,22,99,22,22,48,48,29,20,21,21,21,21,
	21,21,21,32,205,205,32,32,32,68,114,68,68,32,205,152,
	63,84,5,155,155,125,0,32,205,66,158,158,186,61,61,155,
	109,179,68,42,42,249,60,205,
	48,150,144,30,164,159,221,48,26,146,244,249,173,173,173,173,
	173,173,173,173,173,173,173,173,21,0,9,1,1,178,9,118,
	15,1,1,1,1,1,1,1,65,27,87,0,244,87,87,57,
	57,68,68,146,250,76,76,40,217,201,111,170,185,90,212,234,
	116,142,40,230,167,249,209,62,25,42,184,81,80,143,20,66,
	143,193,174,47,40,226,224,175,135,158,254,88,159,252,245,159,
	37,145,159,44,73,26,37,172,177,19,19,33,69,72,200,69,
	69,69,126,232,179,59,246,153,55,198,137,186,245,153,188,153,
	104,245,73,30,126,172,106,75,144,30,34,227,122,30,34,34,
	180,122,180,106,22,34,22,22,22,22,138,77,66,195,208,66,
	208,250,208,208,70,208,70,20,20,20,66,146,70,208,146,208,
	152,61,61,5,155,125,0,174,42,80,40,111,93,61,5,109,
	64,152,80,95,193,184,81,146,
	180,213,55,190,190,218,221,77,207,17,146,0,14,173,173,173,
	173,173,173,173,173,173,173,173,205,0,6,1,1,65,1,1,
	1,1,1,15,1,1,15,9,152,0,0,66,114,87,87,57,
	68,68,205,70,205,105,56,42,81,158,217,210,234,206,60,16,
	52,123,193,40,230,194,58,58,25,119,216,184,40,66,192,80,
	192,95,95,108,201,119,216,135,111,119,44,141,236,158,126,95,
	159,159,177,180,99,172,172,204,30,44,56,162,230,240,137,201,
	200,150,252,93,237,186,150,144,41,157,26,126,106,200,150,153,
	75,165,198,190,177,101,218,245,218,30,227,159,169,215,106,34,
	77,149,180,22,180,138,77,100,22,22,77,190,221,190,227,177,
	254,83,208,77,20,77,108,29,100,208,141,141,192,70,77,77,
	146,0,61,84,5,5,155,0,194,42,72,0,84,5,109,64,
	152,70,20,42,217,194,58,68,
	138,102,157,30,159,77,122,29,195,26,164,146,152,14,96,173,
	173,173,173,173,173,173,173,173,87,0,6,1,1,1,1,1,
	1,1,1,1,1,118,27,152,152,87,208,87,57,205,57,68,
	114,205,146,21,50,156,103,142,184,81,217,90,23,142,194,23,
	123,194,58,42,17,194,58,119,80,224,216,42,174,158,192,243,
	44,108,159,20,177,201,119,162,233,174,129,145,26,174,145,164,
	177,30,30,204,34,223,106,159,30,198,92,19,240,186,73,30,
	72,186,26,186,245,30,122,197,150,150,172,213,204,157,215,180,
	99,223,204,30,227,122,213,223,77,75,172,223,122,34,172,172,
	34,75,106,138,77,149,138,180,138,138,122,190,190,30,177,177,
	190,254,159,227,29,164,227,20,254,141,76,119,95,164,108,66,
	76,250,152,125,84,61,5,5,0,0,0,154,61,63,179,152,
	250,58,20,42,167,17,58,68,
	48,26,245,204,252,104,227,77,77,221,241,164,87,0,205,96,
	173,173,173,173,173,173,173,173,152,0,178,1,1,1,1,1,
	1,1,1,15,6,152,0,0,187,114,68,57,57,57,114,114,
	205,146,205,105,156,56,62,194,249,60,111,56,23,40,233,142,
	17,111,217,78,58,95,58,20,119,201,162,167,29,159,143,42,
	95,158,108,143,190,143,158,40,174,158,158,174,73,73,157,150,
	26,73,115,115,95,34,252,174,144,44,226,226,129,136,242,200,
	237,26,26,36,144,157,129,26,150,75,153,102,150,69,157,26,
	104,172,204,204,145,186,99,227,106,34,34,22,34,180,172,100,
	77,180,34,77,77,106,34,227,122,77,218,254,44,215,122,227,
	227,223,252,164,29,177,44,127,251,224,201,164,241,138,80,216,
	192,108,208,187,149,63,63,125,155,5,155,109,186,0,45,80,
	58,158,47,78,78,95,158,57,
	138,150,144,101,30,180,227,79,195,127,134,227,164,45,152,114,
	96,173,173,173,173,173,173,16,87,0,178,1,1,1,1,1,
	15,1,118,9,0,0,146,244,57,57,57,45,57,68,32,134,
	70,208,50,105,81,158,25,42,184,111,162,131,62,194,194,249,
	194,40,167,78,95,143,95,164,108,216,249,40,95,66,192,143,
	108,44,192,216,254,66,159,201,108,73,73,73,158,159,164,252,
	162,243,115,92,177,108,143,139,198,147,69,126,129,240,150,186,
	93,186,223,30,238,102,93,26,75,69,157,150,126,157,73,102,
	223,75,30,55,30,106,106,44,79,113,141,44,177,221,227,180,
	34,22,100,100,22,22,100,180,122,77,79,77,204,30,245,204,
	252,223,34,29,108,243,243,168,193,129,145,78,159,141,115,158,
	164,108,76,105,184,57,87,0,0,0,0,187,146,70,20,7,
	194,58,167,58,58,66,108,57,
	227,102,204,30,204,164,106,44,30,227,192,66,70,29,70,57,
	152,16,173,173,173,173,173,23,87,0,2,1,15,1,1,1,
	15,6,0,0,0,244,187,68,57,45,146,45,205,68,208,208,
	70,205,50,141,158,25,25,141,184,226,230,90,62,95,58,156,
	111,201,58,58,66,80,158,108,66,216,184,47,47,226,119,108,
	108,66,135,115,143,108,201,192,192,158,174,129,233,126,159,30,
	139,127,89,240,129,30,243,198,56,162,129,126,126,157,240,150,
	186,246,245,144,230,137,73,204,213,73,69,30,106,147,198,126,
	223,126,30,177,106,223,75,218,245,126,30,193,227,77,34,106,
	180,180,138,22,180,180,77,77,204,122,218,204,30,44,159,77,
	177,159,34,177,254,113,115,201,26,241,48,164,66,192,73,78,
	95,192,216,184,25,58,58,76,80,208,42,14,25,20,20,156,
	25,119,58,58,143,80,158,57,
	77,204,204,30,75,99,77,79,227,34,221,108,20,70,186,70,
	57,152,222,173,173,173,173,222,87,0,65,1,1,1,1,65,
	4,152,0,68,152,114,87,57,45,45,45,205,57,195,70,70,
	208,192,115,201,143,174,42,184,209,193,230,56,217,58,20,156,
	8,135,40,47,119,119,40,66,158,143,201,158,193,115,192,95,
	108,201,184,184,119,201,119,115,40,193,227,252,223,164,159,158,
	115,147,233,17,73,147,73,157,139,201,177,30,158,69,162,193,
	252,150,245,73,240,69,73,137,144,69,30,177,150,41,144,137,
	75,106,30,30,245,223,77,79,75,150,177,252,34,227,77,221,
	227,138,180,22,138,122,218,254,44,190,215,227,221,215,158,243,
	177,108,252,215,254,198,30,95,145,241,48,177,190,108,252,29,
	143,119,119,19,119,167,66,14,162,158,47,156,194,42,20,156,
	81,135,40,25,201,119,201,68,
	227,197,236,44,30,204,204,204,99,159,77,77,70,70,70,146,
	29,57,152,222,173,173,173,8,0,0,65,1,15,1,178,152,
	0,244,87,87,68,57,57,205,45,146,146,146,208,70,20,208,
	127,141,192,141,143,40,192,115,40,184,25,56,217,201,193,224,
	135,40,217,158,143,119,192,158,193,108,159,158,115,226,40,29,
	66,243,216,115,19,143,141,56,201,95,95,145,145,34,227,30,
	192,174,237,145,147,92,73,26,89,89,69,36,119,139,226,230,
	240,137,73,157,200,159,240,72,102,69,147,186,200,147,89,172,
	252,204,44,44,30,204,245,204,99,252,106,159,138,122,34,30,
	106,106,180,180,180,218,254,198,190,30,34,122,30,126,158,44,
	126,129,204,106,177,252,174,164,29,34,159,215,158,95,29,177,
	141,141,115,192,119,40,184,224,40,184,58,56,111,42,174,184,
	135,40,217,158,143,119,143,57,
	164,150,69,30,204,34,204,30,22,252,227,77,138,77,77,70,
	70,145,70,152,40,173,173,8,152,0,118,1,118,2,87,0,
	68,57,57,57,57,45,146,45,45,205,134,134,208,70,208,250,
	105,184,119,184,40,42,33,224,226,115,25,33,47,81,167,81,
	56,217,136,167,167,193,158,159,158,95,227,95,184,226,167,174,
	73,141,216,56,147,89,184,115,201,159,95,172,164,29,227,177,
	119,164,145,164,215,36,73,26,73,73,89,191,135,56,19,89,
	111,89,157,191,150,145,93,186,145,144,137,186,153,157,238,26,
	145,245,88,215,204,34,245,177,34,223,106,227,48,22,34,106,
	34,227,75,106,227,218,190,198,218,223,223,22,22,252,190,201,
	245,159,172,34,164,164,164,48,77,190,190,243,177,108,108,141,
	251,56,81,243,47,42,216,224,226,115,47,156,47,81,111,201,
	56,217,230,167,174,193,108,205,
	227,144,44,177,240,157,190,101,106,245,190,77,29,227,221,134,
	208,70,146,29,152,57,206,7,57,0,118,6,87,244,152,87,
	114,87,45,45,45,45,45,146,205,248,208,208,20,20,127,105,
	33,40,40,243,47,119,216,92,81,162,230,175,47,184,40,42,
	184,191,167,145,95,164,95,164,20,164,227,143,192,89,174,174,
	201,141,92,226,40,167,143,60,47,108,177,159,204,227,159,159,
	158,158,227,77,193,201,215,245,115,201,126,129,159,162,210,90,
	92,19,137,150,159,186,26,150,75,215,200,150,26,137,144,26,
	126,30,243,177,129,157,190,101,213,245,215,177,34,34,108,254,
	77,138,138,180,106,122,177,218,106,34,22,77,149,106,190,204,
	215,138,37,172,22,227,227,77,254,254,143,108,95,108,141,251,
	33,40,162,143,47,201,156,92,81,209,230,224,209,184,25,42,
	184,35,17,129,95,164,95,57,
	66,69,202,162,193,215,113,113,215,88,243,73,30,190,195,254,
	77,70,70,149,29,244,152,152,0,0,9,27,152,68,114,87,
	87,57,45,45,45,205,45,146,134,195,66,29,29,66,127,216,
	115,167,95,243,111,119,81,230,47,111,95,135,191,81,194,158,
	216,217,174,164,174,233,167,145,108,227,20,115,192,145,164,158,
	177,119,226,201,129,174,158,40,193,201,108,193,73,73,157,159,
	190,243,66,147,73,143,73,73,92,137,26,240,89,69,56,103,
	162,73,230,157,150,136,245,215,204,162,162,73,73,147,147,126,
	227,144,92,162,157,143,113,113,215,30,198,73,106,218,208,198,
	75,34,22,172,48,227,122,252,37,228,34,77,177,204,190,159,
	122,223,172,48,227,215,77,77,243,243,158,159,164,77,141,156,
	115,123,158,243,89,119,92,217,193,230,95,201,191,8,47,95,
	216,47,174,164,174,233,145,57,
	29,69,44,201,158,147,92,36,193,193,215,159,126,252,177,143,
	138,29,149,149,70,29,87,152,0,114,151,70,250,57,87,57,
	45,45,146,146,195,146,208,208,66,192,20,29,29,77,243,224,
	119,194,164,95,193,184,126,95,158,167,78,158,47,115,17,164,
	33,40,167,129,145,145,174,164,177,73,201,141,158,172,29,243,
	201,119,115,119,193,95,201,119,89,193,36,92,192,215,177,227,
	215,201,119,198,44,215,69,47,89,174,157,30,135,19,226,111,
	62,72,230,137,240,137,92,89,69,19,202,89,30,139,162,89,
	126,204,198,201,201,147,92,36,193,193,215,193,126,245,158,30,
	164,22,34,104,48,22,34,34,48,138,34,159,204,73,215,159,
	78,145,223,227,159,108,158,177,201,201,159,78,48,77,141,115,
	119,167,164,159,40,184,230,159,95,217,95,201,89,119,233,227,
	33,40,167,129,145,174,78,45,
	108,236,157,72,215,157,78,157,137,150,34,223,37,172,48,48,
	149,100,70,149,70,70,93,57,244,214,146,57,214,57,57,57,
	68,57,45,70,70,70,70,70,221,149,70,138,177,190,254,138,
	48,126,177,201,115,201,252,177,119,111,92,135,209,115,167,78,
	56,201,167,126,119,42,95,227,95,174,30,190,174,164,177,177,
	159,108,119,162,174,159,204,164,252,164,193,92,201,126,145,223,
	177,158,204,201,159,159,167,204,30,157,159,73,200,89,159,129,
	129,233,186,102,186,93,150,93,240,129,129,102,137,150,129,233,
	157,44,159,136,215,157,164,126,129,137,48,223,37,37,48,48,
	149,48,100,148,138,180,227,34,30,177,227,34,48,48,48,29,
	190,190,138,223,48,138,227,149,77,138,149,138,159,190,190,138,
	48,174,177,177,115,201,252,143,147,230,226,139,209,115,167,174,
	56,201,167,174,143,42,158,57,
	177,147,117,129,73,150,204,159,227,172,29,37,37,37,48,48,
	70,77,221,221,149,149,70,186,152,114,45,45,45,57,57,57,
	214,205,70,70,70,70,100,221,221,77,138,227,122,254,177,159,
	227,215,30,215,216,115,159,243,119,158,243,92,111,201,167,78,
	115,226,136,174,204,167,164,95,227,108,190,190,164,95,221,108,
	159,177,147,119,145,129,126,164,164,164,177,177,129,233,145,227,
	215,157,215,157,157,204,174,215,73,129,157,159,230,193,126,240,
	150,240,129,157,129,26,26,246,137,150,137,73,89,136,93,72,
	73,44,69,157,73,126,204,204,227,223,227,37,37,172,241,172,
	221,227,221,13,22,228,180,99,149,77,180,22,48,22,22,77,
	83,77,99,241,48,29,223,13,77,227,138,106,215,190,215,159,
	180,215,201,215,216,143,159,243,143,193,243,226,217,201,194,78,
	115,162,136,126,73,167,164,57,
	143,191,36,73,26,233,26,34,252,26,241,237,241,9,172,48,
	83,177,82,221,138,149,149,4,195,146,253,146,253,45,146,220,
	57,221,70,149,149,70,100,149,122,77,30,77,218,190,215,30,
	30,113,215,190,115,89,193,141,193,193,201,162,47,66,145,167,
	201,143,240,174,157,167,95,108,190,66,218,177,164,108,108,106,
	177,190,141,243,145,174,157,145,174,227,177,204,164,78,164,126,
	204,174,190,193,129,126,95,159,126,159,126,193,129,126,129,126,
	126,102,230,73,73,240,93,237,89,186,200,36,19,69,129,119,
	226,89,201,204,26,233,26,34,164,26,241,237,37,9,67,48,
	83,204,218,218,22,48,22,48,138,138,22,172,148,180,228,138,
	218,223,138,148,48,100,48,24,122,77,106,77,218,218,215,30,
	30,198,143,44,113,89,193,141,40,193,201,162,47,66,145,167,
	119,143,233,174,157,167,95,57,
	193,230,69,136,186,241,37,172,241,48,37,104,48,148,100,149,
	82,204,221,122,48,138,149,149,149,70,146,70,146,220,45,70,
	195,70,70,149,70,221,149,138,221,82,177,190,215,215,190,215,
	243,143,158,88,143,230,193,115,89,89,115,147,47,95,26,145,
	73,177,167,164,164,26,164,164,177,77,159,159,29,29,159,254,
	190,177,147,201,145,159,177,126,77,218,34,106,34,227,215,44,
	177,95,215,108,204,108,177,159,164,159,193,30,240,129,157,204,
	240,137,69,129,191,72,186,126,157,186,186,103,135,145,26,191,
	230,230,144,136,240,241,37,172,37,48,241,237,48,100,100,149,
	82,204,13,122,172,22,148,48,48,138,48,22,180,221,138,22,
	77,180,149,22,149,13,138,138,218,82,190,190,190,215,190,215,
	243,44,159,201,147,217,193,115,89,193,139,119,193,174,26,145,
	73,201,129,145,164,26,95,57,
	143,73,137,73,26,241,138,104,48,48,9,148,48,24,24,13,
	13,22,13,22,172,100,149,149,70,146,146,195,57,134,146,70,
	195,82,221,29,138,218,82,122,221,82,44,215,122,215,190,92,
	215,159,159,243,177,40,119,141,193,40,216,224,136,240,174,159,
	158,177,164,145,145,145,159,77,20,227,227,29,190,190,215,127,
	252,106,201,201,164,159,190,30,30,75,227,29,164,254,83,113,
	252,227,254,190,243,66,30,158,227,159,254,89,252,252,157,73,
	201,73,89,137,204,240,129,157,242,237,223,36,162,179,179,126,
	201,30,89,204,26,37,138,172,48,48,9,148,48,24,24,13,
	13,138,149,148,172,100,24,22,180,221,138,180,190,218,122,22,
	218,218,77,99,227,218,13,138,221,254,215,30,177,215,190,92,
	215,95,159,44,177,193,119,141,89,158,56,115,35,167,126,159,
	108,177,227,233,223,241,159,87,
	177,136,240,77,145,37,99,37,172,48,148,100,100,24,180,100,
	100,100,24,100,100,149,221,77,221,220,112,82,134,195,221,149,
	221,134,13,227,221,79,218,149,221,254,254,215,122,122,215,147,
	215,29,177,113,204,73,141,243,193,201,56,19,47,174,158,66,
	164,204,95,145,164,164,227,177,145,227,29,29,221,254,215,127,
	95,227,215,177,164,227,254,204,164,164,227,227,190,83,44,126,
	164,77,218,159,254,30,159,204,227,243,243,69,193,252,129,44,
	162,200,102,99,75,102,157,243,144,102,150,157,230,93,59,129,
	252,240,145,77,241,37,99,37,172,48,148,100,100,24,100,180,
	100,100,149,148,48,149,221,122,122,253,122,218,127,44,75,22,
	122,82,77,22,77,79,218,149,13,254,254,44,122,122,215,147,
	143,227,77,113,159,73,115,141,95,226,216,19,47,145,159,66,
	164,204,95,145,164,223,108,57,
	223,179,207,37,241,180,48,172,100,24,149,149,149,100,24,100,
	24,149,149,149,112,218,221,218,221,221,149,134,134,254,77,149,
	221,70,138,138,82,82,77,70,149,254,83,254,227,106,190,141,
	75,48,177,215,245,177,92,73,164,143,56,162,230,17,159,193,
	164,106,164,164,48,29,190,177,164,100,149,149,195,127,44,127,
	95,149,208,192,138,77,192,34,164,20,254,215,243,254,204,164,
	29,70,208,66,66,215,108,227,159,215,141,243,177,126,204,201,
	89,129,252,204,137,233,129,129,240,26,172,150,37,233,223,126,
	102,37,186,145,241,22,48,172,100,24,149,149,24,100,100,24,
	138,24,149,149,112,13,122,218,218,149,180,82,79,143,106,138,
	77,221,138,180,82,82,77,70,149,254,79,254,227,106,190,127,
	252,22,177,44,204,177,147,204,164,201,141,162,230,17,159,193,
	164,106,95,164,48,29,66,214,
	146,100,27,57,87,152,152,152,152,152,152,152,152,152,244,244,
	244,244,244,152,244,152,244,0,244,152,244,152,152,152,152,0,
	244,0,244,244,0,244,152,152,244,244,244,0,244,152,152,244,
	152,152,244,187,244,244,244,152,152,244,0,244,87,87,152,152,
	0,0,244,152,0,152,0,0,152,244,152,0,0,0,0,0,
	152,244,0,0,244,152,0,244,0,0,0,244,244,244,244,0,
	0,0,244,244,244,0,244,244,244,0,187,0,244,152,152,187,
	152,187,187,152,87,152,152,152,152,187,187,152,152,87,152,152,
	152,152,87,152,152,244,152,152,152,152,152,152,152,152,0,244,
	244,0,0,244,244,152,0,244,152,152,152,152,244,152,152,152,
	0,87,152,244,0,152,152,152,0,244,0,0,0,87,152,187,
	152,152,244,152,152,0,152,152,152,0,187,244,87,152,152,152,
	152,0,152,152,0,152,244,0
	};
