/* engine.c generated by valac 0.26.0.83-ed603-dirty, the Vala compiler
 * generated from engine.vala, do not modify */

/* 
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <libkkc/libkkc.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libutil.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <gdk/gdk.h>


#define TYPE_KKC_ENGINE (kkc_engine_get_type ())
#define KKC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KKC_ENGINE, KkcEngine))
#define KKC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KKC_ENGINE, KkcEngineClass))
#define IS_KKC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KKC_ENGINE))
#define IS_KKC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KKC_ENGINE))
#define KKC_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KKC_ENGINE, KkcEngineClass))

typedef struct _KkcEngine KkcEngine;
typedef struct _KkcEngineClass KkcEngineClass;
typedef struct _KkcEnginePrivate KkcEnginePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcEngine {
	IBusEngine parent_instance;
	KkcEnginePrivate * priv;
};

struct _KkcEngineClass {
	IBusEngineClass parent_class;
};

struct _KkcEnginePrivate {
	KkcContext* context;
	IBusLookupTable* lookup_table;
	gboolean lookup_table_visible;
	gboolean use_custom_keymap;
	gboolean show_annotation;
	IBusKeymap* keymap;
	IBusProperty* input_mode_prop;
	IBusPropList* prop_list;
	gboolean properties_registered;
	GeeMap* input_mode_props;
	GeeMap* input_mode_symbols;
	GeeMap* name_input_modes;
	GtkClipboard* clipboard;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
	guint save_dictionaries_timeout_id;
};


static gpointer kkc_engine_parent_class = NULL;
static Preferences* kkc_engine_preferences;
static Preferences* kkc_engine_preferences = NULL;
static GeeArrayList* kkc_engine_dictionaries;
static GeeArrayList* kkc_engine_dictionaries = NULL;
static KkcLanguageModel* kkc_engine_language_model;
static KkcLanguageModel* kkc_engine_language_model = NULL;
static gboolean kkc_engine_ibus;
static gboolean kkc_engine_ibus = FALSE;

GType kkc_engine_get_type (void) G_GNUC_CONST;
#define KKC_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KKC_ENGINE, KkcEnginePrivate))
enum  {
	KKC_ENGINE_DUMMY_PROPERTY
};
static void kkc_engine_set_selection_text (GtkClipboard* clipboard, const gchar* text, KkcEngine* self);
static void kkc_engine_populate_lookup_table (KkcEngine* self);
static void kkc_engine_set_lookup_table_cursor_pos (KkcEngine* self);
static void kkc_engine_update_preedit (KkcEngine* self);
static void kkc_engine_update_candidates (KkcEngine* self);
static void kkc_engine_update_input_mode (KkcEngine* self);
static void kkc_engine_reload_dictionaries (void);
static void kkc_engine_apply_preferences (KkcEngine* self);
static IBusProperty* kkc_engine_register_input_mode_property (KkcEngine* self, KkcInputMode mode, const gchar* name, const gchar* label, const gchar* symbol);
static gboolean kkc_engine_process_lookup_table_key_event (KkcEngine* self, guint keyval, guint keycode, guint state);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static gboolean kkc_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state);
static void kkc_engine_real_enable (IBusEngine* base);
static gboolean __lambda4_ (KkcEngine* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static void kkc_engine_real_disable (IBusEngine* base);
static void kkc_engine_real_reset (IBusEngine* base);
static void kkc_engine_real_focus_in (IBusEngine* base);
static void kkc_engine_real_focus_out (IBusEngine* base);
static void kkc_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state);
static void kkc_engine_real_candidate_clicked (IBusEngine* base, guint index, guint button, guint state);
static void kkc_engine_real_cursor_up (IBusEngine* base);
static void kkc_engine_real_cursor_down (IBusEngine* base);
static void kkc_engine_real_page_up (IBusEngine* base);
static void kkc_engine_real_page_down (IBusEngine* base);
gint kkc_engine_main (gchar** args, int args_length1);
static void __lambda5_ (void);
static void ___lambda5__ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static void __lambda6_ (const gchar* name, GVariant* value);
static void ___lambda6__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
KkcEngine* kkc_engine_new (void);
KkcEngine* kkc_engine_construct (GType object_type);
static GObject * kkc_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _kkc_engine___lambda7_ (KkcEngine* self, const gchar* name, GVariant* value);
static void __kkc_engine___lambda7__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
static void _kkc_engine___lambda8_ (KkcEngine* self);
static void __kkc_engine___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_engine___lambda9_ (KkcEngine* self, GObject* s, GParamSpec* p);
static void __kkc_engine___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_engine___lambda10_ (KkcEngine* self);
static void __kkc_engine___lambda10__kkc_candidate_list_populated (KkcCandidateList* _sender, gpointer self);
static void _kkc_engine___lambda11_ (KkcEngine* self);
static void __kkc_engine___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_engine___lambda12_ (KkcEngine* self);
static void __kkc_engine___lambda12__kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self);
static void _kkc_engine___lambda13_ (KkcEngine* self, KkcContext* e);
static void __kkc_engine___lambda13__kkc_context_request_selection_text (KkcContext* _sender, gpointer self);
static void kkc_engine_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry KKC_ENGINE_options[2] = {{"ibus", 'i', 0, G_OPTION_ARG_NONE, &kkc_engine_ibus, "Component is executed by IBus", NULL}, {NULL}};

static void kkc_engine_set_selection_text (GtkClipboard* clipboard, const gchar* text, KkcEngine* self) {
	KkcContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = text;
	kkc_context_set_selection_text (_tmp0_, _tmp1_);
}


static void kkc_engine_populate_lookup_table (KkcEngine* self) {
	IBusLookupTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lookup_table;
	ibus_lookup_table_clear (_tmp0_);
	{
		gint i = 0;
		KkcContext* _tmp1_ = NULL;
		KkcCandidateList* _tmp2_ = NULL;
		KkcCandidateList* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp1_ = self->priv->context;
		_tmp2_ = kkc_context_get_candidates (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = kkc_candidate_list_get_page_start (_tmp3_);
		_tmp5_ = _tmp4_;
		i = (gint) _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				KkcContext* _tmp9_ = NULL;
				KkcCandidateList* _tmp10_ = NULL;
				KkcCandidateList* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				IBusText* text = NULL;
				KkcContext* _tmp14_ = NULL;
				KkcCandidateList* _tmp15_ = NULL;
				KkcCandidateList* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				KkcCandidate* _tmp18_ = NULL;
				KkcCandidate* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				IBusText* _tmp22_ = NULL;
				IBusText* _tmp23_ = NULL;
				IBusLookupTable* _tmp24_ = NULL;
				IBusText* _tmp25_ = NULL;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = self->priv->context;
				_tmp10_ = kkc_context_get_candidates (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = kkc_candidate_list_get_size (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp8_ < _tmp13_)) {
					break;
				}
				_tmp14_ = self->priv->context;
				_tmp15_ = kkc_context_get_candidates (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = i;
				_tmp18_ = kkc_candidate_list_get (_tmp16_, _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = kkc_candidate_get_output (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = ibus_text_new_from_string (_tmp21_);
				g_object_ref_sink (_tmp22_);
				_tmp23_ = _tmp22_;
				_g_object_unref0 (_tmp19_);
				text = _tmp23_;
				_tmp24_ = self->priv->lookup_table;
				_tmp25_ = text;
				ibus_lookup_table_append_candidate (_tmp24_, _tmp25_);
				_g_object_unref0 (text);
			}
		}
	}
}


static void kkc_engine_set_lookup_table_cursor_pos (KkcEngine* self) {
	IBusText* empty_text = NULL;
	IBusText* _tmp0_ = NULL;
	gint cursor_pos = 0;
	KkcContext* _tmp1_ = NULL;
	KkcCandidateList* _tmp2_ = NULL;
	KkcCandidateList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	KkcContext* _tmp6_ = NULL;
	KkcCandidateList* _tmp7_ = NULL;
	KkcCandidateList* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp0_);
	empty_text = _tmp0_;
	_tmp1_ = self->priv->context;
	_tmp2_ = kkc_context_get_candidates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = kkc_candidate_list_get_cursor_pos (_tmp3_);
	_tmp5_ = _tmp4_;
	cursor_pos = _tmp5_;
	_tmp6_ = self->priv->context;
	_tmp7_ = kkc_context_get_candidates (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = kkc_candidate_list_get_page_visible (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		IBusLookupTable* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		KkcContext* _tmp13_ = NULL;
		KkcCandidateList* _tmp14_ = NULL;
		KkcCandidateList* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		IBusLookupTable* _tmp18_ = NULL;
		KkcCandidate* candidate = NULL;
		KkcContext* _tmp19_ = NULL;
		KkcCandidateList* _tmp20_ = NULL;
		KkcCandidateList* _tmp21_ = NULL;
		KkcCandidate* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		_tmp11_ = self->priv->lookup_table;
		_tmp12_ = cursor_pos;
		_tmp13_ = self->priv->context;
		_tmp14_ = kkc_context_get_candidates (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = kkc_candidate_list_get_page_start (_tmp15_);
		_tmp17_ = _tmp16_;
		ibus_lookup_table_set_cursor_pos (_tmp11_, _tmp12_ - _tmp17_);
		_tmp18_ = self->priv->lookup_table;
		ibus_engine_update_lookup_table_fast ((IBusEngine*) self, _tmp18_, TRUE);
		_tmp19_ = self->priv->context;
		_tmp20_ = kkc_context_get_candidates (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = kkc_candidate_list_get (_tmp21_, -1);
		candidate = _tmp22_;
		_tmp24_ = self->priv->show_annotation;
		if (_tmp24_) {
			KkcCandidate* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			_tmp25_ = candidate;
			_tmp26_ = kkc_candidate_get_annotation (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			IBusText* text = NULL;
			KkcCandidate* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			IBusText* _tmp31_ = NULL;
			IBusText* _tmp32_ = NULL;
			_tmp28_ = candidate;
			_tmp29_ = kkc_candidate_get_annotation (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = ibus_text_new_from_string (_tmp30_);
			g_object_ref_sink (_tmp31_);
			text = _tmp31_;
			_tmp32_ = text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp32_, TRUE);
			_g_object_unref0 (text);
		} else {
			IBusText* _tmp33_ = NULL;
			_tmp33_ = empty_text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp33_, FALSE);
		}
		self->priv->lookup_table_visible = TRUE;
		_g_object_unref0 (candidate);
	} else {
		gboolean _tmp34_ = FALSE;
		_tmp34_ = self->priv->lookup_table_visible;
		if (_tmp34_) {
			ibus_engine_hide_lookup_table ((IBusEngine*) self);
			ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
			self->priv->lookup_table_visible = FALSE;
		}
	}
	_g_object_unref0 (empty_text);
}


static void kkc_engine_update_preedit (KkcEngine* self) {
	IBusText* text = NULL;
	guint cursor_pos = 0U;
	KkcContext* _tmp0_ = NULL;
	KkcSegmentList* _tmp1_ = NULL;
	KkcSegmentList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	IBusText* _tmp90_ = NULL;
	guint _tmp91_ = 0U;
	KkcContext* _tmp95_ = NULL;
	gboolean _tmp96_ = FALSE;
	IBusText* _tmp102_ = NULL;
	guint _tmp103_ = 0U;
	IBusText* _tmp104_ = NULL;
	guint _tmp105_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_segments (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_segment_list_get_cursor_pos (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ >= 0) {
		KkcContext* _tmp5_ = NULL;
		KkcSegmentList* _tmp6_ = NULL;
		KkcSegmentList* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		IBusText* _tmp10_ = NULL;
		gint index = 0;
		gint offset = 0;
		IBusText* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		KkcContext* _tmp32_ = NULL;
		KkcSegmentList* _tmp33_ = NULL;
		KkcSegmentList* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		KkcSegment* _tmp36_ = NULL;
		KkcSegment* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		IBusText* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		KkcContext* _tmp44_ = NULL;
		KkcSegmentList* _tmp45_ = NULL;
		KkcSegmentList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		KkcSegment* _tmp48_ = NULL;
		KkcSegment* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = kkc_context_get_segments (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = kkc_segment_list_get_output (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = ibus_text_new_from_string (_tmp9_);
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (text);
		text = _tmp10_;
		_g_free0 (_tmp9_);
		index = 0;
		offset = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				KkcContext* _tmp14_ = NULL;
				KkcSegmentList* _tmp15_ = NULL;
				KkcSegmentList* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				KkcContext* _tmp20_ = NULL;
				KkcSegmentList* _tmp21_ = NULL;
				KkcSegmentList* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				KkcSegment* _tmp24_ = NULL;
				KkcSegment* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = index;
					index = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = index;
				_tmp14_ = self->priv->context;
				_tmp15_ = kkc_context_get_segments (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = kkc_segment_list_get_cursor_pos (_tmp16_);
				_tmp18_ = _tmp17_;
				if (!(_tmp13_ < _tmp18_)) {
					break;
				}
				_tmp19_ = offset;
				_tmp20_ = self->priv->context;
				_tmp21_ = kkc_context_get_segments (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = index;
				_tmp24_ = kkc_segment_list_get (_tmp22_, _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = kkc_segment_get_output (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_utf8_strlen (_tmp27_, (gssize) (-1));
				offset = _tmp19_ + _tmp28_;
				_g_object_unref0 (_tmp25_);
			}
		}
		_tmp29_ = text;
		_tmp30_ = offset;
		_tmp31_ = offset;
		_tmp32_ = self->priv->context;
		_tmp33_ = kkc_context_get_segments (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = index;
		_tmp36_ = kkc_segment_list_get (_tmp34_, _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = kkc_segment_get_output (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_utf8_strlen (_tmp39_, (gssize) (-1));
		ibus_text_append_attribute (_tmp29_, (guint) IBUS_ATTR_TYPE_BACKGROUND, (guint) 0x00c8c8f0, (guint) _tmp30_, _tmp31_ + _tmp40_);
		_g_object_unref0 (_tmp37_);
		_tmp41_ = text;
		_tmp42_ = offset;
		_tmp43_ = offset;
		_tmp44_ = self->priv->context;
		_tmp45_ = kkc_context_get_segments (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = index;
		_tmp48_ = kkc_segment_list_get (_tmp46_, _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = kkc_segment_get_output (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_utf8_strlen (_tmp51_, (gssize) (-1));
		ibus_text_append_attribute (_tmp41_, (guint) IBUS_ATTR_TYPE_FOREGROUND, (guint) 0x00000000, (guint) _tmp42_, _tmp43_ + _tmp52_);
		_g_object_unref0 (_tmp49_);
		_tmp53_ = offset;
		cursor_pos = (guint) _tmp53_;
	} else {
		KkcContext* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		IBusText* _tmp58_ = NULL;
		gboolean _tmp59_ = FALSE;
		IBusText* _tmp60_ = NULL;
		guint _tmp61_ = 0U;
		_tmp54_ = self->priv->context;
		_tmp55_ = kkc_context_get_input (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _tmp56_;
		_tmp58_ = ibus_text_new_from_string (_tmp57_);
		g_object_ref_sink (_tmp58_);
		_g_object_unref0 (text);
		text = _tmp58_;
		_g_free0 (_tmp57_);
		_tmp60_ = text;
		_tmp61_ = ibus_text_get_length (_tmp60_);
		if (_tmp61_ > ((guint) 0)) {
			KkcContext* _tmp62_ = NULL;
			gint _tmp63_ = 0;
			gint _tmp64_ = 0;
			_tmp62_ = self->priv->context;
			_tmp63_ = kkc_context_get_input_cursor_pos (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp59_ = _tmp64_ >= 0;
		} else {
			_tmp59_ = FALSE;
		}
		if (_tmp59_) {
			IBusText* _tmp65_ = NULL;
			KkcContext* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			KkcContext* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			KkcContext* _tmp72_ = NULL;
			guint _tmp73_ = 0U;
			guint _tmp74_ = 0U;
			IBusText* _tmp75_ = NULL;
			KkcContext* _tmp76_ = NULL;
			gint _tmp77_ = 0;
			gint _tmp78_ = 0;
			KkcContext* _tmp79_ = NULL;
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
			KkcContext* _tmp82_ = NULL;
			guint _tmp83_ = 0U;
			guint _tmp84_ = 0U;
			KkcContext* _tmp85_ = NULL;
			gint _tmp86_ = 0;
			gint _tmp87_ = 0;
			_tmp65_ = text;
			_tmp66_ = self->priv->context;
			_tmp67_ = kkc_context_get_input_cursor_pos (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = self->priv->context;
			_tmp70_ = kkc_context_get_input_cursor_pos (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = self->priv->context;
			_tmp73_ = kkc_context_get_input_cursor_width (_tmp72_);
			_tmp74_ = _tmp73_;
			ibus_text_append_attribute (_tmp65_, (guint) IBUS_ATTR_TYPE_BACKGROUND, (guint) 0x00000000, (guint) _tmp68_, _tmp71_ + ((gint) _tmp74_));
			_tmp75_ = text;
			_tmp76_ = self->priv->context;
			_tmp77_ = kkc_context_get_input_cursor_pos (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = self->priv->context;
			_tmp80_ = kkc_context_get_input_cursor_pos (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = self->priv->context;
			_tmp83_ = kkc_context_get_input_cursor_width (_tmp82_);
			_tmp84_ = _tmp83_;
			ibus_text_append_attribute (_tmp75_, (guint) IBUS_ATTR_TYPE_FOREGROUND, (guint) 0xffffffffLL, (guint) _tmp78_, _tmp81_ + ((gint) _tmp84_));
			_tmp85_ = self->priv->context;
			_tmp86_ = kkc_context_get_input_cursor_pos (_tmp85_);
			_tmp87_ = _tmp86_;
			cursor_pos = (guint) _tmp87_;
		} else {
			IBusText* _tmp88_ = NULL;
			guint _tmp89_ = 0U;
			_tmp88_ = text;
			_tmp89_ = ibus_text_get_length (_tmp88_);
			cursor_pos = _tmp89_;
		}
	}
	_tmp90_ = text;
	_tmp91_ = ibus_text_get_length (_tmp90_);
	if (_tmp91_ > ((guint) 0)) {
		IBusText* _tmp92_ = NULL;
		IBusText* _tmp93_ = NULL;
		guint _tmp94_ = 0U;
		_tmp92_ = text;
		_tmp93_ = text;
		_tmp94_ = ibus_text_get_length (_tmp93_);
		ibus_text_append_attribute (_tmp92_, (guint) IBUS_ATTR_TYPE_UNDERLINE, (guint) IBUS_ATTR_UNDERLINE_SINGLE, (guint) 0, (gint) _tmp94_);
	}
	_tmp95_ = self->priv->context;
	_tmp96_ = kkc_context_has_output (_tmp95_);
	if (_tmp96_) {
		gchar* output = NULL;
		KkcContext* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		IBusText* ctext = NULL;
		const gchar* _tmp99_ = NULL;
		IBusText* _tmp100_ = NULL;
		IBusText* _tmp101_ = NULL;
		_tmp97_ = self->priv->context;
		_tmp98_ = kkc_context_poll_output (_tmp97_);
		output = _tmp98_;
		_tmp99_ = output;
		_tmp100_ = ibus_text_new_from_string (_tmp99_);
		g_object_ref_sink (_tmp100_);
		ctext = _tmp100_;
		_tmp101_ = ctext;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp101_);
		_g_object_unref0 (ctext);
		_g_free0 (output);
	}
	_tmp102_ = text;
	_tmp103_ = cursor_pos;
	_tmp104_ = text;
	_tmp105_ = ibus_text_get_length (_tmp104_);
	ibus_engine_update_preedit_text ((IBusEngine*) self, _tmp102_, _tmp103_, _tmp105_ > ((guint) 0));
	_g_object_unref0 (text);
}


static void kkc_engine_update_candidates (KkcEngine* self) {
	g_return_if_fail (self != NULL);
	kkc_engine_populate_lookup_table (self);
	kkc_engine_set_lookup_table_cursor_pos (self);
}


static void kkc_engine_update_input_mode (KkcEngine* self) {
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	IBusText* symbol = NULL;
	GeeMap* _tmp16_ = NULL;
	KkcContext* _tmp17_ = NULL;
	KkcInputMode _tmp18_ = 0;
	KkcInputMode _tmp19_ = 0;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	IBusText* _tmp22_ = NULL;
	IBusText* _tmp23_ = NULL;
	IBusText* label = NULL;
	const gchar* _tmp24_ = NULL;
	IBusText* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	IBusText* _tmp29_ = NULL;
	IBusText* _tmp30_ = NULL;
	IBusProperty* _tmp31_ = NULL;
	IBusText* _tmp32_ = NULL;
	IBusProperty* _tmp33_ = NULL;
	IBusText* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_mode_props;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		KkcInputMode input_mode = 0;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		IBusProperty* prop = NULL;
		GeeMapIterator* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		KkcInputMode _tmp8_ = 0;
		KkcContext* _tmp9_ = NULL;
		KkcInputMode _tmp10_ = 0;
		KkcInputMode _tmp11_ = 0;
		gboolean _tmp14_ = FALSE;
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
		input_mode = (KkcInputMode) ((gintptr) _tmp5_);
		_tmp6_ = iter;
		_tmp7_ = gee_map_iterator_get_value (_tmp6_);
		prop = (IBusProperty*) _tmp7_;
		_tmp8_ = input_mode;
		_tmp9_ = self->priv->context;
		_tmp10_ = kkc_context_get_input_mode (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp8_ == _tmp11_) {
			IBusProperty* _tmp12_ = NULL;
			_tmp12_ = prop;
			ibus_property_set_state (_tmp12_, PROP_STATE_CHECKED);
		} else {
			IBusProperty* _tmp13_ = NULL;
			_tmp13_ = prop;
			ibus_property_set_state (_tmp13_, PROP_STATE_UNCHECKED);
		}
		_tmp14_ = self->priv->properties_registered;
		if (_tmp14_) {
			IBusProperty* _tmp15_ = NULL;
			_tmp15_ = prop;
			ibus_engine_update_property ((IBusEngine*) self, _tmp15_);
		}
		_g_object_unref0 (prop);
	}
	_tmp16_ = self->priv->input_mode_symbols;
	_tmp17_ = self->priv->context;
	_tmp18_ = kkc_context_get_input_mode (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gee_map_get (_tmp16_, (gpointer) ((gintptr) _tmp19_));
	_tmp21_ = (gchar*) _tmp20_;
	_tmp22_ = ibus_text_new_from_string (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	symbol = _tmp23_;
	_tmp24_ = _ ("Input Mode (%s)");
	_tmp25_ = symbol;
	_tmp26_ = _tmp25_->text;
	_tmp27_ = g_strdup_printf (_tmp24_, _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = ibus_text_new_from_string (_tmp28_);
	g_object_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	label = _tmp30_;
	_tmp31_ = self->priv->input_mode_prop;
	_tmp32_ = label;
	ibus_property_set_label (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->input_mode_prop;
	_tmp34_ = symbol;
	ibus_property_set_symbol (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->properties_registered;
	if (_tmp35_) {
		IBusProperty* _tmp36_ = NULL;
		_tmp36_ = self->priv->input_mode_prop;
		ibus_engine_update_property ((IBusEngine*) self, _tmp36_);
	}
	_g_object_unref0 (label);
	_g_object_unref0 (symbol);
	_g_object_unref0 (iter);
}


static void kkc_engine_reload_dictionaries (void) {
	GeeArrayList* _tmp0_ = NULL;
	GVariant* variant = NULL;
	Preferences* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	Preferences* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	gchar** strv = NULL;
	GVariant* _tmp16_ = NULL;
	size_t _tmp17_;
	gchar** _tmp18_ = NULL;
	gint strv_length1 = 0;
	gint _strv_size_ = 0;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = kkc_engine_dictionaries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = kkc_engine_preferences;
	_tmp2_ = preferences_get (_tmp1_, "user_dictionary");
	_g_variant_unref0 (variant);
	variant = _tmp2_;
	_tmp3_ = variant;
	if (_tmp3_ != NULL) {
		{
			KkcUserDictionary* _tmp4_ = NULL;
			GVariant* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			KkcUserDictionary* _tmp7_ = NULL;
			GeeArrayList* _tmp8_ = NULL;
			_tmp5_ = variant;
			_tmp6_ = g_variant_get_string (_tmp5_, NULL);
			_tmp7_ = kkc_user_dictionary_new (_tmp6_, &_inner_error_);
			_tmp4_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = kkc_engine_dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, (KkcDictionary*) _tmp4_);
			_g_object_unref0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GVariant* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = variant;
			_tmp10_ = g_variant_get_string (_tmp9_, NULL);
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("engine.vala:317: can't load user dictionary %s: %s", _tmp10_, _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_variant_unref0 (variant);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = kkc_engine_preferences;
	_tmp14_ = preferences_get (_tmp13_, "system_dictionaries");
	_g_variant_unref0 (variant);
	variant = _tmp14_;
	_tmp15_ = variant;
	_vala_assert (_tmp15_ != NULL, "variant != null");
	_tmp16_ = variant;
	_tmp18_ = g_variant_dup_strv (_tmp16_, &_tmp17_);
	strv = _tmp18_;
	strv_length1 = _tmp17_;
	_strv_size_ = strv_length1;
	_tmp19_ = strv;
	_tmp19__length1 = strv_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp19_;
		id_collection_length1 = _tmp19__length1;
		for (id_it = 0; id_it < _tmp19__length1; id_it = id_it + 1) {
			gchar* _tmp20_ = NULL;
			gchar* id = NULL;
			_tmp20_ = g_strdup (id_collection[id_it]);
			id = _tmp20_;
			{
				DictionaryMetadata* metadata = NULL;
				Preferences* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				DictionaryMetadata* _tmp23_ = NULL;
				_tmp21_ = kkc_engine_preferences;
				_tmp22_ = id;
				_tmp23_ = preferences_get_dictionary_metadata (_tmp21_, _tmp22_);
				metadata = _tmp23_;
				{
					KkcSystemSegmentDictionary* _tmp24_ = NULL;
					DictionaryMetadata* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					DictionaryMetadata* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					KkcSystemSegmentDictionary* _tmp31_ = NULL;
					GeeArrayList* _tmp32_ = NULL;
					_tmp25_ = metadata;
					_tmp26_ = dictionary_metadata_get_filename (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = metadata;
					_tmp29_ = dictionary_metadata_get_encoding (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = kkc_system_segment_dictionary_new (_tmp27_, _tmp30_, &_inner_error_);
					_tmp24_ = _tmp31_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp32_ = kkc_engine_dictionaries;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, (KkcDictionary*) _tmp24_);
					_g_object_unref0 (_tmp24_);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					DictionaryMetadata* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					GError* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp33_ = metadata;
					_tmp34_ = dictionary_metadata_get_filename (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = e;
					_tmp37_ = _tmp36_->message;
					g_warning ("engine.vala:333: can't load system dictionary %s: %s", _tmp35_, _tmp37_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (metadata);
					_g_free0 (id);
					strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_unref0 (variant);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (metadata);
				_g_free0 (id);
			}
		}
	}
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void kkc_engine_apply_preferences (KkcEngine* self) {
	GVariant* variant = NULL;
	Preferences* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	KkcContext* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	gint32 _tmp5_ = 0;
	Preferences* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	KkcContext* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	Preferences* _tmp12_ = NULL;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	KkcContext* _tmp15_ = NULL;
	KkcCandidateList* _tmp16_ = NULL;
	KkcCandidateList* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	gint32 _tmp19_ = 0;
	IBusLookupTable* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	gint32 _tmp22_ = 0;
	Preferences* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	KkcContext* _tmp26_ = NULL;
	KkcCandidateList* _tmp27_ = NULL;
	KkcCandidateList* _tmp28_ = NULL;
	GVariant* _tmp29_ = NULL;
	gint32 _tmp30_ = 0;
	Preferences* _tmp31_ = NULL;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	KkcContext* _tmp34_ = NULL;
	GVariant* _tmp35_ = NULL;
	gint32 _tmp36_ = 0;
	Preferences* _tmp37_ = NULL;
	GVariant* _tmp38_ = NULL;
	GVariant* _tmp39_ = NULL;
	GVariant* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	Preferences* _tmp42_ = NULL;
	GVariant* _tmp43_ = NULL;
	GVariant* _tmp44_ = NULL;
	KkcRuleMetadata* parent_metadata = NULL;
	GVariant* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	KkcRuleMetadata* _tmp47_ = NULL;
	gchar* base_dir = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	Preferences* _tmp57_ = NULL;
	GVariant* _tmp58_ = NULL;
	GVariant* _tmp59_ = NULL;
	GVariant* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	Preferences* _tmp62_ = NULL;
	GVariant* _tmp63_ = NULL;
	GVariant* _tmp64_ = NULL;
	GVariant* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	IBusKeymap* _tmp67_ = NULL;
	IBusKeymap* _tmp68_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = kkc_engine_preferences;
	_tmp1_ = preferences_get (_tmp0_, "punctuation_style");
	_g_variant_unref0 (variant);
	variant = _tmp1_;
	_tmp2_ = variant;
	_vala_assert (_tmp2_ != NULL, "variant != null");
	_tmp3_ = self->priv->context;
	_tmp4_ = variant;
	_tmp5_ = g_variant_get_int32 (_tmp4_);
	kkc_context_set_punctuation_style (_tmp3_, (KkcPunctuationStyle) _tmp5_);
	_tmp6_ = kkc_engine_preferences;
	_tmp7_ = preferences_get (_tmp6_, "auto_correct");
	_g_variant_unref0 (variant);
	variant = _tmp7_;
	_tmp8_ = variant;
	_vala_assert (_tmp8_ != NULL, "variant != null");
	_tmp9_ = self->priv->context;
	_tmp10_ = variant;
	_tmp11_ = g_variant_get_boolean (_tmp10_);
	kkc_context_set_auto_correct (_tmp9_, _tmp11_);
	_tmp12_ = kkc_engine_preferences;
	_tmp13_ = preferences_get (_tmp12_, "page_size");
	_g_variant_unref0 (variant);
	variant = _tmp13_;
	_tmp14_ = variant;
	_vala_assert (_tmp14_ != NULL, "variant != null");
	_tmp15_ = self->priv->context;
	_tmp16_ = kkc_context_get_candidates (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = variant;
	_tmp19_ = g_variant_get_int32 (_tmp18_);
	kkc_candidate_list_set_page_size (_tmp17_, (guint) _tmp19_);
	_tmp20_ = self->priv->lookup_table;
	_tmp21_ = variant;
	_tmp22_ = g_variant_get_int32 (_tmp21_);
	ibus_lookup_table_set_page_size (_tmp20_, (guint) _tmp22_);
	_tmp23_ = kkc_engine_preferences;
	_tmp24_ = preferences_get (_tmp23_, "pagination_start");
	_g_variant_unref0 (variant);
	variant = _tmp24_;
	_tmp25_ = variant;
	_vala_assert (_tmp25_ != NULL, "variant != null");
	_tmp26_ = self->priv->context;
	_tmp27_ = kkc_context_get_candidates (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = variant;
	_tmp30_ = g_variant_get_int32 (_tmp29_);
	kkc_candidate_list_set_page_start (_tmp28_, (guint) _tmp30_);
	_tmp31_ = kkc_engine_preferences;
	_tmp32_ = preferences_get (_tmp31_, "initial_input_mode");
	_g_variant_unref0 (variant);
	variant = _tmp32_;
	_tmp33_ = variant;
	_vala_assert (_tmp33_ != NULL, "variant != null");
	_tmp34_ = self->priv->context;
	_tmp35_ = variant;
	_tmp36_ = g_variant_get_int32 (_tmp35_);
	kkc_context_set_input_mode (_tmp34_, (KkcInputMode) _tmp36_);
	_tmp37_ = kkc_engine_preferences;
	_tmp38_ = preferences_get (_tmp37_, "show_annotation");
	_g_variant_unref0 (variant);
	variant = _tmp38_;
	_tmp39_ = variant;
	_vala_assert (_tmp39_ != NULL, "variant != null");
	_tmp40_ = variant;
	_tmp41_ = g_variant_get_boolean (_tmp40_);
	self->priv->show_annotation = _tmp41_;
	_tmp42_ = kkc_engine_preferences;
	_tmp43_ = preferences_get (_tmp42_, "typing_rule");
	_g_variant_unref0 (variant);
	variant = _tmp43_;
	_tmp44_ = variant;
	_vala_assert (_tmp44_ != NULL, "variant != null");
	_tmp45_ = variant;
	_tmp46_ = g_variant_get_string (_tmp45_, NULL);
	_tmp47_ = kkc_rule_metadata_find (_tmp46_);
	parent_metadata = _tmp47_;
	_vala_assert (parent_metadata != NULL, "parent_metadata != null");
	_tmp48_ = g_get_user_config_dir ();
	_tmp49_ = g_build_filename (_tmp48_, "ibus-kkc", "rules", NULL);
	base_dir = _tmp49_;
	{
		KkcUserRule* _tmp50_ = NULL;
		KkcUserRule* _tmp51_ = NULL;
		KkcContext* _tmp52_ = NULL;
		_tmp51_ = kkc_user_rule_new (parent_metadata, base_dir, "ibus-kkc", &_inner_error_);
		_tmp50_ = _tmp51_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp52_ = self->priv->context;
		kkc_context_set_typing_rule (_tmp52_, (KkcRule*) _tmp50_);
		_g_object_unref0 (_tmp50_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GVariant* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		GError* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp53_ = variant;
		_tmp54_ = g_variant_get_string (_tmp53_, NULL);
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		g_warning ("engine.vala:383: can't load typing rule %s: %s", _tmp54_, _tmp56_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (base_dir);
		_g_object_unref0 (parent_metadata);
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp57_ = kkc_engine_preferences;
	_tmp58_ = preferences_get (_tmp57_, "use_custom_keymap");
	_g_variant_unref0 (variant);
	variant = _tmp58_;
	_tmp59_ = variant;
	_vala_assert (_tmp59_ != NULL, "variant != null");
	_tmp60_ = variant;
	_tmp61_ = g_variant_get_boolean (_tmp60_);
	self->priv->use_custom_keymap = _tmp61_;
	_tmp62_ = kkc_engine_preferences;
	_tmp63_ = preferences_get (_tmp62_, "keymap");
	_g_variant_unref0 (variant);
	variant = _tmp63_;
	_tmp64_ = variant;
	_vala_assert (_tmp64_ != NULL, "variant != null");
	_tmp65_ = variant;
	_tmp66_ = g_variant_get_string (_tmp65_, NULL);
	_tmp67_ = ibus_keymap_get (_tmp66_);
	_tmp68_ = _g_object_ref0 (_tmp67_);
	_g_object_unref0 (self->priv->keymap);
	self->priv->keymap = _tmp68_;
	_g_free0 (base_dir);
	_g_object_unref0 (parent_metadata);
	_g_variant_unref0 (variant);
}


static IBusProperty* kkc_engine_register_input_mode_property (KkcEngine* self, KkcInputMode mode, const gchar* name, const gchar* label, const gchar* symbol) {
	IBusProperty* result = NULL;
	IBusProperty* prop = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	IBusText* _tmp2_ = NULL;
	IBusText* _tmp3_ = NULL;
	IBusProperty* _tmp4_ = NULL;
	IBusProperty* _tmp5_ = NULL;
	GeeMap* _tmp6_ = NULL;
	KkcInputMode _tmp7_ = 0;
	GeeMap* _tmp8_ = NULL;
	KkcInputMode _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	GeeMap* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	KkcInputMode _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = label;
	_tmp2_ = ibus_text_new_from_string (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = ibus_property_new (_tmp0_, PROP_TYPE_RADIO, _tmp3_, NULL, NULL, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	prop = _tmp5_;
	_tmp6_ = self->priv->input_mode_props;
	_tmp7_ = mode;
	gee_map_set (_tmp6_, (gpointer) ((gintptr) _tmp7_), prop);
	_tmp8_ = self->priv->input_mode_symbols;
	_tmp9_ = mode;
	_tmp10_ = symbol;
	gee_map_set (_tmp8_, (gpointer) ((gintptr) _tmp9_), _tmp10_);
	_tmp11_ = self->priv->name_input_modes;
	_tmp12_ = name;
	_tmp13_ = mode;
	gee_map_set (_tmp11_, _tmp12_, (gpointer) ((gintptr) _tmp13_));
	result = prop;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean kkc_engine_process_lookup_table_key_event (KkcEngine* self, guint keyval, guint keycode, guint state) {
	gboolean result = FALSE;
	guint page_size = 0U;
	IBusLookupTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_ = 0U;
	guint _tmp26_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lookup_table;
	_tmp1_ = ibus_lookup_table_get_page_size (_tmp0_);
	page_size = _tmp1_;
	_tmp3_ = state;
	if (_tmp3_ == ((guint) 0)) {
		guint _tmp4_ = 0U;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		_tmp4_ = keyval;
		_tmp5_ = g_unichar_to_string ((gunichar) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp7__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp2_ = _vala_string_array_contains (_tmp7_, _tmp7__length1, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* label = NULL;
		guint _tmp8_ = 0U;
		gunichar _tmp9_ = 0U;
		gchar* _tmp10_ = NULL;
		_tmp8_ = keyval;
		_tmp9_ = g_unichar_tolower ((gunichar) _tmp8_);
		_tmp10_ = g_unichar_to_string (_tmp9_);
		label = _tmp10_;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_ = 0;
					guint _tmp14_ = 0U;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gint _tmp16_ = 0;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					if (!_tmp11_) {
						gint _tmp12_ = 0;
						_tmp12_ = index;
						index = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = index;
					_tmp14_ = page_size;
					_tmp15_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp15__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp16_ = MIN ((gint) _tmp14_, _tmp15__length1);
					if (!(_tmp13_ < _tmp16_)) {
						break;
					}
					_tmp17_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp17__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp18_ = index;
					_tmp19_ = _tmp17_[_tmp18_];
					_tmp20_ = label;
					if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
						KkcContext* _tmp21_ = NULL;
						KkcCandidateList* _tmp22_ = NULL;
						KkcCandidateList* _tmp23_ = NULL;
						gint _tmp24_ = 0;
						gboolean _tmp25_ = FALSE;
						_tmp21_ = self->priv->context;
						_tmp22_ = kkc_context_get_candidates (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = index;
						_tmp25_ = kkc_candidate_list_select_at (_tmp23_, (guint) _tmp24_);
						result = _tmp25_;
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	_tmp26_ = state;
	if (_tmp26_ == ((guint) 0)) {
		gboolean retval = FALSE;
		guint _tmp27_ = 0U;
		gboolean _tmp44_ = FALSE;
		retval = FALSE;
		_tmp27_ = keyval;
		switch (_tmp27_) {
			case IBUS_Page_Up:
			case IBUS_KP_Page_Up:
			{
				KkcContext* _tmp28_ = NULL;
				KkcCandidateList* _tmp29_ = NULL;
				KkcCandidateList* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				_tmp28_ = self->priv->context;
				_tmp29_ = kkc_context_get_candidates (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = kkc_candidate_list_page_up (_tmp30_);
				retval = _tmp31_;
				break;
			}
			case IBUS_Page_Down:
			case IBUS_KP_Page_Down:
			{
				KkcContext* _tmp32_ = NULL;
				KkcCandidateList* _tmp33_ = NULL;
				KkcCandidateList* _tmp34_ = NULL;
				gboolean _tmp35_ = FALSE;
				_tmp32_ = self->priv->context;
				_tmp33_ = kkc_context_get_candidates (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = kkc_candidate_list_page_down (_tmp34_);
				retval = _tmp35_;
				break;
			}
			case IBUS_Up:
			{
				KkcContext* _tmp36_ = NULL;
				KkcCandidateList* _tmp37_ = NULL;
				KkcCandidateList* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				_tmp36_ = self->priv->context;
				_tmp37_ = kkc_context_get_candidates (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = kkc_candidate_list_cursor_up (_tmp38_);
				retval = _tmp39_;
				break;
			}
			case IBUS_Down:
			{
				KkcContext* _tmp40_ = NULL;
				KkcCandidateList* _tmp41_ = NULL;
				KkcCandidateList* _tmp42_ = NULL;
				gboolean _tmp43_ = FALSE;
				_tmp40_ = self->priv->context;
				_tmp41_ = kkc_context_get_candidates (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = kkc_candidate_list_cursor_down (_tmp42_);
				retval = _tmp43_;
				break;
			}
			default:
			{
				result = FALSE;
				return result;
			}
		}
		_tmp44_ = retval;
		if (_tmp44_) {
			kkc_engine_set_lookup_table_cursor_pos (self);
			kkc_engine_update_preedit (self);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean kkc_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state) {
	KkcEngine * self;
	gboolean result = FALSE;
	guint _keyval = 0U;
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	guint _state = 0U;
	guint _tmp6_ = 0U;
	gboolean _tmp7_ = FALSE;
	KkcContext* _tmp8_ = NULL;
	KkcCandidateList* _tmp9_ = NULL;
	KkcCandidateList* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	KkcKeyEvent* key = NULL;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	KkcKeyEvent* _tmp20_ = NULL;
	gboolean retval = FALSE;
	KkcContext* _tmp21_ = NULL;
	KkcKeyEvent* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	self = (KkcEngine*) base;
	_tmp0_ = keyval;
	_keyval = _tmp0_;
	_tmp1_ = self->priv->use_custom_keymap;
	if (_tmp1_) {
		IBusKeymap* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp2_ = self->priv->keymap;
		_tmp3_ = keycode;
		_tmp4_ = state;
		_tmp5_ = ibus_keymap_lookup_keysym (_tmp2_, (guint16) _tmp3_, (guint32) _tmp4_);
		_keyval = _tmp5_;
	}
	_tmp6_ = state;
	_state = _tmp6_ & ((((IBUS_SHIFT_MASK | IBUS_CONTROL_MASK) | IBUS_MOD1_MASK) | IBUS_MOD5_MASK) | IBUS_RELEASE_MASK);
	_tmp8_ = self->priv->context;
	_tmp9_ = kkc_context_get_candidates (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_candidate_list_get_page_visible (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		guint _tmp15_ = 0U;
		gboolean _tmp16_ = FALSE;
		_tmp13_ = _keyval;
		_tmp14_ = keycode;
		_tmp15_ = _state;
		_tmp16_ = kkc_engine_process_lookup_table_key_event (self, _tmp13_, _tmp14_, _tmp15_);
		_tmp7_ = _tmp16_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = TRUE;
		return result;
	}
	_tmp17_ = _keyval;
	_tmp18_ = keycode;
	_tmp19_ = _state;
	_tmp20_ = kkc_key_event_new_from_x_event (_tmp17_, _tmp18_, (KkcModifierType) _tmp19_);
	key = _tmp20_;
	_tmp21_ = self->priv->context;
	_tmp22_ = key;
	_tmp23_ = kkc_context_process_key_event (_tmp21_, _tmp22_);
	retval = _tmp23_;
	_tmp29_ = retval;
	if (!_tmp29_) {
		gboolean _tmp30_ = FALSE;
		_tmp30_ = self->priv->use_custom_keymap;
		_tmp28_ = _tmp30_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		guint _tmp31_ = 0U;
		guint _tmp32_ = 0U;
		_tmp31_ = _keyval;
		_tmp32_ = keyval;
		_tmp27_ = _tmp31_ != _tmp32_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		guint _tmp33_ = 0U;
		_tmp33_ = _keyval;
		_tmp26_ = ((guint) 0x20) <= _tmp33_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		guint _tmp34_ = 0U;
		_tmp34_ = _keyval;
		_tmp25_ = _tmp34_ <= ((guint) 0x7F);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		guint _tmp35_ = 0U;
		_tmp35_ = state;
		_tmp24_ = (_tmp35_ & IBUS_RELEASE_MASK) == ((guint) 0);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		GString* builder = NULL;
		GString* _tmp36_ = NULL;
		GString* _tmp37_ = NULL;
		guint _tmp38_ = 0U;
		IBusText* text = NULL;
		GString* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		IBusText* _tmp41_ = NULL;
		IBusText* _tmp42_ = NULL;
		_tmp36_ = g_string_new ("");
		builder = _tmp36_;
		_tmp37_ = builder;
		_tmp38_ = _keyval;
		g_string_append_c (_tmp37_, (gchar) _tmp38_);
		_tmp39_ = builder;
		_tmp40_ = _tmp39_->str;
		_tmp41_ = ibus_text_new_from_string (_tmp40_);
		g_object_ref_sink (_tmp41_);
		text = _tmp41_;
		_tmp42_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp42_);
		result = TRUE;
		_g_object_unref0 (text);
		_g_string_free0 (builder);
		_g_object_unref0 (key);
		return result;
	}
	result = retval;
	_g_object_unref0 (key);
	return result;
}


static gboolean __lambda4_ (KkcEngine* self) {
	gboolean result = FALSE;
	KkcContext* _tmp0_ = NULL;
	KkcDictionaryList* _tmp1_ = NULL;
	KkcDictionaryList* _tmp2_ = NULL;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_dictionaries (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_dictionary_list_save (_tmp2_);
	result = TRUE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((KkcEngine*) self);
	return result;
}


static void kkc_engine_real_enable (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	kkc_context_reset (_tmp0_);
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) 300, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->save_dictionaries_timeout_id = _tmp1_;
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->enable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_disable (IBusEngine* base) {
	KkcEngine * self;
	guint _tmp0_ = 0U;
	KkcContext* _tmp2_ = NULL;
	KkcDictionaryList* _tmp3_ = NULL;
	KkcDictionaryList* _tmp4_ = NULL;
	self = (KkcEngine*) base;
	g_signal_emit_by_name ((IBusEngine*) self, "focus-out");
	_tmp0_ = self->priv->save_dictionaries_timeout_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->save_dictionaries_timeout_id;
		g_source_remove (_tmp1_);
		self->priv->save_dictionaries_timeout_id = (guint) 0;
	}
	_tmp2_ = self->priv->context;
	_tmp3_ = kkc_context_get_dictionaries (_tmp2_);
	_tmp4_ = _tmp3_;
	kkc_dictionary_list_save (_tmp4_);
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->disable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_reset (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	IBusText* empty_text = NULL;
	IBusText* _tmp1_ = NULL;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	kkc_context_reset (_tmp0_);
	_tmp1_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp1_);
	empty_text = _tmp1_;
	ibus_engine_update_preedit_text ((IBusEngine*) self, empty_text, (guint) 0, FALSE);
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->reset (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
	_g_object_unref0 (empty_text);
}


static void kkc_engine_real_focus_in (IBusEngine* base) {
	KkcEngine * self;
	IBusPropList* _tmp0_ = NULL;
	self = (KkcEngine*) base;
	kkc_engine_update_input_mode (self);
	_tmp0_ = self->priv->prop_list;
	ibus_engine_register_properties ((IBusEngine*) self, _tmp0_);
	self->priv->properties_registered = TRUE;
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->focus_in (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_focus_out (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	kkc_context_reset (_tmp0_);
	ibus_engine_hide_preedit_text ((IBusEngine*) self);
	ibus_engine_hide_lookup_table ((IBusEngine*) self);
	self->priv->properties_registered = FALSE;
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->focus_out (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state) {
	KkcEngine * self;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcEngine*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "setup") == 0) {
		gchar* filename = NULL;
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_build_filename (LIBEXECDIR, "ibus-setup-kkc", NULL);
		filename = _tmp1_;
		{
			const gchar* _tmp2_ = NULL;
			_tmp2_ = filename;
			g_spawn_command_line_async (_tmp2_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch3_g_spawn_error;
				}
				_g_free0 (filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally3;
		__catch3_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = filename;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("engine.vala:573: can't spawn %s: %s", _tmp3_, _tmp5_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (filename);
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = prop_name;
		_tmp8_ = g_str_has_prefix (_tmp7_, "InputMode.");
		if (_tmp8_) {
			guint _tmp9_ = 0U;
			_tmp9_ = prop_state;
			_tmp6_ = _tmp9_ == ((guint) PROP_STATE_CHECKED);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			KkcContext* _tmp10_ = NULL;
			GeeMap* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			_tmp10_ = self->priv->context;
			_tmp11_ = self->priv->name_input_modes;
			_tmp12_ = prop_name;
			_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
			kkc_context_set_input_mode (_tmp10_, (KkcInputMode) ((gintptr) _tmp13_));
		}
	}
}


static void kkc_engine_real_candidate_clicked (IBusEngine* base, guint index, guint button, guint state) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	KkcCandidateList* _tmp1_ = NULL;
	KkcCandidateList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	kkc_candidate_list_select_at (_tmp2_, _tmp3_);
}


static void kkc_engine_real_cursor_up (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	KkcCandidateList* _tmp1_ = NULL;
	KkcCandidateList* _tmp2_ = NULL;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_cursor_up (_tmp2_);
}


static void kkc_engine_real_cursor_down (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	KkcCandidateList* _tmp1_ = NULL;
	KkcCandidateList* _tmp2_ = NULL;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_cursor_down (_tmp2_);
}


static void kkc_engine_real_page_up (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	KkcCandidateList* _tmp1_ = NULL;
	KkcCandidateList* _tmp2_ = NULL;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_page_up (_tmp2_);
}


static void kkc_engine_real_page_down (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_ = NULL;
	KkcCandidateList* _tmp1_ = NULL;
	KkcCandidateList* _tmp2_ = NULL;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_page_down (_tmp2_);
}


static void __lambda5_ (void) {
	ibus_quit ();
}


static void ___lambda5__ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	__lambda5_ ();
}


static void __lambda6_ (const gchar* name, GVariant* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		kkc_engine_reload_dictionaries ();
	}
}


static void ___lambda6__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	__lambda6_ (name, value);
}


gint kkc_engine_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	IBusBus* bus = NULL;
	IBusBus* _tmp6_ = NULL;
	IBusBus* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	IBusBus* _tmp10_ = NULL;
	IBusConfig* config = NULL;
	IBusBus* _tmp11_ = NULL;
	IBusConfig* _tmp12_ = NULL;
	IBusConfig* _tmp13_ = NULL;
	IBusConfig* _tmp14_ = NULL;
	IBusConfig* _tmp22_ = NULL;
	Preferences* _tmp23_ = NULL;
	GeeArrayList* _tmp24_ = NULL;
	Preferences* _tmp25_ = NULL;
	IBusFactory* factory = NULL;
	IBusBus* _tmp26_ = NULL;
	GDBusConnection* _tmp27_ = NULL;
	IBusFactory* _tmp28_ = NULL;
	IBusFactory* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GError * _inner_error_ = NULL;
	ibus_init ();
	kkc_init ();
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("- ibus kkc");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, KKC_ENGINE_options, "ibus-kkc");
	{
		GOptionContext* _tmp2_ = NULL;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = ibus_bus_new ();
	g_object_ref_sink (_tmp6_);
	bus = _tmp6_;
	_tmp7_ = bus;
	_tmp8_ = ibus_bus_is_connected (_tmp7_);
	if (!_tmp8_) {
		FILE* _tmp9_ = NULL;
		_tmp9_ = stderr;
		fprintf (_tmp9_, "cannot connect to ibus-daemon!\n");
		result = 1;
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	_tmp10_ = bus;
	g_signal_connect (_tmp10_, "disconnected", (GCallback) ___lambda5__ibus_bus_disconnected, NULL);
	_tmp11_ = bus;
	_tmp12_ = ibus_bus_get_config (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	config = _tmp13_;
	_tmp14_ = config;
	if (_tmp14_ == NULL) {
		FILE* _tmp15_ = NULL;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "ibus-config component is not running!\n");
		result = 1;
		_g_object_unref0 (config);
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	{
		KkcLanguageModel* _tmp16_ = NULL;
		KkcLanguageModel* _tmp17_ = NULL;
		KkcLanguageModel* _tmp18_ = NULL;
		_tmp17_ = kkc_language_model_load ("sorted3", &_inner_error_);
		_tmp16_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp18_ = _tmp16_;
		_tmp16_ = NULL;
		_g_object_unref0 (kkc_engine_language_model);
		kkc_engine_language_model = _tmp18_;
		_g_object_unref0 (_tmp16_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = stderr;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		fprintf (_tmp19_, "can't load language model: %s\n", _tmp21_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (config);
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp22_ = config;
	_tmp23_ = preferences_new (_tmp22_);
	_g_object_unref0 (kkc_engine_preferences);
	kkc_engine_preferences = _tmp23_;
	_tmp24_ = gee_array_list_new (KKC_TYPE_DICTIONARY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (kkc_engine_dictionaries);
	kkc_engine_dictionaries = _tmp24_;
	kkc_engine_reload_dictionaries ();
	_tmp25_ = kkc_engine_preferences;
	g_signal_connect (_tmp25_, "value-changed", (GCallback) ___lambda6__preferences_value_changed, NULL);
	_tmp26_ = bus;
	_tmp27_ = ibus_bus_get_connection (_tmp26_);
	_tmp28_ = ibus_factory_new (_tmp27_);
	g_object_ref_sink (_tmp28_);
	factory = _tmp28_;
	_tmp29_ = factory;
	ibus_factory_add_engine (_tmp29_, "kkc", TYPE_KKC_ENGINE);
	_tmp30_ = kkc_engine_ibus;
	if (_tmp30_) {
		IBusBus* _tmp31_ = NULL;
		_tmp31_ = bus;
		ibus_bus_request_name (_tmp31_, "org.freedesktop.IBus.KKC", (guint32) 0);
	} else {
		IBusComponent* component = NULL;
		IBusComponent* _tmp32_ = NULL;
		IBusEngineDesc* engine = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		IBusEngineDesc* _tmp35_ = NULL;
		IBusEngineDesc* _tmp36_ = NULL;
		IBusComponent* _tmp37_ = NULL;
		IBusEngineDesc* _tmp38_ = NULL;
		IBusBus* _tmp39_ = NULL;
		IBusComponent* _tmp40_ = NULL;
		_tmp32_ = ibus_component_new ("org.freedesktop.IBus.KKC", "Kana Kanji", PACKAGE_VERSION, "GPL", "Daiki Ueno <ueno@gnu.org>", "http://code.google.com/p/ibus/", "", "ibus-kkc");
		g_object_ref_sink (_tmp32_);
		component = _tmp32_;
		_tmp33_ = g_strdup_printf ("%s/icons/ibus-kkc.svg", PACKAGE_DATADIR);
		_tmp34_ = _tmp33_;
		_tmp35_ = ibus_engine_desc_new ("kkc", "Kana Kanji", "Kana Kanji Input Method", "ja", "GPL", "Daiki Ueno <ueno@gnu.org>", _tmp34_, "us");
		g_object_ref_sink (_tmp35_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp34_);
		engine = _tmp36_;
		_tmp37_ = component;
		_tmp38_ = engine;
		ibus_component_add_engine (_tmp37_, _tmp38_);
		_tmp39_ = bus;
		_tmp40_ = component;
		ibus_bus_register_component (_tmp39_, _tmp40_);
		_g_object_unref0 (engine);
		_g_object_unref0 (component);
	}
	ibus_main ();
	result = 0;
	_g_object_unref0 (factory);
	_g_object_unref0 (config);
	_g_object_unref0 (bus);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return kkc_engine_main (argv, argc);
}


KkcEngine* kkc_engine_construct (GType object_type) {
	KkcEngine * self = NULL;
	self = (KkcEngine*) g_object_new (object_type, NULL);
	return self;
}


KkcEngine* kkc_engine_new (void) {
	return kkc_engine_construct (TYPE_KKC_ENGINE);
}


static void _kkc_engine___lambda7_ (KkcEngine* self, const gchar* name, GVariant* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	kkc_engine_apply_preferences (self);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		KkcContext* _tmp1_ = NULL;
		KkcDictionaryList* _tmp2_ = NULL;
		KkcDictionaryList* _tmp3_ = NULL;
		_tmp1_ = self->priv->context;
		_tmp2_ = kkc_context_get_dictionaries (_tmp1_);
		_tmp3_ = _tmp2_;
		kkc_dictionary_list_clear (_tmp3_);
		{
			GeeArrayList* _dictionary_list = NULL;
			GeeArrayList* _tmp4_ = NULL;
			GeeArrayList* _tmp5_ = NULL;
			gint _dictionary_size = 0;
			GeeArrayList* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _dictionary_index = 0;
			_tmp4_ = kkc_engine_dictionaries;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_dictionary_list = _tmp5_;
			_tmp6_ = _dictionary_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_dictionary_size = _tmp8_;
			_dictionary_index = -1;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				KkcDictionary* dictionary = NULL;
				GeeArrayList* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gpointer _tmp14_ = NULL;
				KkcContext* _tmp15_ = NULL;
				KkcDictionaryList* _tmp16_ = NULL;
				KkcDictionaryList* _tmp17_ = NULL;
				KkcDictionary* _tmp18_ = NULL;
				_tmp9_ = _dictionary_index;
				_dictionary_index = _tmp9_ + 1;
				_tmp10_ = _dictionary_index;
				_tmp11_ = _dictionary_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _dictionary_list;
				_tmp13_ = _dictionary_index;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
				dictionary = (KkcDictionary*) _tmp14_;
				_tmp15_ = self->priv->context;
				_tmp16_ = kkc_context_get_dictionaries (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = dictionary;
				kkc_dictionary_list_add (_tmp17_, _tmp18_);
				_g_object_unref0 (dictionary);
			}
			_g_object_unref0 (_dictionary_list);
		}
	}
}


static void __kkc_engine___lambda7__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	_kkc_engine___lambda7_ ((KkcEngine*) self, name, value);
}


static void _kkc_engine___lambda8_ (KkcEngine* self) {
	kkc_engine_update_preedit (self);
}


static void __kkc_engine___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_kkc_engine___lambda8_ ((KkcEngine*) self);
}


static void _kkc_engine___lambda9_ (KkcEngine* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	kkc_engine_update_input_mode (self);
}


static void __kkc_engine___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_kkc_engine___lambda9_ ((KkcEngine*) self, _sender, pspec);
}


static void _kkc_engine___lambda10_ (KkcEngine* self) {
	kkc_engine_populate_lookup_table (self);
}


static void __kkc_engine___lambda10__kkc_candidate_list_populated (KkcCandidateList* _sender, gpointer self) {
	_kkc_engine___lambda10_ ((KkcEngine*) self);
}


static void _kkc_engine___lambda11_ (KkcEngine* self) {
	kkc_engine_set_lookup_table_cursor_pos (self);
}


static void __kkc_engine___lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_kkc_engine___lambda11_ ((KkcEngine*) self);
}


static void _kkc_engine___lambda12_ (KkcEngine* self) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = self->priv->lookup_table_visible;
	if (_tmp0_) {
		ibus_engine_hide_lookup_table ((IBusEngine*) self);
		ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
		self->priv->lookup_table_visible = FALSE;
	}
}


static void __kkc_engine___lambda12__kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self) {
	_kkc_engine___lambda12_ ((KkcEngine*) self);
}


static void _kkc_engine___lambda13_ (KkcEngine* self, KkcContext* e) {
	GtkClipboard* _tmp0_ = NULL;
	g_return_if_fail (e != NULL);
	_tmp0_ = self->priv->clipboard;
	gtk_clipboard_request_text (_tmp0_, (GtkClipboardTextReceivedFunc) kkc_engine_set_selection_text, self);
}


static void __kkc_engine___lambda13__kkc_context_request_selection_text (KkcContext* _sender, gpointer self) {
	_kkc_engine___lambda13_ ((KkcEngine*) self, _sender);
}


static GObject * kkc_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	KkcEngine * self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	IBusLookupTable* _tmp1_ = NULL;
	IBusPropList* _tmp13_ = NULL;
	IBusPropList* props = NULL;
	IBusPropList* _tmp14_ = NULL;
	IBusProperty* prop = NULL;
	const gchar* _tmp15_ = NULL;
	IBusProperty* _tmp16_ = NULL;
	IBusPropList* _tmp17_ = NULL;
	IBusProperty* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	IBusProperty* _tmp20_ = NULL;
	IBusPropList* _tmp21_ = NULL;
	IBusProperty* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	IBusProperty* _tmp24_ = NULL;
	IBusPropList* _tmp25_ = NULL;
	IBusProperty* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	IBusProperty* _tmp28_ = NULL;
	IBusPropList* _tmp29_ = NULL;
	IBusProperty* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	IBusProperty* _tmp32_ = NULL;
	IBusPropList* _tmp33_ = NULL;
	IBusProperty* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	IBusProperty* _tmp36_ = NULL;
	IBusPropList* _tmp37_ = NULL;
	IBusProperty* _tmp38_ = NULL;
	IBusText* _tmp39_ = NULL;
	IBusText* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	IBusText* _tmp42_ = NULL;
	IBusText* _tmp43_ = NULL;
	IBusPropList* _tmp44_ = NULL;
	IBusProperty* _tmp45_ = NULL;
	IBusPropList* _tmp46_ = NULL;
	IBusProperty* _tmp47_ = NULL;
	IBusProperty* _tmp48_ = NULL;
	IBusProperty* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	IBusText* _tmp51_ = NULL;
	IBusText* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	IBusText* _tmp54_ = NULL;
	IBusText* _tmp55_ = NULL;
	IBusProperty* _tmp56_ = NULL;
	IBusPropList* _tmp57_ = NULL;
	IBusProperty* _tmp58_ = NULL;
	KkcLanguageModel* _tmp59_ = NULL;
	KkcContext* _tmp60_ = NULL;
	Preferences* _tmp76_ = NULL;
	KkcContext* _tmp77_ = NULL;
	KkcContext* _tmp78_ = NULL;
	KkcContext* _tmp79_ = NULL;
	KkcCandidateList* _tmp80_ = NULL;
	KkcCandidateList* _tmp81_ = NULL;
	KkcContext* _tmp82_ = NULL;
	KkcCandidateList* _tmp83_ = NULL;
	KkcCandidateList* _tmp84_ = NULL;
	KkcContext* _tmp85_ = NULL;
	KkcCandidateList* _tmp86_ = NULL;
	KkcCandidateList* _tmp87_ = NULL;
	GtkClipboard* _tmp88_ = NULL;
	GtkClipboard* _tmp89_ = NULL;
	KkcContext* _tmp90_ = NULL;
	parent_class = G_OBJECT_CLASS (kkc_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KKC_ENGINE, KkcEngine);
	_tmp0_ = self->priv->LOOKUP_TABLE_LABELS;
	_tmp0__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
	_tmp1_ = ibus_lookup_table_new ((guint) _tmp0__length1, (guint) 0, TRUE, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->lookup_table);
	self->priv->lookup_table = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				IBusText* text = NULL;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				IBusText* _tmp9_ = NULL;
				IBusLookupTable* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				IBusText* _tmp12_ = NULL;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp5__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp6__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				_tmp9_ = ibus_text_new_from_string (_tmp8_);
				g_object_ref_sink (_tmp9_);
				text = _tmp9_;
				_tmp10_ = self->priv->lookup_table;
				_tmp11_ = i;
				_tmp12_ = text;
				ibus_lookup_table_set_label (_tmp10_, (guint) _tmp11_, _tmp12_);
				_g_object_unref0 (text);
			}
		}
	}
	_tmp13_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->prop_list);
	self->priv->prop_list = _tmp13_;
	_tmp14_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp14_);
	props = _tmp14_;
	_tmp15_ = _ ("Hiragana");
	_tmp16_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_HIRAGANA, "InputMode.Hiragana", _tmp15_, "あ");
	_g_object_unref0 (prop);
	prop = _tmp16_;
	_tmp17_ = props;
	_tmp18_ = prop;
	ibus_prop_list_append (_tmp17_, _tmp18_);
	_tmp19_ = _ ("Katakana");
	_tmp20_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_KATAKANA, "InputMode.Katakana", _tmp19_, "ア");
	_g_object_unref0 (prop);
	prop = _tmp20_;
	_tmp21_ = props;
	_tmp22_ = prop;
	ibus_prop_list_append (_tmp21_, _tmp22_);
	_tmp23_ = _ ("Halfwidth Katakana");
	_tmp24_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_HANKAKU_KATAKANA, "InputMode.HankakuKatakana", _tmp23_, "_ｱ");
	_g_object_unref0 (prop);
	prop = _tmp24_;
	_tmp25_ = props;
	_tmp26_ = prop;
	ibus_prop_list_append (_tmp25_, _tmp26_);
	_tmp27_ = _ ("Latin");
	_tmp28_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_LATIN, "InputMode.Latin", _tmp27_, "_A");
	_g_object_unref0 (prop);
	prop = _tmp28_;
	_tmp29_ = props;
	_tmp30_ = prop;
	ibus_prop_list_append (_tmp29_, _tmp30_);
	_tmp31_ = _ ("Wide Latin");
	_tmp32_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_WIDE_LATIN, "InputMode.WideLatin", _tmp31_, "Ａ");
	_g_object_unref0 (prop);
	prop = _tmp32_;
	_tmp33_ = props;
	_tmp34_ = prop;
	ibus_prop_list_append (_tmp33_, _tmp34_);
	_tmp35_ = _ ("Direct Input");
	_tmp36_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_DIRECT, "InputMode.Direct", _tmp35_, "_A");
	_g_object_unref0 (prop);
	prop = _tmp36_;
	_tmp37_ = props;
	_tmp38_ = prop;
	ibus_prop_list_append (_tmp37_, _tmp38_);
	_tmp39_ = ibus_text_new_from_string ("あ");
	g_object_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	_tmp41_ = _ ("Switch input mode");
	_tmp42_ = ibus_text_new_from_string (_tmp41_);
	g_object_ref_sink (_tmp42_);
	_tmp43_ = _tmp42_;
	_tmp44_ = props;
	_tmp45_ = ibus_property_new ("InputMode", PROP_TYPE_MENU, _tmp40_, NULL, _tmp43_, TRUE, TRUE, PROP_STATE_UNCHECKED, _tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (prop);
	prop = _tmp45_;
	_g_object_unref0 (_tmp43_);
	_g_object_unref0 (_tmp40_);
	_tmp46_ = self->priv->prop_list;
	_tmp47_ = prop;
	ibus_prop_list_append (_tmp46_, _tmp47_);
	_tmp48_ = prop;
	_tmp49_ = _g_object_ref0 (_tmp48_);
	_g_object_unref0 (self->priv->input_mode_prop);
	self->priv->input_mode_prop = _tmp49_;
	_tmp50_ = _ ("Preferences");
	_tmp51_ = ibus_text_new_from_string (_tmp50_);
	g_object_ref_sink (_tmp51_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _ ("Configure Kana Kanji Conversion");
	_tmp54_ = ibus_text_new_from_string (_tmp53_);
	g_object_ref_sink (_tmp54_);
	_tmp55_ = _tmp54_;
	_tmp56_ = ibus_property_new ("setup", PROP_TYPE_NORMAL, _tmp52_, "gtk-preferences", _tmp55_, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (prop);
	prop = _tmp56_;
	_g_object_unref0 (_tmp55_);
	_g_object_unref0 (_tmp52_);
	_tmp57_ = self->priv->prop_list;
	_tmp58_ = prop;
	ibus_prop_list_append (_tmp57_, _tmp58_);
	_tmp59_ = kkc_engine_language_model;
	_tmp60_ = kkc_context_new (_tmp59_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp60_;
	{
		GeeArrayList* _dictionary_list = NULL;
		GeeArrayList* _tmp61_ = NULL;
		GeeArrayList* _tmp62_ = NULL;
		gint _dictionary_size = 0;
		GeeArrayList* _tmp63_ = NULL;
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint _dictionary_index = 0;
		_tmp61_ = kkc_engine_dictionaries;
		_tmp62_ = _g_object_ref0 (_tmp61_);
		_dictionary_list = _tmp62_;
		_tmp63_ = _dictionary_list;
		_tmp64_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_dictionary_size = _tmp65_;
		_dictionary_index = -1;
		while (TRUE) {
			gint _tmp66_ = 0;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			KkcDictionary* dictionary = NULL;
			GeeArrayList* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gpointer _tmp71_ = NULL;
			KkcContext* _tmp72_ = NULL;
			KkcDictionaryList* _tmp73_ = NULL;
			KkcDictionaryList* _tmp74_ = NULL;
			KkcDictionary* _tmp75_ = NULL;
			_tmp66_ = _dictionary_index;
			_dictionary_index = _tmp66_ + 1;
			_tmp67_ = _dictionary_index;
			_tmp68_ = _dictionary_size;
			if (!(_tmp67_ < _tmp68_)) {
				break;
			}
			_tmp69_ = _dictionary_list;
			_tmp70_ = _dictionary_index;
			_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, _tmp70_);
			dictionary = (KkcDictionary*) _tmp71_;
			_tmp72_ = self->priv->context;
			_tmp73_ = kkc_context_get_dictionaries (_tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = dictionary;
			kkc_dictionary_list_add (_tmp74_, _tmp75_);
			_g_object_unref0 (dictionary);
		}
		_g_object_unref0 (_dictionary_list);
	}
	kkc_engine_apply_preferences (self);
	_tmp76_ = kkc_engine_preferences;
	g_signal_connect_object (_tmp76_, "value-changed", (GCallback) __kkc_engine___lambda7__preferences_value_changed, self, 0);
	_tmp77_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp77_, "notify::input", (GCallback) __kkc_engine___lambda8__g_object_notify, self, 0);
	_tmp78_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp78_, "notify::input-mode", (GCallback) __kkc_engine___lambda9__g_object_notify, self, 0);
	_tmp79_ = self->priv->context;
	_tmp80_ = kkc_context_get_candidates (_tmp79_);
	_tmp81_ = _tmp80_;
	g_signal_connect_object (_tmp81_, "populated", (GCallback) __kkc_engine___lambda10__kkc_candidate_list_populated, self, 0);
	_tmp82_ = self->priv->context;
	_tmp83_ = kkc_context_get_candidates (_tmp82_);
	_tmp84_ = _tmp83_;
	g_signal_connect_object ((GObject*) _tmp84_, "notify::cursor-pos", (GCallback) __kkc_engine___lambda11__g_object_notify, self, 0);
	_tmp85_ = self->priv->context;
	_tmp86_ = kkc_context_get_candidates (_tmp85_);
	_tmp87_ = _tmp86_;
	g_signal_connect_object (_tmp87_, "selected", (GCallback) __kkc_engine___lambda12__kkc_candidate_list_selected, self, 0);
	_tmp88_ = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	_tmp89_ = _g_object_ref0 (_tmp88_);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp89_;
	_tmp90_ = self->priv->context;
	g_signal_connect_object (_tmp90_, "request-selection-text", (GCallback) __kkc_engine___lambda13__kkc_context_request_selection_text, self, 0);
	kkc_engine_update_candidates (self);
	kkc_engine_update_input_mode (self);
	_g_object_unref0 (prop);
	_g_object_unref0 (props);
	return obj;
}


static void kkc_engine_class_init (KkcEngineClass * klass) {
	kkc_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcEnginePrivate));
	((IBusEngineClass *) klass)->process_key_event = kkc_engine_real_process_key_event;
	((IBusEngineClass *) klass)->enable = kkc_engine_real_enable;
	((IBusEngineClass *) klass)->disable = kkc_engine_real_disable;
	((IBusEngineClass *) klass)->reset = kkc_engine_real_reset;
	((IBusEngineClass *) klass)->focus_in = kkc_engine_real_focus_in;
	((IBusEngineClass *) klass)->focus_out = kkc_engine_real_focus_out;
	((IBusEngineClass *) klass)->property_activate = kkc_engine_real_property_activate;
	((IBusEngineClass *) klass)->candidate_clicked = kkc_engine_real_candidate_clicked;
	((IBusEngineClass *) klass)->cursor_up = kkc_engine_real_cursor_up;
	((IBusEngineClass *) klass)->cursor_down = kkc_engine_real_cursor_down;
	((IBusEngineClass *) klass)->page_up = kkc_engine_real_page_up;
	((IBusEngineClass *) klass)->page_down = kkc_engine_real_page_down;
	G_OBJECT_CLASS (klass)->constructor = kkc_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = kkc_engine_finalize;
}


static void kkc_engine_instance_init (KkcEngine * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	self->priv = KKC_ENGINE_GET_PRIVATE (self);
	self->priv->properties_registered = FALSE;
	_tmp0_ = gee_hash_map_new (KKC_TYPE_INPUT_MODE, NULL, NULL, IBUS_TYPE_PROPERTY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->input_mode_props = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (KKC_TYPE_INPUT_MODE, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->input_mode_symbols = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, KKC_TYPE_INPUT_MODE, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->name_input_modes = (GeeMap*) _tmp2_;
	_tmp3_ = g_strdup ("1");
	_tmp4_ = g_strdup ("2");
	_tmp5_ = g_strdup ("3");
	_tmp6_ = g_strdup ("4");
	_tmp7_ = g_strdup ("5");
	_tmp8_ = g_strdup ("6");
	_tmp9_ = g_strdup ("7");
	_tmp10_ = g_strdup ("8");
	_tmp11_ = g_strdup ("9");
	_tmp12_ = g_strdup ("0");
	_tmp13_ = g_strdup ("a");
	_tmp14_ = g_strdup ("b");
	_tmp15_ = g_strdup ("c");
	_tmp16_ = g_strdup ("d");
	_tmp17_ = g_strdup ("e");
	_tmp18_ = g_new0 (gchar*, 15 + 1);
	_tmp18_[0] = _tmp3_;
	_tmp18_[1] = _tmp4_;
	_tmp18_[2] = _tmp5_;
	_tmp18_[3] = _tmp6_;
	_tmp18_[4] = _tmp7_;
	_tmp18_[5] = _tmp8_;
	_tmp18_[6] = _tmp9_;
	_tmp18_[7] = _tmp10_;
	_tmp18_[8] = _tmp11_;
	_tmp18_[9] = _tmp12_;
	_tmp18_[10] = _tmp13_;
	_tmp18_[11] = _tmp14_;
	_tmp18_[12] = _tmp15_;
	_tmp18_[13] = _tmp16_;
	_tmp18_[14] = _tmp17_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp18_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 15;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
	self->priv->save_dictionaries_timeout_id = (guint) 0;
}


static void kkc_engine_finalize (GObject* obj) {
	KkcEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KKC_ENGINE, KkcEngine);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->lookup_table);
	_g_object_unref0 (self->priv->keymap);
	_g_object_unref0 (self->priv->input_mode_prop);
	_g_object_unref0 (self->priv->prop_list);
	_g_object_unref0 (self->priv->input_mode_props);
	_g_object_unref0 (self->priv->input_mode_symbols);
	_g_object_unref0 (self->priv->name_input_modes);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (kkc_engine_parent_class)->finalize (obj);
}


GType kkc_engine_get_type (void) {
	static volatile gsize kkc_engine_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcEngine), 0, (GInstanceInitFunc) kkc_engine_instance_init, NULL };
		GType kkc_engine_type_id;
		kkc_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "KkcEngine", &g_define_type_info, 0);
		g_once_init_leave (&kkc_engine_type_id__volatile, kkc_engine_type_id);
	}
	return kkc_engine_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



