/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1985-2010 AT&T Intellectual Property          *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                    by AT&T Intellectual Property                     *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/

/* : : generated by proto : : */

#if !defined(__PROTO__)
#  if defined(__STDC__) || defined(__cplusplus) || defined(_proto) || defined(c_plusplus)
#    if defined(__cplusplus)
#      define __LINKAGE__	"C"
#    else
#      define __LINKAGE__
#    endif
#    define __STDARG__
#    define __PROTO__(x)	x
#    define __OTORP__(x)
#    define __PARAM__(n,o)	n
#    if !defined(__STDC__) && !defined(__cplusplus)
#      if !defined(c_plusplus)
#      	define const
#      endif
#      define signed
#      define void		int
#      define volatile
#      define __V_		char
#    else
#      define __V_		void
#    endif
#  else
#    define __PROTO__(x)	()
#    define __OTORP__(x)	x
#    define __PARAM__(n,o)	o
#    define __LINKAGE__
#    define __V_		char
#    define const
#    define signed
#    define void		int
#    define volatile
#  endif
#  define __MANGLE__	__LINKAGE__
#  if defined(__cplusplus) || defined(c_plusplus)
#    define __VARARG__	...
#  else
#    define __VARARG__
#  endif
#  if defined(__STDARG__)
#    define __VA_START__(p,a)	va_start(p,a)
#  else
#    define __VA_START__(p,a)	va_start(p)
#  endif
#  if !defined(__INLINE__)
#    if defined(__cplusplus)
#      define __INLINE__	extern __MANGLE__ inline
#    else
#      if defined(_WIN32) && !defined(__GNUC__)
#      	define __INLINE__	__inline
#      endif
#    endif
#  endif
#endif
#if !defined(__LINKAGE__)
#define __LINKAGE__		/* 2004-08-11 transition */
#endif
#include <ast.h>
#include <error.h>

#if _UWIN

NoN(confstr)

#else

/* : : generated by conf from /home/gsf/src/lib/libast/comp/conf.tab : : */

#include "confmap.h"
#include "conflib.h"
#include "FEATURE/unistd"
#include "FEATURE/limits"

static char*
local_confstr __PARAM__((int op), (op)) __OTORP__(int op;){
	switch (op)
	{
#if	_CS_XBS5_ILP32_OFF32_CFLAGS+0
case _CS_XBS5_ILP32_OFF32_CFLAGS:
		break;
#endif
#if	_CS_XBS5_ILP32_OFF32_LDFLAGS+0
case _CS_XBS5_ILP32_OFF32_LDFLAGS:
		break;
#endif
#if	_CS_XBS5_ILP32_OFF32_LIBS+0
case _CS_XBS5_ILP32_OFF32_LIBS:
		break;
#endif
#if	_CS_XBS5_ILP32_OFF32_LINTFLAGS+0
case _CS_XBS5_ILP32_OFF32_LINTFLAGS:
		break;
#endif
#if	_CS_XBS5_ILP32_OFFBIG_CFLAGS+0
case _CS_XBS5_ILP32_OFFBIG_CFLAGS:
		break;
#endif
#if	_CS_XBS5_ILP32_OFFBIG_LDFLAGS+0
case _CS_XBS5_ILP32_OFFBIG_LDFLAGS:
		break;
#endif
#if	_CS_XBS5_ILP32_OFFBIG_LIBS+0
case _CS_XBS5_ILP32_OFFBIG_LIBS:
		break;
#endif
#if	_CS_XBS5_ILP32_OFFBIG_LINTFLAGS+0
case _CS_XBS5_ILP32_OFFBIG_LINTFLAGS:
		break;
#endif
#if	_CS_LFS64_CFLAGS+0
case _CS_LFS64_CFLAGS:
		break;
#endif
#if	_CS_LFS64_LDFLAGS+0
case _CS_LFS64_LDFLAGS:
		break;
#endif
#if	_CS_LFS64_LIBS+0
case _CS_LFS64_LIBS:
		break;
#endif
#if	_CS_LFS64_LINTFLAGS+0
case _CS_LFS64_LINTFLAGS:
		break;
#endif
#if	_CS_LFS_CFLAGS+0
case _CS_LFS_CFLAGS:
		break;
#endif
#if	_CS_LFS_LDFLAGS+0
case _CS_LFS_LDFLAGS:
		break;
#endif
#if	_CS_LFS_LIBS+0
case _CS_LFS_LIBS:
		break;
#endif
#if	_CS_LFS_LINTFLAGS+0
case _CS_LFS_LINTFLAGS:
		break;
#endif
#if	_CS_GNU_LIBC_VERSION+0
case _CS_GNU_LIBC_VERSION:
		break;
#endif
#if	_CS_GNU_LIBPTHREAD_VERSION+0
case _CS_GNU_LIBPTHREAD_VERSION:
		break;
#endif
#if	_CS_XBS5_LP64_OFF64_CFLAGS+0
case _CS_XBS5_LP64_OFF64_CFLAGS:
		break;
#endif
#if	_CS_XBS5_LP64_OFF64_LDFLAGS+0
case _CS_XBS5_LP64_OFF64_LDFLAGS:
		break;
#endif
#if	_CS_XBS5_LP64_OFF64_LIBS+0
case _CS_XBS5_LP64_OFF64_LIBS:
		break;
#endif
#if	_CS_XBS5_LP64_OFF64_LINTFLAGS+0
case _CS_XBS5_LP64_OFF64_LINTFLAGS:
		break;
#endif
#if	_CS_XBS5_LPBIG_OFFBIG_CFLAGS+0
case _CS_XBS5_LPBIG_OFFBIG_CFLAGS:
		break;
#endif
#if	_CS_XBS5_LPBIG_OFFBIG_LDFLAGS+0
case _CS_XBS5_LPBIG_OFFBIG_LDFLAGS:
		break;
#endif
#if	_CS_XBS5_LPBIG_OFFBIG_LIBS+0
case _CS_XBS5_LPBIG_OFFBIG_LIBS:
		break;
#endif
#if	_CS_XBS5_LPBIG_OFFBIG_LINTFLAGS+0
case _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS:
		break;
#endif
#if	_CS_PATH+0
case _CS_PATH:
		return("/bin:/usr/bin");
#endif
#if	_CS_SHELL+0
case _CS_SHELL:
		return("/bin/sh");
#endif
#if	_CS_TMP+0
case _CS_TMP:
		return("/tmp");
#endif
#if	_CS_POSIX_V6_ILP32_OFF32_CFLAGS+0
case _CS_POSIX_V6_ILP32_OFF32_CFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_ILP32_OFF32_LDFLAGS+0
case _CS_POSIX_V6_ILP32_OFF32_LDFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_ILP32_OFF32_LIBS+0
case _CS_POSIX_V6_ILP32_OFF32_LIBS:
		break;
#endif
#if	_CS_POSIX_V6_ILP32_OFF32_LINTFLAGS+0
case _CS_POSIX_V6_ILP32_OFF32_LINTFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_ILP32_OFFBIG_CFLAGS+0
case _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS+0
case _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_ILP32_OFFBIG_LIBS+0
case _CS_POSIX_V6_ILP32_OFFBIG_LIBS:
		break;
#endif
#if	_CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS+0
case _CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_LP64_OFF64_CFLAGS+0
case _CS_POSIX_V6_LP64_OFF64_CFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_LP64_OFF64_LDFLAGS+0
case _CS_POSIX_V6_LP64_OFF64_LDFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_LP64_OFF64_LIBS+0
case _CS_POSIX_V6_LP64_OFF64_LIBS:
		break;
#endif
#if	_CS_POSIX_V6_LP64_OFF64_LINTFLAGS+0
case _CS_POSIX_V6_LP64_OFF64_LINTFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS+0
case _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS+0
case _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS:
		break;
#endif
#if	_CS_POSIX_V6_LPBIG_OFFBIG_LIBS+0
case _CS_POSIX_V6_LPBIG_OFFBIG_LIBS:
		break;
#endif
#if	_CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS+0
case _CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS:
		break;
#endif
#if	_CS_V6_WIDTH_RESTRICTED_ENVS+0
case _CS_V6_WIDTH_RESTRICTED_ENVS:
		break;
#endif
	default:
		break;
	}
	return(0);
}

size_t
confstr __PARAM__((int op, char* buf, size_t siz), (op, buf, siz)) __OTORP__(int op; char* buf; size_t siz;){
	char*	s;
	int	n;
#if _lib_confstr
#undef	confstr
	if (((n = op) >= 0 || -op <= confmap[0] && (n = confmap[-op]) >= 0) && (n = confstr(n, buf, siz)) > 0)
		return(n);
#endif
	if (s = local_confstr(op))
	{
		if ((n = strlen(s) + 1) >= siz)
		{
			if (siz == 0)
				return(n + 1);
			buf[n = siz - 1] = 0;
		}
		memcpy(buf, s, n);
		return(n);
	}
	errno = EINVAL;
	return(0);
}

#endif
