/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDatabase.h"

#include <wtf/GetPtr.h>

#include "Database.h"
#include "KURL.h"

#include <runtime/Error.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDatabase)

/* Hash table */

static const HashTableValue JSDatabaseTableValues[2] =
{
    { "version", DontDelete|ReadOnly, (intptr_t)jsDatabaseVersion, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDatabaseTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDatabaseTableValues, 0 };
#else
    { 2, 1, JSDatabaseTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSDatabasePrototypeTableValues[3] =
{
    { "changeVersion", DontDelete|Function, (intptr_t)jsDatabasePrototypeFunctionChangeVersion, (intptr_t)5 },
    { "transaction", DontDelete|Function, (intptr_t)jsDatabasePrototypeFunctionTransaction, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDatabasePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSDatabasePrototypeTableValues, 0 };
#else
    { 4, 3, JSDatabasePrototypeTableValues, 0 };
#endif

const ClassInfo JSDatabasePrototype::s_info = { "DatabasePrototype", 0, &JSDatabasePrototypeTable, 0 };

JSObject* JSDatabasePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSDatabase>(exec);
}

bool JSDatabasePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDatabasePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDatabase::s_info = { "Database", 0, &JSDatabaseTable, 0 };

JSDatabase::JSDatabase(PassRefPtr<Structure> structure, PassRefPtr<Database> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSDatabase::~JSDatabase()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSDatabase::createPrototype(ExecState* exec)
{
    return new (exec) JSDatabasePrototype(JSDatabasePrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSDatabase::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDatabase, Base>(exec, &JSDatabaseTable, this, propertyName, slot);
}

JSValuePtr jsDatabaseVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Database* imp = static_cast<Database*>(static_cast<JSDatabase*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->version());
}

JSValuePtr jsDatabasePrototypeFunctionChangeVersion(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDatabase::s_info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(asObject(thisValue));
    return castedThisObj->changeVersion(exec, args);
}

JSValuePtr jsDatabasePrototypeFunctionTransaction(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDatabase::s_info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(asObject(thisValue));
    return castedThisObj->transaction(exec, args);
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, Database* object)
{
    return getDOMObjectWrapper<JSDatabase>(exec, object);
}
Database* toDatabase(JSC::JSValuePtr value)
{
    return value->isObject(&JSDatabase::s_info) ? static_cast<JSDatabase*>(asObject(value))->impl() : 0;
}

}
