/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;

class ButtonPanel
extends Panel
implements ActionListener {
    VncViewer viewer;
    Button disconnectButton;
    Button optionsButton;
    Button recordButton;
    Button clipboardButton;
    Button ctrlAltDelButton;
    Button refreshButton;

    ButtonPanel(VncViewer vncViewer) {
        this.viewer = vncViewer;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.disconnectButton = new Button("Disconnect");
        this.disconnectButton.setEnabled(false);
        this.add(this.disconnectButton);
        this.disconnectButton.addActionListener(this);
        this.optionsButton = new Button("Options");
        this.add(this.optionsButton);
        this.optionsButton.addActionListener(this);
        this.clipboardButton = new Button("Clipboard");
        this.clipboardButton.setEnabled(false);
        this.add(this.clipboardButton);
        this.clipboardButton.addActionListener(this);
        if (this.viewer.rec != null) {
            this.recordButton = new Button("Record");
            this.add(this.recordButton);
            this.recordButton.addActionListener(this);
        }
        this.ctrlAltDelButton = new Button("Send Ctrl-Alt-Del");
        this.ctrlAltDelButton.setEnabled(false);
        this.add(this.ctrlAltDelButton);
        this.ctrlAltDelButton.addActionListener(this);
        this.refreshButton = new Button("Refresh");
        this.refreshButton.setEnabled(false);
        this.add(this.refreshButton);
        this.refreshButton.addActionListener(this);
    }

    public void enableButtons() {
        this.disconnectButton.setEnabled(true);
        this.clipboardButton.setEnabled(true);
        this.refreshButton.setEnabled(true);
    }

    public void disableButtonsOnDisconnect() {
        this.remove(this.disconnectButton);
        this.disconnectButton = new Button("Hide desktop");
        this.disconnectButton.setEnabled(true);
        this.add((Component)this.disconnectButton, 0);
        this.disconnectButton.addActionListener(this);
        this.optionsButton.setEnabled(false);
        this.clipboardButton.setEnabled(false);
        this.ctrlAltDelButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.validate();
    }

    public void enableRemoteAccessControls(boolean bl) {
        this.ctrlAltDelButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                this.viewer.moveFocusToDesktop();
                                if (actionEvent.getSource() != this.disconnectButton) break block4;
                                this.viewer.disconnect();
                                break block5;
                            }
                            if (actionEvent.getSource() != this.optionsButton) break block6;
                            this.viewer.options.setVisible(!this.viewer.options.isVisible());
                            break block5;
                        }
                        if (actionEvent.getSource() != this.recordButton) break block7;
                        this.viewer.rec.setVisible(!this.viewer.rec.isVisible());
                        break block5;
                    }
                    if (actionEvent.getSource() != this.clipboardButton) break block8;
                    this.viewer.clipboard.setVisible(!this.viewer.clipboard.isVisible());
                    break block5;
                }
                if (actionEvent.getSource() != this.ctrlAltDelButton) break block9;
                try {
                    KeyEvent keyEvent = new KeyEvent(this, 401, 0L, 10, 127);
                    this.viewer.rfb.writeKeyEvent(keyEvent);
                    keyEvent = new KeyEvent(this, 402, 0L, 10, 127);
                    this.viewer.rfb.writeKeyEvent(keyEvent);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break block5;
            }
            if (actionEvent.getSource() != this.refreshButton) break block5;
            try {
                RfbProto rfbProto = this.viewer.rfb;
                rfbProto.writeFramebufferUpdateRequest(0, 0, rfbProto.framebufferWidth, rfbProto.framebufferHeight, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

