//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \brief A Document extension interface for handling Annotation%s
    ///  \ingroup kte_group_doc_extensions
    ///  \section annoiface_intro Introduction
    ///  The AnnotationInterface is designed to provide line annotation information
    ///  for a document. This interface provides means to associate a document with a
    ///  annotation model, which provides some annotation information for each line
    ///  in the document.
    ///  Setting a model for a Document makes the model data available for all views.
    ///  If you only want to provide annotations in exactly one view, you can use
    ///  the AnnotationViewInterface directly. See the AnnotationViewInterface for
    ///  further details. To summarize, the two use cases are
    ///  - (1) show annotations in all views. This means you set an AnnotationModel
    ///        with this interface, and then call setAnnotationBorderVisible() for
    ///        each view.
    ///  - (2) show annotations only in one view. This means to \e not use this
    ///        interface. Instead, use the AnnotationViewInterface, which inherits
    ///        this interface. This means you set a model for the specific View.
    ///  If you set a model to the Document \e and the View, the View's model has
    ///  higher priority.
    ///  \section annoiface_access Accessing the AnnotationInterface
    ///  The AnnotationInterface is an extension interface for a Document, i.e. the
    ///  Document inherits the interface \e provided that the
    ///  used KTextEditor library implements the interface. Use qobject_cast to
    ///  access the interface:
    ///  <pre>
    ///  // document is of type KTextEditor.Document
    ///  KTextEditor.AnnotationInterface iface =
    ///      qobject_cast<KTextEditor.AnnotationInterface>( document );
    ///  if( iface ) {
    ///      // the implementation supports the interface
    ///      // do stuff
    ///  }
    ///  </pre>
    ///  \section annoiface_usage Using the AnnotationInterface
    ///  \since 4.1
    ///  \see KTextEditor.AnnotationModel, KTextEditor.AnnotationViewInterface
    ///  </remarks>        <short>    \brief A Document extension interface for handling Annotation%s </short>
    [SmokeClass("KTextEditor::AnnotationInterface")]
    public class AnnotationInterface : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected AnnotationInterface(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(AnnotationInterface), this);
        }
        /// <remarks>
        ///  Sets a new \ref AnnotationModel for this document to provide
        ///  annotation information for each line.
        ///  \param model the new AnnotationModel
        ///      </remarks>        <short>    Sets a new \ref AnnotationModel for this document to provide  annotation information for each line.</short>
        [SmokeMethod("setAnnotationModel(KTextEditor::AnnotationModel*)")]
        public virtual void SetAnnotationModel(KTextEditor.AnnotationModel model) {
            interceptor.Invoke("setAnnotationModel#", "setAnnotationModel(KTextEditor::AnnotationModel*)", typeof(void), typeof(KTextEditor.AnnotationModel), model);
        }
        /// <remarks>
        ///  returns the currently set \ref AnnotationModel or 0 if there's none
        ///  set
        /// </remarks>        <return> the current \ref AnnotationModel
        ///      </return>
        ///         <short>    returns the currently set \ref AnnotationModel or 0 if there's none  set </short>
        [SmokeMethod("annotationModel() const")]
        public virtual KTextEditor.AnnotationModel AnnotationModel() {
            return (KTextEditor.AnnotationModel) interceptor.Invoke("annotationModel", "annotationModel() const", typeof(KTextEditor.AnnotationModel));
        }
        public AnnotationInterface() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AnnotationInterface", "AnnotationInterface()", typeof(void));
        }
        ~AnnotationInterface() {
            interceptor.Invoke("~AnnotationInterface", "~AnnotationInterface()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~AnnotationInterface", "~AnnotationInterface()", typeof(void));
        }
    }
}
