/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;
import javax.accessibility.Accessible;

public class ScrollPane
extends Container
implements Accessible,
Serializable {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private static final long serialVersionUID = 7956609840827222915L;
    private ScrollPaneAdjustable hAdjustable;
    private ScrollPaneAdjustable vAdjustable;
    private int scrollbarDisplayPolicy;
    private Point scrollPosition;

    private /* synthetic */ void finit$() {
        this.scrollPosition = new Point(0, 0);
    }

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int scrollbarDisplayPolicy) {
        this.finit$();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.scrollbarDisplayPolicy = scrollbarDisplayPolicy;
        if (scrollbarDisplayPolicy != 1 && scrollbarDisplayPolicy != 0 && scrollbarDisplayPolicy != 2) {
            throw new IllegalArgumentException("Bad scrollbarDisplayPolicy: " + scrollbarDisplayPolicy);
        }
        if (scrollbarDisplayPolicy != 2) {
            this.hAdjustable = new ScrollPaneAdjustable(0);
            this.vAdjustable = new ScrollPaneAdjustable(1);
        }
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Adjustable getHAdjustable() {
        return this.hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this.vAdjustable;
    }

    public Dimension getViewportSize() {
        Dimension viewsize = this.getSize();
        Insets insets = this.getInsets();
        viewsize.width -= insets.left + insets.right;
        viewsize.height -= insets.top + insets.bottom;
        ScrollPaneAdjustable v = (ScrollPaneAdjustable)this.getVAdjustable();
        ScrollPaneAdjustable h = (ScrollPaneAdjustable)this.getHAdjustable();
        if (v != null && v.isVisible()) {
            viewsize.width -= v.getSize().width;
        }
        if (h != null && h.isVisible()) {
            viewsize.height -= v.getSize().height;
        }
        return viewsize;
    }

    public int getHScrollbarHeight() {
        ScrollPanePeer spp = (ScrollPanePeer)this.getPeer();
        if (spp != null) {
            return spp.getHScrollbarHeight();
        }
        return 0;
    }

    public int getVScrollbarWidth() {
        ScrollPanePeer spp = (ScrollPanePeer)this.getPeer();
        if (spp != null) {
            return spp.getVScrollbarWidth();
        }
        return 0;
    }

    public Point getScrollPosition() {
        int x = 0;
        int y = 0;
        Adjustable v = this.getVAdjustable();
        Adjustable h = this.getHAdjustable();
        if (v != null) {
            y = v.getValue();
        }
        if (h != null) {
            x = h.getValue();
        }
        return new Point(x, y);
    }

    public void setScrollPosition(Point scrollPosition) throws IllegalArgumentException {
        this.setScrollPosition(scrollPosition.x, scrollPosition.y);
    }

    public void setScrollPosition(int x, int y) {
        ScrollPanePeer spp;
        Adjustable h = this.getHAdjustable();
        Adjustable v = this.getVAdjustable();
        if (h != null) {
            h.setValue(x);
        }
        if (v != null) {
            v.setValue(y);
        }
        if ((spp = (ScrollPanePeer)this.getPeer()) != null) {
            spp.setScrollPosition(x, y);
        }
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            return;
        }
        this.setPeer(this.getToolkit().createScrollPane(this));
        if (this.hAdjustable != null) {
            this.hAdjustable.addNotify();
        }
        if (this.vAdjustable != null) {
            this.vAdjustable.removeNotify();
        }
    }

    public void removeNotify() {
        if (this.hAdjustable != null) {
            this.hAdjustable.removeNotify();
        }
        if (this.vAdjustable != null) {
            this.vAdjustable.removeNotify();
        }
        super.removeNotify();
    }

    public final void addImpl(Component component, Object constraints, int index) {
        Component[] list = this.getComponents();
        if (list != null && list.length > 0) {
            this.remove(list[0]);
        }
        super.addImpl(component, constraints, -1);
        this.doLayout();
    }

    public void doLayout() {
        Component[] list = this.getComponents();
        if (list != null && list.length > 0) {
            Dimension dim = list[0].getPreferredSize();
            list[0].resize(dim);
            Point p = this.getScrollPosition();
            if (p.x > dim.width) {
                p.x = dim.width;
            }
            if (p.y > dim.height) {
                p.y = dim.height;
            }
            this.setScrollPosition(p);
        }
    }

    public void layout() {
        this.doLayout();
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void printComponents(Graphics graphics) {
        super.printComponents(graphics);
    }

    public String paramString() {
        return this.getClass().getName();
    }
}

