
#ifndef ACPI_PANEL_START_H
#define ACPI_PANEL_START_H
#include <qobject.h>
#include <kconfig.h>
#include <qvgroupbox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <klineedit.h>
#include <kdialog.h>

class acpi_config : public QObject {
	Q_OBJECT
public:
	acpi_config(QWidget *parent, KConfig *config, QVBoxLayout *layout);
	acpi_config(KConfig *config);
	~acpi_config();
	bool	has_sleep() { return acpi_sleep_enabled; }
	bool	has_suspend() { return acpi_suspend_enabled; }
	bool	has_hibernate() { return acpi_hibernate_enabled; }
	void	do_sleep() { if (acpi_sleep_enabled) do_command(acpi_sleep); }
	void	do_suspend() { if (acpi_suspend_enabled) do_command(acpi_suspend); }
	void	do_hibernate() { if (acpi_hibernate_enabled) do_command(acpi_hibernate); }
private slots:
	void	acpi_config_start();
private:
	void	do_command(QString &cmd);
	KConfig *saved_config;
	QString acpi_sleep;
	QString acpi_suspend;
	QString acpi_hibernate;
	bool acpi_sleep_enabled, acpi_suspend_enabled, acpi_hibernate_enabled;
};

class acpi_dialog: public KDialog {
	Q_OBJECT
public:
	acpi_dialog(KConfig *config,bool sleep_e, QString &sleep_t,
                bool suspend_e, QString &suspend_t,
                bool hibernate_e, QString &hibernate_t);
	void	Save(bool &sleep_e, QString &sleep_t,
                	bool &suspend_e, QString &suspend_t,
                	bool &hibernate_e, QString &hibernate_t);
private slots:
	void	configChanged();
private:
	bool		changed;
	KConfig 	*config;

	QCheckBox	*sleep_enabled;
	KLineEdit	*sleep_edit;

	QCheckBox	*suspend_enabled;
	KLineEdit	*suspend_edit;

	QCheckBox	*hibernate_enabled;
	KLineEdit	*hibernate_edit;

	QPushButton	*save_button;
	QPushButton	*cancel_button;
};

#endif
