/*
    Copyright (c) 2002 Alexander Kellett <lypanov@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License (LGPL) as published by the Free Software Foundation;
    either version 2 of the License, or (at your option) any later
    version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kdebug.h>
#include <kaction.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kinstance.h>
#include <khtml_part.h>
#include <kgenericfactory.h>

#include <krun.h>
#include <kservice.h>

#include <kpopupmenu.h>
#include <kbookmarkimporter_crash.h>

#include "crashesplugin.h"

typedef KGenericFactory<CrashesPlugin> CrashesPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libcrashesplugin,
	                    CrashesPluginFactory( "crashesplugin" ) );

CrashesPlugin::CrashesPlugin( QObject* parent, const char* name,
                                  const QStringList & )
                :KParts::Plugin( parent, name )
{
  m_pCrashesMenu = new KActionMenu( i18n("&Crashes"), "core",
                               actionCollection(), "crashes" );
  m_pCrashesMenu->setDelayed( false );
  connect( m_pCrashesMenu->popupMenu(), SIGNAL( aboutToShow() ),
           this, SLOT( slotAboutToShow() ) );

  // m_bSettingsLoaded = false;
  m_part = 0L;
  m_pCrashesMenu->setEnabled ( true );

  if ( parent && parent->inherits( "KHTMLPart" ) )
  {
     m_part = static_cast<KHTMLPart*>(parent);
  }

}

CrashesPlugin::~CrashesPlugin()
{
  // saveSettings();
}

void CrashesPlugin::slotAboutToShow()
{
  /*
  if (!m_bSettingsLoaded)
    loadSettings();
  */

  m_pCrashesMenu->popupMenu()->clear();

  KCrashBookmarkImporter importer(KCrashBookmarkImporter::crashBookmarksDir());

  connect( &importer, SIGNAL( newBookmark( const QString &, const QCString &, const QString &) ),
                      SLOT( newBookmarkCallback( const QString &, const QCString &, const QString & ) ) );

  connect( &importer, SIGNAL( endFolder() ), SLOT( endFolderCallback() ) );

  // connect( &importer, SIGNAL( newFolder( const QString &, bool, const QString & ) ),
                      // SLOT( newFolder( const QString &, bool, const QString & ) ) );
  // connect( &importer, SIGNAL( newSeparator() ), SLOT( newSeparator() ) );

  int count = m_pCrashesMenu->popupMenu()->count();

  m_crashesList.clear();
  importer.parseCrashBookmarks( false );

  bool gotSep = true; // don't start with a sep

  if (m_crashesList.count() > 0) {
     CrashesList::ConstIterator e = m_crashesList.begin();
     for( ; e != m_crashesList.end(); ++e ) {
        if ( ((*e).first  == "-") 
          && ((*e).second == "-") 
          && (!gotSep)
        ) {
           m_pCrashesMenu->popupMenu()->insertSeparator();
           gotSep = true;
           count++;
        } else {
           QString str = (*e).first;
           if (str.length() > 48) {
              str.truncate(48);
              str.append("...");
           }
           m_pCrashesMenu->popupMenu()->insertItem( 
              str, this,
              SLOT(slotItemSelected(int)),
              0, ++count );
           gotSep = false;
        }
     }
  } else {
     m_pCrashesMenu->popupMenu()->insertItem( 
        i18n("No Recovered Crashes"), this, 
        SLOT(slotItemSelected(int)), 
        0, ++count );
     gotSep = false;
  }

  if (!gotSep) {
     // don't have an extra sep
     m_pCrashesMenu->popupMenu()->insertSeparator();
  }

  m_pCrashesMenu->popupMenu()->insertItem( i18n("&Clear List of Crashes"), this,
                                      SLOT(slotClearCrashes()),
                                      0, ++count );  

}

void CrashesPlugin::newBookmarkCallback( const QString & text, const QCString & url, const QString & additionnalInfo )
{
  m_crashesList << qMakePair(text,url);
}

void CrashesPlugin::endFolderCallback( )
{
  m_crashesList << qMakePair(QString("-"),QCString("-"));
}

void CrashesPlugin::slotClearCrashes() {
  KCrashBookmarkImporter importer(KCrashBookmarkImporter::crashBookmarksDir());
  importer.parseCrashBookmarks( true );
  slotAboutToShow();
}

void CrashesPlugin::slotItemSelected( int id )
{
  if (m_crashesList.count() == 0)
     return;
  KURL url( m_crashesList[id-1].second );
  emit m_part->browserExtension()->openURLRequest( url );
}

#if 0

void CrashesPlugin::saveSettings()
{
  if(!m_bSettingsLoaded) return;

  KConfig cfg ("crashesrc", false, false);
  cfg.setGroup ("General");

  // cfg.writeEntry ("applyToDomain", m_bApplyToDomain);
}

void CrashesPlugin::loadSettings()
{
  KConfig cfg ("crashesrc", false, false);
  cfg.setGroup ("General");

  // m_bApplyToDomain = cfg.readBoolEntry ("applyToDomain", true);
  m_bSettingsLoaded = true;
}

#endif

#include "crashesplugin.moc"
