/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import sun.security.provider.SHA5;

public class SHA3
extends SHA5 {
    private static final int LENGTH = 48;
    private static final long[] INITIAL_HASHES = new long[]{-3766243637369397544L, 7105036623409894663L, -7973340178411365097L, 1526699215303891257L, 7436329637833083697L, -8163818279084223215L, -2662702644619276377L, 5167115440072839076L};

    protected int engineGetDigestLength() {
        return 48;
    }

    public SHA3() {
        this.init();
    }

    protected void engineReset() {
        this.init();
    }

    void init() {
        super.init();
        this.setInitialHash(INITIAL_HASHES);
    }

    protected byte[] engineDigest() {
        byte[] byArray = super.engineDigest();
        byte[] byArray2 = new byte[48];
        System.arraycopy(byArray, 0, byArray2, 0, 48);
        return byArray2;
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < 48) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n2 < 48) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        super.performDigest(byArray, n2, 48);
        return 48;
    }

    public Object clone() {
        SHA3 sHA3 = null;
        sHA3 = new SHA3(this);
        return sHA3;
    }

    private SHA3(SHA3 sHA3) {
        super(sHA3);
    }
}

