/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ContextElement;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.TypeContext;
import sun.tools.java.CompilerError;

public class ContextStack {
    public static final int TOP = 1;
    public static final int METHOD = 2;
    public static final int METHOD_RETURN = 3;
    public static final int METHOD_ARGUMENT = 4;
    public static final int METHOD_EXCEPTION = 5;
    public static final int MEMBER = 6;
    public static final int MEMBER_CONSTANT = 7;
    public static final int MEMBER_STATIC = 8;
    public static final int MEMBER_TRANSIENT = 9;
    public static final int IMPLEMENTS = 10;
    public static final int EXTENDS = 11;
    private static final String[] CODE_NAMES = new String[]{"UNKNOWN ", "Top level type ", "Method ", "Return parameter ", "Parameter ", "Exception ", "Member ", "Constant member ", "Static member ", "Transient member ", "Implements ", "Extends "};
    private int currentIndex = -1;
    private int maxIndex = 100;
    private TypeContext[] stack = new TypeContext[this.maxIndex];
    private int newCode = 1;
    private BatchEnvironment env = null;
    private boolean trace = false;
    private TypeContext tempContext = new TypeContext();
    private static final String TRACE_INDENT = "   ";

    public int getCurrentContextCode() {
        return this.newCode;
    }

    public int size() {
        return this.currentIndex + 1;
    }

    public void clear() {
        for (int i = 0; i < this.stack.length; ++i) {
            if (this.stack[i] == null) continue;
            this.stack[i].destroy();
        }
    }

    public static final void dumpCallStack() {
        new Error().printStackTrace(System.out);
    }

    final void traceCallStack() {
        if (this.trace) {
            ContextStack.dumpCallStack();
        }
    }

    public boolean anyErrors() {
        return this.env.nerrors > 0;
    }

    public boolean isParentAValue() {
        if (this.currentIndex > 0) {
            return this.stack[this.currentIndex - 1].isValue();
        }
        return false;
    }

    public boolean isTraceOn() {
        return this.trace;
    }

    public void setNewContextCode(int n) {
        this.newCode = n;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public String getContextCodeString() {
        if (this.currentIndex >= 0) {
            return CODE_NAMES[this.newCode];
        }
        return CODE_NAMES[0];
    }

    public static String getContextCodeString(int n) {
        return CODE_NAMES[n];
    }

    final void trace(String string) {
        if (this.trace) {
            this.tracePrint(string, false);
        }
    }

    final void traceln(String string) {
        if (this.trace) {
            this.tracePrint(string, true);
        }
    }

    private final void tracePrint(String string, boolean bl) {
        int n = string.length() + this.currentIndex * TRACE_INDENT.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < this.currentIndex; ++i) {
            stringBuffer.append(TRACE_INDENT);
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append("\n");
        }
        System.out.print(stringBuffer.toString());
    }

    public BatchEnvironment getEnv() {
        return this.env;
    }

    public ContextStack(BatchEnvironment batchEnvironment) {
        this.env = batchEnvironment;
        batchEnvironment.contextStack = this;
    }

    final void traceExistingType(Type type) {
        if (this.trace) {
            this.tempContext.set(this.newCode, type);
            this.traceln(this.toResultString(this.tempContext, true, true));
        }
    }

    public TypeContext getContext() {
        if (this.currentIndex < 0) {
            throw new Error("Nothing on stack!");
        }
        return this.stack[this.currentIndex];
    }

    public TypeContext getParentContext() {
        if (this.currentIndex > 0) {
            return this.stack[this.currentIndex - 1];
        }
        return null;
    }

    public TypeContext getContext(int n) {
        if (this.currentIndex < n) {
            throw new Error("Index out of range");
        }
        return this.stack[n];
    }

    public TypeContext pop(boolean bl) {
        if (this.currentIndex < 0) {
            throw new CompilerError("Nothing on stack!");
        }
        this.newCode = this.stack[this.currentIndex].getCode();
        this.traceln(this.toResultString(this.stack[this.currentIndex], bl, false));
        Type type = this.stack[this.currentIndex].getCandidateType();
        if (type != null) {
            if (bl) {
                type.setStatus(1);
            } else {
                type.setStatus(2);
            }
        }
        --this.currentIndex;
        if (this.currentIndex < 0) {
            if (bl) {
                Type.updateAllInvalidTypes(this);
            }
            return null;
        }
        return this.stack[this.currentIndex];
    }

    private String toTrialString(TypeContext typeContext) {
        int n = typeContext.getCode();
        if (n != 2 && n != 6) {
            return typeContext.toString() + " (trying " + typeContext.getTypeDescription() + ")";
        }
        return typeContext.toString();
    }

    private String toResultString(TypeContext typeContext, boolean bl, boolean bl2) {
        int n = typeContext.getCode();
        if (n != 2 && n != 6) {
            if (bl) {
                String string = typeContext.toString() + " --> " + typeContext.getTypeDescription();
                if (bl2) {
                    return string + " [Previously mapped]";
                }
                return string;
            }
        } else if (bl) {
            return typeContext.toString() + " --> [Mapped]";
        }
        return typeContext.toString() + " [Did not map]";
    }

    public TypeContext push(ContextElement contextElement) {
        TypeContext typeContext;
        ++this.currentIndex;
        if (this.currentIndex == this.maxIndex) {
            int n = this.maxIndex * 2;
            TypeContext[] typeContextArray = new TypeContext[n];
            System.arraycopy(this.stack, 0, typeContextArray, 0, this.maxIndex);
            this.maxIndex = n;
            this.stack = typeContextArray;
        }
        if ((typeContext = this.stack[this.currentIndex]) == null) {
            this.stack[this.currentIndex] = typeContext = new TypeContext();
        }
        typeContext.set(this.newCode, contextElement);
        this.traceln(this.toTrialString(typeContext));
        return typeContext;
    }
}

