/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.javah.Gen;
import com.sun.tools.javah.Mangle;
import com.sun.tools.javah.Util;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class OldHeaders
extends Gen {
    private static final String cindent = "    ";
    private static final String cpad = "char PAD;\t/* ANSI C requires structures to have a least one member */";
    private static final int FOR_FIELD = 0;
    private static final int FOR_METHOD = 1;

    public OldHeaders(RootDoc rootDoc) {
        super(rootDoc);
    }

    protected String getIncludes() {
        return "#include <native.h>";
    }

    protected void write(OutputStream outputStream, ClassDoc classDoc) throws ClassNotFoundException {
        PrintWriter printWriter = this.wrapWriter(outputStream);
        String string = Mangle.mangle(classDoc.qualifiedName(), 1);
        FieldDoc[] fieldDocArray = classDoc.fields();
        MethodDoc[] methodDocArray = classDoc.methods();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        int n = this.getCStruct(classDoc, fieldDocArray, vector3, vector2);
        int n2 = vector3.size();
        vector = this.getCPrototypes(classDoc, methodDocArray, vector3);
        printWriter.println(this.guardBegin(string));
        if (!classDoc.qualifiedName().equals("java.lang.Object") && !classDoc.qualifiedName().equals("java.lang.Class")) {
            int n3 = 0;
            Object object = vector3.elements();
            while (n3++ < n2 && object.hasMoreElements()) {
                printWriter.println("struct H" + (String)object.nextElement() + ";");
            }
            printWriter.println();
            object = Util.getPlatformString("pack.pragma.start");
            if (object != null) {
                printWriter.println((String)object);
            }
            printWriter.println("typedef struct Class" + string + " {");
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println((String)enumeration.nextElement());
            }
            if (n == 0) {
                printWriter.println("    char PAD;\t/* ANSI C requires structures to have a least one member */");
            }
            printWriter.println("} Class" + string + ";\n" + "HandleTo(" + string + ");\n");
            object = Util.getPlatformString("pack.pragma.end");
            if (object != null) {
                printWriter.println((String)object);
            }
        }
        printWriter.println(this.cppGuardBegin());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println((String)enumeration.nextElement());
        }
        printWriter.println(this.cppGuardEnd());
        printWriter.println(this.guardEnd(string));
    }

    private String getCType(Type type, int n) {
        String string = type.typeName();
        if (type.dimension().indexOf("[]") == -1) {
            if (type.asClassDoc() != null) {
                String string2 = Mangle.mangle(type.asClassDoc().qualifiedName(), 1);
                return "struct H" + string2 + " *";
            }
            if (string.equals("void")) {
                return "void";
            }
            if (string.equals("int")) {
                return "int32_t";
            }
            if (string.equals("boolean")) {
                return "/*boolean*/ int32_t";
            }
            if (string.equals("long")) {
                return "int64_t";
            }
            if (string.equals("float")) {
                return "float";
            }
            if (string.equals("double")) {
                return "double";
            }
            if (string.equals("byte")) {
                return n == 0 ? "int32_t" : "int8_t";
            }
            if (string.equals("short")) {
                return n == 0 ? "int32_t" : "short";
            }
            if (string.equals("char")) {
                return n == 0 ? "int32_t" : "unicode";
            }
        } else if (type.dimension().indexOf("[]") != -1) {
            String string3 = null;
            if (string.equals("int")) {
                string3 = "HArrayOfInt *";
            } else if (string.equals("byte")) {
                string3 = "HArrayOfByte *";
            } else if (string.equals("char")) {
                string3 = "HArrayOfChar *";
            } else if (string.equals("short")) {
                string3 = "HArrayOfShort *";
            } else if (string.equals("long")) {
                string3 = "HArrayOfLong *";
            } else if (string.equals("float")) {
                string3 = "HArrayOfFloat *";
            } else if (string.equals("double")) {
                string3 = "HArrayOfDouble *";
            } else if (type.dimension().indexOf("[][]") != -1) {
                string3 = "HArrayOfArray *";
            } else if (n == 1 && string.equals("String")) {
                string3 = "HArrayOfString *";
            } else if (type.asClassDoc() != null) {
                string3 = "HArrayOfObject *";
            } else {
                Util.bug("unknown.array.type");
            }
            if (n == 1) {
                return string3;
            }
            if (n == 0) {
                return "struct " + string3;
            }
        } else {
            Util.bug("unknown.type.for.field");
        }
        return null;
    }

    private boolean addFwddeclIfRequired(Vector vector, Type type, String string) {
        String string2;
        if (type.asClassDoc() != null && type.dimension().indexOf("[]") == -1) {
            String string3 = Mangle.mangle(type.asClassDoc().qualifiedName(), 1);
            if (!vector.contains(string3) && !string.equals(string3)) {
                vector.add(string3);
                return true;
            }
        } else if (type.dimension().indexOf("[]") != -1 && type.asClassDoc() != null && !vector.contains(string2 = Mangle.mangle(type.asClassDoc().qualifiedName(), 1)) && !string.equals(string2)) {
            vector.add(string2);
            return true;
        }
        return false;
    }

    private boolean addFwddeclIfRequired(Vector vector, Vector vector2, Type type, String string) {
        String string2;
        if (type.asClassDoc() != null && type.dimension().indexOf("[]") == -1) {
            String string3 = Mangle.mangle(type.asClassDoc().qualifiedName(), 1);
            if (!(vector.contains(string3) || string.equals(string3) || vector2.contains(string3))) {
                vector2.add(string3);
                return true;
            }
        } else if (!(type.dimension().indexOf("[]") == -1 || type.asClassDoc() == null || vector.contains(string2 = Mangle.mangle(type.asClassDoc().qualifiedName(), 1)) || string.equals(string2) || vector2.contains(string2))) {
            vector2.add(string2);
            return true;
        }
        return false;
    }

    private int getCStruct(ClassDoc classDoc, FieldDoc[] fieldDocArray, Vector vector, Vector vector2) {
        int n = 0;
        if (fieldDocArray.length == 0) {
            return n;
        }
        for (int i = 0; i < fieldDocArray.length; ++i) {
            FieldDoc fieldDoc = fieldDocArray[i];
            Type type = fieldDoc.type();
            String string = Mangle.mangle(fieldDoc.name(), 2);
            if (fieldDoc.isStatic()) {
                String string2 = this.defineForStatic(classDoc, fieldDoc);
                if (string2 == null) continue;
                vector2.add(string2);
                continue;
            }
            if (type.asClassDoc() != null || type.dimension().indexOf("[]") != -1) {
                vector2.add(cindent + this.getCType(type, 0) + string + ";");
            } else {
                vector2.add(cindent + this.getCType(type, 0) + " " + string + ";");
            }
            ++n;
            this.addFwddeclIfRequired(vector, type, classDoc.qualifiedName());
        }
        return n;
    }

    private Vector getCPrototypes(ClassDoc classDoc, MethodDoc[] methodDocArray, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        for (int i = 0; i < methodDocArray.length; ++i) {
            MethodDoc methodDoc = methodDocArray[i];
            if (!methodDoc.isNative()) continue;
            Type type = methodDoc.returnType();
            String string = this.getCType(type, 1);
            StringBuffer stringBuffer = new StringBuffer(80);
            String string2 = Mangle.mangle(classDoc.qualifiedName(), 1);
            String string3 = Mangle.mangle(methodDoc.name(), 2);
            stringBuffer.append("extern ");
            vector3.setSize(0);
            stringBuffer.append(string);
            if (type.dimension().indexOf("[]") == -1 && type.asClassDoc() == null) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            stringBuffer.append("_");
            stringBuffer.append(string3);
            stringBuffer.append("(");
            Parameter[] parameterArray = methodDoc.parameters();
            stringBuffer.append("struct H");
            stringBuffer.append(string2);
            if (parameterArray.length == 0) {
                stringBuffer.append(" *");
            } else {
                stringBuffer.append(" *,");
            }
            for (int j = 0; j < parameterArray.length; ++j) {
                stringBuffer.append(this.getCType(parameterArray[j].type(), 1));
                if (j != parameterArray.length - 1) {
                    stringBuffer.append(',');
                }
                this.addFwddeclIfRequired(vector, vector3, parameterArray[j].type(), classDoc.qualifiedName());
            }
            this.addFwddeclIfRequired(vector, vector3, type, classDoc.qualifiedName());
            stringBuffer.append(");");
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                vector2.add("struct H" + string4 + ";");
                vector.add(string4);
            }
            vector2.add(stringBuffer.toString());
        }
        return vector2;
    }
}

