/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.extcheck;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

public class ExtCheck {
    private static final boolean DEBUG = false;
    private String targetSpecTitle;
    private String targetSpecVersion;
    private String targetSpecVendor;
    private String targetImplTitle;
    private String targetImplVersion;
    private String targetImplVendor;
    private String targetsealed;
    private boolean verboseFlag;

    boolean checkInstalledAgainstTarget() {
        File[] fileArray;
        int n;
        String string = System.getProperty("java.ext.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            n = stringTokenizer.countTokens();
            fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                fileArray[i] = new File(stringTokenizer.nextToken());
            }
        } else {
            fileArray = new File[]{};
        }
        boolean bl = true;
        for (n = 0; n < fileArray.length; ++n) {
            String[] stringArray = fileArray[n].list();
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    File file = new File(fileArray[n], stringArray[i]);
                    File file2 = new File(file.getCanonicalPath());
                    URL uRL = ParseUtil.fileToEncodedURL(file2);
                    if (uRL == null) continue;
                    bl = bl && this.checkURLRecursively(1, uRL);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    ExtCheck.error("Malformed URL");
                    continue;
                }
                catch (IOException iOException) {
                    ExtCheck.error("IO Exception");
                }
            }
        }
        if (bl) {
            this.generalMessage("No conflicting installed jar found.");
        } else {
            this.generalMessage("Conflicting installed jar found.  Use -verbose for more information.");
        }
        return bl;
    }

    private void investigateTarget(File file) {
        Object object;
        this.verboseMessage("Target file:" + file);
        Manifest manifest = null;
        try {
            object = new File(file.getCanonicalPath());
            URL uRL = ParseUtil.fileToEncodedURL((File)object);
            if (uRL != null) {
                JarLoader jarLoader = new JarLoader(uRL);
                JarFile jarFile = jarLoader.getJarFile();
                manifest = jarFile.getManifest();
            }
        }
        catch (MalformedURLException malformedURLException) {
            ExtCheck.error("Malformed URL ");
        }
        catch (IOException iOException) {
            ExtCheck.error("IO Exception ");
        }
        if (manifest == null) {
            ExtCheck.error("No manifest available in " + file);
        }
        if ((object = manifest.getMainAttributes()) != null) {
            this.targetSpecTitle = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_TITLE);
            this.targetSpecVersion = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VERSION);
            this.targetSpecVendor = ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VENDOR);
            this.targetImplTitle = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            this.targetImplVersion = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            this.targetImplVendor = ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            this.targetsealed = ((Attributes)object).getValue(Attributes.Name.SEALED);
        } else {
            ExtCheck.error("No attributes available in the manifest");
        }
        if (this.targetSpecTitle == null) {
            ExtCheck.error("The target file does not have a specification title");
        }
        if (this.targetSpecVersion == null) {
            ExtCheck.error("The target file does not have a specification version");
        }
        this.verboseMessage("Specification title:" + this.targetSpecTitle);
        this.verboseMessage("Specification version:" + this.targetSpecVersion);
        if (this.targetSpecVendor != null) {
            this.verboseMessage("Specification vendor:" + this.targetSpecVendor);
        }
        if (this.targetImplVersion != null) {
            this.verboseMessage("Implementation version:" + this.targetImplVersion);
        }
        if (this.targetImplVendor != null) {
            this.verboseMessage("Implementation vendor:" + this.targetImplVendor);
        }
        this.verboseMessage("");
    }

    private ExtCheck(File file, boolean bl) {
        this.verboseFlag = bl;
        this.investigateTarget(file);
    }

    static void error(String string) {
        System.err.println(string);
        System.exit(-1);
    }

    void generalMessage(String string) {
        System.err.println(string);
    }

    void verboseMessage(String string) {
        if (this.verboseFlag) {
            System.err.println(string);
        }
    }

    private boolean checkURLRecursively(int n, URL uRL) throws IOException {
        Object object;
        Attributes attributes;
        this.verboseMessage("Comparing with " + uRL);
        JarLoader jarLoader = new JarLoader(uRL);
        JarFile jarFile = jarLoader.getJarFile();
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
            object = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            String string = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            String string2 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            String string3 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            String string4 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            String string5 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            String string6 = attributes.getValue(Attributes.Name.SEALED);
            if (object != null && ((String)object).equals(this.targetSpecTitle) && string != null && (string.equals(this.targetSpecVersion) || this.isNotOlderThan(string, this.targetSpecVersion))) {
                this.verboseMessage("");
                this.verboseMessage("CONFLICT DETECTED ");
                this.verboseMessage("Conflicting file:" + uRL);
                this.verboseMessage("Installed Version:" + string);
                if (string3 != null) {
                    this.verboseMessage("Implementation Title:" + string3);
                }
                if (string4 != null) {
                    this.verboseMessage("Implementation Version:" + string4);
                }
                if (string5 != null) {
                    this.verboseMessage("Implementation Vendor:" + string5);
                }
                return false;
            }
        }
        boolean bl = true;
        object = jarLoader.getClassPath();
        if (object != null) {
            for (int i = 0; i < ((URL[])object).length; ++i) {
                if (uRL == null) continue;
                boolean bl2 = this.checkURLRecursively(n + 1, object[i]);
                bl = bl2 && bl;
            }
        }
        return bl;
    }

    static ExtCheck create(File file, boolean bl) {
        return new ExtCheck(file, bl);
    }

    private boolean isNotOlderThan(String string, String string2) throws NumberFormatException {
        if (string == null || string.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ".", true);
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            int n2 = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0;
            if (n2 < n) {
                return false;
            }
            if (n2 > n) {
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            stringTokenizer2.nextToken();
        }
        return true;
    }

    private static class JarLoader {
        private final URL base;
        private JarFile jar;
        private URL csu;

        URL getBaseURL() {
            return this.base;
        }

        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            Manifest manifest = this.jar.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        JarLoader(URL uRL) {
            String string = uRL + "!/";
            URL uRL2 = null;
            try {
                uRL2 = new URL("jar", "", string);
                this.jar = this.findJarFile(uRL);
                this.csu = uRL;
            }
            catch (MalformedURLException malformedURLException) {
                ExtCheck.error("Malformed url " + string);
            }
            catch (IOException iOException) {
                ExtCheck.error("IO Exception occurred");
            }
            this.base = uRL2;
        }

        JarFile getJarFile() {
            return this.jar;
        }

        private JarFile findJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                String string = uRL.getFile().replace('/', File.separatorChar);
                File file = new File(string);
                if (!file.exists()) {
                    throw new FileNotFoundException(string);
                }
                return new JarFile(string);
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            return ((JarURLConnection)uRLConnection).getJarFile();
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n] = new URL(uRL, string2);
                ++n;
            }
            return uRLArray;
        }
    }
}

