/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

public class Areas
extends ControlsSurface {
    protected String areaType = "nop";

    public Areas() {
        this.setBackground(Color.white);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)n * 0.25f, 0.0f);
        generalPath.lineTo((float)n * 0.75f, (float)n2 * 0.5f);
        generalPath.lineTo((float)n * 0.25f, n2);
        generalPath.lineTo(0.0f, (float)n2 * 0.5f);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)n * 0.75f, 0.0f);
        generalPath2.lineTo(n, (float)n2 * 0.5f);
        generalPath2.lineTo((float)n * 0.75f, n2);
        generalPath2.lineTo((float)n * 0.25f, (float)n2 * 0.5f);
        generalPath2.closePath();
        Area area = new Area(generalPath);
        graphics2D.setColor(Color.yellow);
        if (this.areaType.equals("nop")) {
            graphics2D.fill(generalPath);
            graphics2D.fill(generalPath2);
            graphics2D.setColor(Color.red);
            graphics2D.draw(generalPath);
            graphics2D.draw(generalPath2);
            return;
        }
        if (this.areaType.equals("add")) {
            area.add(new Area(generalPath2));
        } else if (this.areaType.equals("sub")) {
            area.subtract(new Area(generalPath2));
        } else if (this.areaType.equals("xor")) {
            area.exclusiveOr(new Area(generalPath2));
        } else if (this.areaType.equals("int")) {
            area.intersect(new Area(generalPath2));
        } else if (this.areaType.equals("pear")) {
            double d = n / 100;
            double d2 = n2 / 140;
            graphics2D.scale(d, d2);
            double d3 = (double)n / d / 2.0;
            double d4 = (double)n2 / d2 / 2.0;
            Ellipse2D.Double double_ = new Ellipse2D.Double(d3 - 16.0, d4 - 29.0, 15.0, 15.0);
            Area area2 = new Area(double_);
            ((RectangularShape)double_).setFrame(d3 - 14.0, d4 - 47.0, 30.0, 30.0);
            Area area3 = new Area(double_);
            area2.intersect(area3);
            graphics2D.setColor(Color.green);
            graphics2D.fill(area2);
            ((RectangularShape)double_).setFrame(d3 + 1.0, d4 - 29.0, 15.0, 15.0);
            area2 = new Area(double_);
            area3.intersect(area2);
            graphics2D.fill(area3);
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d3, d4 - 42.0, 40.0, 40.0);
            Area area4 = new Area(double_2);
            ((RectangularShape)double_2).setFrame(d3 + 3.0, d4 - 47.0, 50.0, 50.0);
            area4.subtract(new Area(double_2));
            graphics2D.setColor(Color.black);
            graphics2D.fill(area4);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(d3 - 25.0, d4, 50.0, 50.0);
            Ellipse2D.Double double_4 = new Ellipse2D.Double(d3 - 19.0, d4 - 20.0, 40.0, 70.0);
            Area area5 = new Area(double_3);
            area5.add(new Area(double_4));
            graphics2D.setColor(Color.yellow);
            graphics2D.fill(area5);
            return;
        }
        graphics2D.fill(area);
        graphics2D.setColor(Color.red);
        graphics2D.draw(area);
    }

    public static void main(String[] stringArray) {
        Areas.createDemoFrame(new Areas());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Areas demo;
        JToolBar toolbar;
        JComboBox combo;

        public DemoControls(Areas areas) {
            super(areas.name);
            this.demo = areas;
            this.setBackground(Color.gray);
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("nop", "no area operation", true);
            this.addTool("add", "add", false);
            this.addTool("sub", "subtract", false);
            this.addTool("xor", "exclusiveOr", false);
            this.addTool("int", "intersection", false);
            this.addTool("pear", "pear", false);
        }

        public void addTool(String string, String string2, boolean bl) {
            JButton jButton = (JButton)this.toolbar.add(new JButton(string));
            jButton.setBackground(bl ? Color.green : Color.lightGray);
            jButton.setToolTipText(string2);
            jButton.setSelected(bl);
            jButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
                JButton jButton = (JButton)this.toolbar.getComponentAtIndex(i);
                jButton.setBackground(Color.lightGray);
            }
            JButton jButton = (JButton)actionEvent.getSource();
            jButton.setBackground(Color.green);
            this.demo.areaType = jButton.getText();
            this.demo.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 37);
        }

        public void run() {
            try {
                Thread.sleep(1111L);
            }
            catch (Exception exception) {
                return;
            }
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
                    ((JButton)this.toolbar.getComponentAtIndex(i)).doClick();
                    try {
                        Thread.sleep(4444L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

