/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.DownloadWindow;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.jnlp.JNLPClassLoader;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;

public final class DownloadServiceImpl
implements DownloadService {
    private static DownloadServiceImpl _sharedInstance = null;
    private DownloadServiceListener _defaultProgress = null;

    private DownloadServiceImpl() {
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new DownloadServiceImpl();
        }
    }

    private void removeJARFromCache(JARDesc[] jARDescArray) throws IOException {
        if (jARDescArray == null) {
            return;
        }
        if (jARDescArray.length == 0) {
            return;
        }
        DiskCacheEntry diskCacheEntry = null;
        int n = 0;
        while (n < jARDescArray.length) {
            int n2 = jARDescArray[n].isNativeLib() ? 1 : 0;
            try {
                diskCacheEntry = DownloadProtocol.getResource(jARDescArray[n].getLocation(), jARDescArray[n].getVersion(), n2, true, null);
            }
            catch (JNLPException jNLPException) {
                throw new IOException(jNLPException.getMessage());
            }
            if (diskCacheEntry != null) {
                InstallCache.getDiskCache().removeEntry(diskCacheEntry);
            }
            ++n;
        }
    }

    private boolean isJARInCache(JARDesc[] jARDescArray, boolean bl) {
        if (jARDescArray == null) {
            return false;
        }
        if (jARDescArray.length == 0) {
            return false;
        }
        boolean bl2 = true;
        int n = 0;
        while (n < jARDescArray.length) {
            if (jARDescArray[n].isNativeLib()) {
                if (DownloadProtocol.isInCache(jARDescArray[n].getLocation(), jARDescArray[n].getVersion(), 1)) {
                    if (!bl) {
                        return true;
                    }
                } else {
                    bl2 = false;
                }
            } else if (DownloadProtocol.isInCache(jARDescArray[n].getLocation(), jARDescArray[n].getVersion(), 0)) {
                if (!bl) {
                    return true;
                }
            } else {
                bl2 = false;
            }
            ++n;
        }
        return bl2;
    }

    public static synchronized DownloadServiceImpl getInstance() {
        DownloadServiceImpl.initialize();
        return _sharedInstance;
    }

    public void removePart(String string) throws IOException {
        this.removePart(new String[]{string});
    }

    public boolean isPartCached(String string) {
        return this.isPartCached(new String[]{string});
    }

    public void removePart(final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public boolean isPartCached(final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public DownloadServiceListener getDefaultProgressWindow() {
        if (this._defaultProgress == null) {
            this._defaultProgress = (DownloadServiceListener)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new DefaultProgressImpl(new DownloadWindow(JNLPClassLoader.getInstance().getLaunchDesc(), false));
                }
            });
        }
        return this._defaultProgress;
    }

    public void removeResource(final URL uRL, final String string) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public boolean isResourceCached(final URL uRL, final String string) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadProtocol.isInCache(uRL, string, 0) || DownloadProtocol.isInCache(uRL, string, 1)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public void loadPart(String string, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadPart(new String[]{string}, downloadServiceListener);
    }

    public void loadPart(final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isPartCached(stringArray)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        JNLPClassLoader.getInstance().downloadParts(stringArray, new ProgressHelper(downloadServiceListener), true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeExtensionPart(URL uRL, String string, String string2) throws IOException {
        this.removeExtensionPart(uRL, string, new String[]{string2});
    }

    public boolean isExtensionPartCached(URL uRL, String string, String string2) {
        return this.isExtensionPartCached(uRL, string, new String[]{string2});
    }

    public void removeExtensionPart(final URL uRL, final String string, final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public boolean isExtensionPartCached(final URL uRL, final String string, final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public void loadResource(final URL uRL, final String string, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isResourceCached(uRL, string)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        JNLPClassLoader.getInstance().downloadResource(uRL, string, new ProgressHelper(downloadServiceListener), true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void loadExtensionPart(URL uRL, String string, String string2, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadExtensionPart(uRL, string, new String[]{string2}, downloadServiceListener);
    }

    public void loadExtensionPart(final URL uRL, final String string, final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        JNLPClassLoader.getInstance().downloadExtensionParts(uRL, string, stringArray, new ProgressHelper(downloadServiceListener), true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private class DefaultProgressImpl
    implements DownloadServiceListener {
        private DownloadWindow _dw = null;

        private void ensureVisible() {
            if (!this._dw.getFrame().isVisible()) {
                this._dw.getFrame().setVisible(true);
                this._dw.getFrame().toFront();
            }
        }

        private synchronized void hideFrame() {
            this._dw.resetCancled();
            this._dw.getFrame().hide();
        }

        DefaultProgressImpl(DownloadWindow downloadWindow) {
            AccessController.doPrivileged(new PrivilegedAction(this, downloadWindow){
                private final /* synthetic */ DownloadWindow val$dw;
                private final /* synthetic */ DefaultProgressImpl this$1;

                public Object run() {
                    DefaultProgressImpl.access$002(this.this$1, this.val$dw);
                    DefaultProgressImpl.access$000(this.this$1).buildIntroScreen();
                    DefaultProgressImpl.access$000(this.this$1).showLoadingProgressScreen();
                    return null;
                }
                {
                    this.this$1 = defaultProgressImpl;
                    this.val$dw = downloadWindow;
                }
            });
        }

        static /* synthetic */ DownloadWindow access$000(DefaultProgressImpl defaultProgressImpl) {
            return defaultProgressImpl._dw;
        }

        public void downloadFailed(URL uRL, String string) {
            this.hideFrame();
        }

        public void upgradingArchive(URL uRL, String string, int n, int n2) {
            this.ensureVisible();
            this._dw.patching(uRL, string, n, n2);
            if (n2 >= 100) {
                this.hideFrame();
            }
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            if (l == 0L) {
                this._dw.resetDownloadTimer();
            }
            this._dw.progress(uRL, string, l, l2, n);
            if (n >= 100) {
                this.hideFrame();
            }
            if (this._dw.isCanceled()) {
                this.hideFrame();
                throw new RuntimeException("canceled by user");
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            this._dw.validating(uRL, string, l, l2, n);
            if (l >= l2 && (n < 0 || n >= 99)) {
                this.hideFrame();
            }
        }

        static /* synthetic */ DownloadWindow access$002(DefaultProgressImpl defaultProgressImpl, DownloadWindow downloadWindow) {
            defaultProgressImpl._dw = downloadWindow;
            return defaultProgressImpl._dw;
        }
    }

    private class ProgressHelper
    implements LaunchDownload.DownloadProgress {
        DownloadServiceListener _dsp = null;

        public void extensionDownload(String string, int n) {
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._dsp != null) {
                this._dsp.downloadFailed(uRL, string);
            }
        }

        public void patching(URL uRL, String string, int n, int n2) {
            if (this._dsp != null) {
                this._dsp.upgradingArchive(uRL, string, n, n2);
            }
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            if (this._dsp != null) {
                this._dsp.progress(uRL, string, l, l2, n);
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            if (this._dsp != null) {
                this._dsp.validating(uRL, string, l, l2, n);
            }
        }

        public void jreDownload(String string, URL uRL) {
        }

        public ProgressHelper(DownloadServiceListener downloadServiceListener) {
            this._dsp = downloadServiceListener;
            this._dsp.progress(null, null, 0L, 0L, -1);
        }
    }
}

