/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <qdialog.h>
#include <qwidget.h>
#include <qwidgetfactory.h>

#include <kdebug.h>

#include <kjs/interpreter.h>
#include <kjs/ustring.h>
#include <kjs/types.h>

#include "jsobjectproxy.h"

#include "dialogfactory.h"

namespace KJSEmbed {

QWidget *DialogFactory::create( const QString &uiFile, QObject *connector,
				QWidget *parent, const char *name )
{
    return QWidgetFactory::create( uiFile, connector, parent, name );
}

QWidget *DialogFactory::show( const QString &uiFile, QObject *connector,
			      QWidget *parent, const char *name )
{
    QWidget *w = QWidgetFactory::create( uiFile, connector, parent, name );
    if ( !w ) {
	kdDebug() << "DialogFactory could not show '" << uiFile << "'" << endl;
	return 0;
    }

    w->show();
    return w;
}

QDialog *DialogFactory::execDialog( const QString &uiFile, QObject *connector,
				    QWidget *parent, const char *name )
{
    QWidget *w = QWidgetFactory::create( uiFile, connector, parent, name );
    if ( !w ) {
	kdDebug() << "DialogFactory could not execDialog '" << uiFile << "'" << endl;
	return 0;
    }

    if ( !w->isDialog() ) {
	kdDebug() << "DialogFactory exec '" << uiFile << "' did not find a QDialog" << endl;
	delete w;
	return 0;
    }

    QDialog *dlg = static_cast<QDialog *>( w );
    dlg->exec();
    return dlg;
}

//
// JS Bindings
//

void DialogFactory::addBindings( KJS::ExecState *state, KJS::Object &object )
{
    object.put( state ,"exec", KJS::Object( new MethodImp( MethodImp::MethodExec ) ) );
    object.put( state ,"show", KJS::Object( new MethodImp( MethodImp::MethodShow ) ) );
}

DialogFactory::MethodImp::MethodImp( MethodId mid ) : ObjectImp(), id(mid) {}
DialogFactory::MethodImp::~MethodImp() {}

KJS::Value DialogFactory::MethodImp::call( KJS::ExecState *state,
					   KJS::Object &self, const KJS::List &args )
{
    kdDebug() << "DlgFact::MethodImp " << (int) id << " called" << endl;

    QString qs = args[0].toString(state).qstring();

    if ( id == MethodExec ) {
	QDialog *dlg = DialogFactory::execDialog( qs );
	return KJS::Object ( new JSObjectProxy( state->interpreter(), dlg ) );
    }
    else if ( id == MethodShow ) {
	QWidget *w = DialogFactory::show( qs );
	return KJS::Object( new JSObjectProxy( state->interpreter(), w ) );
    }

    kdDebug() << "DlgFact::MethodImp has no such impl" << endl;

    return ObjectImp::call( state, self, args );
}

}; // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:
