/***************************************************************************
                            KSessionManaged.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSESSIONMANAGED_H
#define KSESSIONMANAGED_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

   Provides highlevel access to session management on a per-object
   base.

   KSessionManaged makes it possible to provide implementations for
   @ref -[QApplication commitData] and @ref -[QApplication saveState], without
   subclassing KApplication. KMainWindow internally makes use of this.

   You don't need to do anything with this class when using
   KMainWindow. Instead, use @ref -[KMainWindow saveProperties],
   @ref -[KMainWindow readProperties], @ref -[KMainWindow queryClose],
   @ref -[KMainWindow queryExit] and friends.

 @author Matthias Ettrich <ettrich@kde.org>
 
 @short Highlevel access to session management.

*/
@class QSessionManager; 

@interface  KSessionManaged : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- (void) dealloc;

/** 
       See @ref -[QApplication saveState] for documentation.

       This function is just a convenience version to avoid subclassing KApplication.

       Return true to indicate a successful state save or false to
       indicate a problem and to halt the shutdown process (will
       implicitly call sm.-cancel ).
     
*/
- (BOOL) saveState: (QSessionManager*)sm;

/** 
       See @ref -[QApplication commitData] for documentation.

       This function is just a convenience version to avoid subclassing KApplication.

       Return true to indicate a successful commit of data or false to
       indicate a problem and to halt the shutdown process (will
       implicitly call sm.-cancel ).
     
*/
- (BOOL) commitData: (QSessionManager*)sm;
@end

#endif
