/***************************************************************************
                            KPopupFrame.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPOPUPFRAME_H
#define KPOPUPFRAME_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

/**

 Frame with popup menu behaviour.

 @author Tim Gilman, Mirko Boehm

 @version $Id: KPopupFrame.h,v 1.3 2002/03/15 02:12:21 rdale Exp $

 @short 
 Frame with popup menu behaviour.
*/
@interface KPopupFrame : QFrame 

/**  The contructor. Creates a dialog without buttons. 
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/**  Set the main widget. You cannot set the main widget from the constructor,
      since it must be a child of the frame itselfes.
      Be careful: the size is set to the main widgets size. It is up to you to
      set the main widgets correct size before setting it as the main
      widget. 
*/
- setMainWidget: (QWidget *)m;

/**  The resize event. Simply resizes the main widget to the whole
      widgets client size. 
*/
//- resizeEvent: (QResizeEvent*)arg1;

/**  Open the popup window at position pos. 
*/
- popup: (QPoint*)pos;

/**  Execute the popup window. 
*/
- (int) exec: (QPoint*)p;

/**  Dito. 
*/
- (int) exec: (int)x y: (int)y;

/**  Close the popup window. This is called from the main widget, usually.
      r is the result returned from -exec. 
*/
- close: (int)r;
@end

/** Override these methods in subclasses of KPopupFrame to customise event handling behaviour */
@protocol KPopupFrameEventHandling

/**  Catch key press events. 
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
