/***************************************************************************
                            KFontCombo.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A combobox that lists the available fonts.

 The items are painted using the respective font itself, so the user
 can easily choose a font based on its look. This can be turned off
 globally if the user wishes so.

 See {@link KFontComboSignals} for signals emitted by KFontCombo.

 

 @author Malte Starostik <malte@kde.org>

 @version $Id: KFontCombo.java,v 1.6 2002/11/26 04:17:32 rdale Exp $
 
 @short A combobox to choose a font.
*/
public class KFontCombo extends KComboBox  {
	protected KFontCombo(Class dummy){super((Class) null);}

	private native void newKFontCombo( QWidget parent, String name);

/** 
 Constructor

*/
	public KFontCombo( QWidget parent, String name) {
		super((Class) null);
		newKFontCombo( parent, name);
	}
	private native void newKFontCombo( QWidget parent);
	public KFontCombo( QWidget parent) {
		super((Class) null);
		newKFontCombo( parent);
	}
	private native void newKFontCombo( String[] fonts, QWidget parent, String name);

/** 
 Constructor that takes an already initialzed font list

*/
	public KFontCombo( String[] fonts, QWidget parent, String name) {
		super((Class) null);
		newKFontCombo( fonts, parent, name);
	}
	private native void newKFontCombo( String[] fonts, QWidget parent);
	public KFontCombo( String[] fonts, QWidget parent) {
		super((Class) null);
		newKFontCombo( fonts, parent);
	}

/** 
 Destructor
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the font list.

*/
	public native void setFonts( String[] fonts);

/** 
 Sets the currently selected font.

*/
	public native void setCurrentFont( String family);

/** 

*/
	public native String currentFont();

/** 
 Sets the listed fonts to bold or normal.

*/
	public native void setBold( boolean bold);

/** 
 Returns the current bold status.

*/
	public native boolean bold();

/** 
 Sets the listed fonts to italic or regular.

*/
	public native void setItalic( boolean bold);

/** 
 Returns the current italic status

*/
	public native boolean italic();

/** 
 Sets the listed fonts to underlined or not underlined

*/
	public native void setUnderline( boolean bold);

/** 
 Returns the current underline status

*/
	public native boolean underline();

/** 
 Sets the listed fonts to striked out or not

*/
	public native void setStrikeOut( boolean bold);

/** 
 Returns the current strike out status

*/
	public native boolean strikeOut();

/** 
 Sets the listed fonts' size

*/
	public native void setSize( int size);

/** 
 Returns the current font size

*/
	public native int fontSize();
	public native void setCurrentItem( int i);

/** 
 Returns the user's setting of whether the items should be painted
 in the respective fonts or not

*/
	public static native boolean displayFonts();

/** 
 Updated the combo's {@link #listBox} to reflect changes made to the
 fonts' attributed
     
*/
	protected native void updateFonts();
	protected native void virtual_hook( int identifier, int data);
}
