/***************************************************************************
                            HTMLFormElement.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The <code> FORM </code> element encompasses behavior similar to a
 collection and an element. It provides direct access to the
 contained input elements as well as the attributes of the form
 element. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-FORM">
 FORM element definition </a> in HTML 4.0.

 
 @short *
 The <code> FORM </code> element encompasses behavior similar to a
 collection and an element.
*/
public class HTMLFormElement extends HTMLElement  {
	protected HTMLFormElement(Class dummy){super((Class) null);}

	private native void newHTMLFormElement();
	public HTMLFormElement() {
		super((Class) null);
		newHTMLFormElement();
	}
	private native void newHTMLFormElement( HTMLFormElement other);
	public HTMLFormElement( HTMLFormElement other) {
		super((Class) null);
		newHTMLFormElement( other);
	}
	private native void newHTMLFormElement( DOMNode other);
	public HTMLFormElement( DOMNode other) {
		super((Class) null);
		newHTMLFormElement( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns a collection of all control elements in the form.

     
*/
	public native HTMLCollection elements();

/** 
 The number of form controls in the form.

     
*/
	public native long length();

/** 
 Names the form.

     
*/
	public native String name();

/** 
 see {@link name}
     
*/
	public native void setName( String arg1);

/** 
 List of character sets supported by the server. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accept-charset">
 accept-charset attribute definition </a> in HTML 4.0.

     
*/
	public native String acceptCharset();

/** 
 see {@link acceptCharset}
     
*/
	public native void setAcceptCharset( String arg1);

/** 
 Server-side form handler. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-action">
 action attribute definition </a> in HTML 4.0.

     
*/
	public native String action();

/** 
 see {@link action}
     
*/
	public native void setAction( String arg1);

/** 
 The content type of the submitted form, generally
 "application/x-www-form-urlencoded". See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-enctype">
 enctype attribute definition </a> in HTML 4.0.

     
*/
	public native String enctype();

/** 
 see {@link enctype}
     
*/
	public native void setEnctype( String arg1);

/** 
 HTTP method used to submit form. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-method">
 method attribute definition </a> in HTML 4.0.

     
*/
	public native String method();

/** 
 see {@link method}
     
*/
	public native void setMethod( String arg1);

/** 
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">
 target attribute definition </a> in HTML 4.0.

     
*/
	public native String target();

/** 
 see {@link target}
     
*/
	public native void setTarget( String arg1);

/** 
 Submits the form. It performs the same action as a submit
 button.

     
*/
	public native void submit();

/** 
 Restores a form element's default values. It performs the same
 action as a reset button.

     
*/
	public native void reset();
}
