//////////////////////////////////////////////////////////////         
//      $Id: kplview.h,v 1.5 2000/06/11 15:18:15 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#ifndef KPLVITEM_H
#define KPLVITEM_H

#include "../config.h"
// Standard Headers

// Qt Headers
#include <qframe.h>
#include <qpushbt.h>
#include <qlist.h>
#include <qstring.h>
#include <qlayout.h>

// KDE headers
#include "klistview.h"

// ksetup headers
#include "packageInfo.h"

////////////////////////////////////////////////////////////////////////
class KPLVItem : public QListViewItem
{
public:
KPLVItem( QListViewItem *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  QString label1 = 0, QString label2  = 0,
                  QString label3  = 0, QString label4  = 0,
                  QString label5  = 0, QString label6  = 0,
                  QString label7  = 0, QString label8 = 0);
 
 
KPLVItem( KListView *parent, packageInfo* pinfo,
                  const QPixmap& thePixmap,
                  QString label1 = 0, QString label2  = 0,
                  QString label3  = 0, QString label4  = 0,
                  QString label5  = 0, QString label6  = 0,
                  QString label7  = 0, QString label8 = 0);
 

KPLVItem *firstChild();
KPLVItem *nextSibling();

void toggleMark();
void setMark(bool mark);
// flag for install/uninstall

void hide();
void show();

packageInfo *info;
bool marked;
};

////////////////////////////////////////////////////////////////////////
class KPQListView: public KListView
{
public:
KPQListView ( QWidget * parent = 0);

void contentsMousePressEvent ( QMouseEvent * e );

bool inMark(int x);

KPLVItem *firstChild();
KPLVItem *currentItem();
void clear();

KPLVItem *markPkg;
};

#endif
