/***************************************************************************
                          reportview.cpp  -  description
                             -------------------
    begin                : Sun Oct 15 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qvbox.h>
#include <qpixmap.h>
#include <kdebug.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <khtml_part.h>
#include <kglobalsettings.h>

#include "reportview.h"

reportView::reportView(QString reportLocation)
		: KDialogBase( 0, "report", false, "", Close ) {
	locationCode = reportLocation;
    QVBox *layout = makeVBoxMainWidget();
    theReport = new KHTMLPart(layout, "Form1");
    setCaption(i18n("Weather Report - KWeather"));
    resize(450, 300);
    centerOnScreen( this );
}

reportView::~reportView(){
}

/** Render the document */
void reportView::render(){
    QFont generalFont = KGlobalSettings::generalFont();
    QString fntFamily = generalFont.family();
    int fntSize = generalFont.pointSize();
    QString textColor = KGlobalSettings::textColor().name();
    QString baseColor = KGlobalSettings::baseColor().name();
    QColorGroup cg = palette().active();
    QString bgColor = cg.background().name();
    QString hlColor = cg.highlight().name();
    QString hlTextColor = cg.highlightedText().name();

    QString weatherText = "<ul>\n";

    for (QStringList::const_iterator it = currentCover.begin(); 
            it != currentCover.end(); ++it)
        weatherText += "<li>" + *it + "\n";

    for (QStringList::const_iterator it = currentWeather.begin(); 
            it != currentWeather.end(); ++it)
        weatherText += "<li>" + *it + "\n";

    weatherText += "</ul>\n";

    QString contents =
    "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\""
    " \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"
    "<html><head><style type=\"text/css\">" +
    QString("body { font-family: \"%1\"; font-size: %2pt; color: %3; background-color: %4; }\n")
    .arg(fntFamily).arg(fntSize).arg(textColor).arg(baseColor) +
    QString("div.headerTitle { background-color: %1; color: %2; padding: 4px; font-size: 120%; border: solid %3 1px; }\n")
    .arg(hlColor).arg(hlTextColor).arg(textColor) +
    QString("div.headerMsg { background-color: %1; color: %2; border-bottom: solid %3 1px; "
    "border-left: solid %4 1px; border-right: solid %5 1px; margin-bottom: 1em; padding: 2px; }\n")
    .arg(bgColor).arg(textColor).arg(textColor).arg(textColor).arg(textColor) +
    "</style><title></title></head><body>"
    "<div class=\"headerTitle\"><b>" + i18n( "Weather Report - " )+ locationCode + "</b></div>\n" +
    QString("<div class=\"headerMsg\"><b>" + i18n( "Last updated on %1" ) + "</b></div>\n"
    "<table><tr><td width=\"60\" style=\"text-align: center; border: dotted %2 1px;\">"
    "<img width=\"48\" height=\"48\" src=\"%3\" /></td>"
    "<td style=\"vertical-align: top\">%4</td></tr>")
    .arg(currentDate).arg(bgColor).arg(KURL(currentIcon).url()).arg(weatherText) +
    "</table><br><table>" +
    QString("<tr><th style=\"text-align: right\">" + i18n( "Temperature:" ) + "</th><td>%1</td>"
    "<td width=\"50\">&nbsp;</td>"
    "<th style=\"text-align: right\">" + i18n( "Dew Point:" ) + "</th><td>%2</td></tr>"
    "<tr><th style=\"text-align: right\">" + i18n( "Air Pressure:" ) + "</th><td>%3</td>"
    "<td width=\"50\">&nbsp;</td>"
    "<th style=\"text-align: right\">" + i18n( "Rel. Humidity:" ) + "</th><td>%4</td></tr>"
    "<tr><th style=\"text-align: right\">" + i18n( "Wind Speed:" ) + "</th><td>%5</td>")
    .arg(currentTemp).arg(currentDewPoint).arg(currentPressure)
	.arg(currentRelHumidity).arg(currentWind) + "<td width=\"50\">&nbsp;</td>";
    if (!currentHeatIndex.isEmpty())
        contents += QString("<th style=\"text-align: right\">" + i18n( "Heat Index:" ) +
        "</th><td>%1</td>").arg(currentHeatIndex);
    else if (!currentWindChill.isEmpty())
        contents += QString("<th style=\"text-align: right\">" + i18n( "Wind Chill:" ) +
        "</th><td>%1</td>").arg(currentWindChill);
    else
        contents += "<td>&nbsp;</td><td>&nbsp;</td>";
    contents += "</tr></table></body></html>";

    theReport->begin();
    theReport->write( contents );
    theReport->end();
}

void reportView::setLocation( QString location)
{
    locationCode = location;
}

void reportView::setTemp( QString temp){
    currentTemp = temp;
}

void reportView::setDewPoint( QString dewpoint ){
    currentDewPoint = dewpoint;
}

void reportView::setRelHumidity( QString relhumidity ){
    currentRelHumidity = relhumidity;
}

void reportView::setHeatIndex( QString heatindex ){
    currentHeatIndex = heatindex;
}

void reportView::setWindChill( QString windchill ){
    currentWindChill = windchill;
}

void reportView::setWind( QString wind){
    currentWind = wind;
}

void reportView::setPressure( QString pressure ){
    currentPressure = pressure;
}

void reportView::setDate( QString date ){
    currentDate = date;
}

void reportView::setCover(QStringList cover){
    currentCover = cover;
}

void reportView::setWeather(QStringList weather){
    currentWeather = weather;
}

void reportView::setWeatherIcon( const QString  &icon ){
	QString theImage = "kweather/" + icon + ".png";
	currentIcon = locate("data", theImage);
    setIcon( currentIcon );
}

/* vim: et sw=4 ts=4
*/

#include "reportview.moc"
