/*  This file is part of the KDE project
    Copyright (C) 2002 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* $Id: kviewpresenter.h,v 1.12 2002/08/05 16:16:28 mkretz Exp $ */

#ifndef __kviewpresenter_h
#define __kviewpresenter_h

#include <kparts/plugin.h>
#include <kurl.h>

#include <qsortedlist.h>

namespace KImageViewer { class Viewer; }

class ImageListDialog;
class QListViewItem;
class QTimer;
class KToggleAction;
class KAction;

class KViewPresenter : public KParts::Plugin
{
	Q_OBJECT
public:
	KViewPresenter( QObject* parent, const char* name, const QStringList & );
	virtual ~KViewPresenter();

protected:
	struct ImageInfo
	{
		KURL url;
		ImageInfo( const KURL & url )
			: url( url )
		{
		}
		bool operator==( const ImageInfo & i1 )
		{
			return url.prettyURL() == i1.url.prettyURL();
		}
		bool operator!=( const ImageInfo & i1 )
		{
			return url.prettyURL() == i1.url.prettyURL();
		}
		bool operator>( const ImageInfo & i1 )
		{
			return url.prettyURL() > i1.url.prettyURL();
		}
		bool operator<( const ImageInfo & i1 )
		{
			return url.prettyURL() < i1.url.prettyURL();
		}
	};

private slots:
	void slotImageOpened( const KURL & );
	void slotImageList();
	void slotOpenFiles();
	void changeItem( QListViewItem * );
	void prev();
	void next();
	void slideshow( bool );
	void setSlideshowInterval( int );
	void shuffle();
	void closeAll();
	void loadList();
	void saveList();

private:
	void makeCurrent( QListViewItem * );

	KImageViewer::Viewer * m_pViewer;
	ImageListDialog * m_pImageList;
	KToggleAction * m_paSlideshow;
	KAction * m_paFileOpen;

	QSortedList<ImageInfo> m_imagelist;
	bool m_bDontAdd;
	QListViewItem * m_pCurrentItem;
	QTimer * m_pSlideshowTimer;
};

// vim:sw=4:ts=4:cindent
#endif
