/***************************************************************************
                           flashkard.h  -  description
                             -------------------
    begin                : Tue Feb 12 00:09:29 EST 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#ifndef FLASHKARD_H
#define FLASHKARD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <kaction.h>
#include <kstdaction.h>

#include <qwidget.h>
#include <qstring.h>

#include "datawidget.h"
#include "quizwidget.h"

class FlashKard : public KMainWindow
{
  Q_OBJECT

public:
  FlashKard(QWidget* parent = 0, const char *name = 0);
  ~FlashKard();

public slots:
  void dataChanged();
  void selectionChanged();

private:
  void setupActions();
  void setupLayout();
  void processArgs();
  void readConfig();
  void saveConfig();
  bool saveChangesPrompt();
  void dataCurrent();

  virtual bool queryClose();
  
  KAction *cutAction;
  KAction *copyAction;
  KAction *pasteAction;

  KAction *showDataAction;
  KAction *showQuizAction;

  KSelectAction *quizModeAction;
  KSelectAction *showAnswerLengthAction;
  KToggleAction *reverseFrontBackAction;
  
  DataWidget *data;
  QuizWidget *quiz;
  
  bool randomQuiz;
  bool changed;

  QString fileName;
  QString fileExtension;
  QString fileMask;

  KLineEdit *focusedLineEdit;

private slots:
  // file menu

  void fileNew();
  void fileOpen();
  void fileOpen(const QStringList &files);
  bool fileSave();
  bool fileSaveAs();
  void quit();

  // edit menu

  void cut();
  void copy();
  void paste();

  void enableCutCopy();
  void disableCutCopy();
  void enablePaste(KLineEdit *lineEdit);
  void disablePaste();

  // other private slots

  void showData();
  void showQuiz();

  void changeQuizMode(int id);
  void changeShowAnswerLength(int id);
};

#endif
