/***************************************************************************
                            KServiceGroup.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSERVICEGROUP_H
#define KSERVICEGROUP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KSycocaEntry.h>

/**

 This class is typically used like this: 

 // Lookup screensaver group
 -[KServiceGroup Ptr]group = -[KServiceGroup baseGroup]("screensavers");
 if (!group || !-[group isValid]) return;

 -[KServiceGroup List]list = -[group entries];

 // Iterate over all entries in the group
 for( -[KServiceGroup List]::ConstIterator it = list.-begin;
      it != list.-end; it++)
 {
    KSycocaEntry *p = (*it);
    if (-[p isType])
    {
       KService *s = static_cast<KService *>(p);
       printf("Name = %s\n", -[s name].-latin1);
    }
    else if (-[p isType])
    {
       KServiceGroup *g = static_cast<KServiceGroup *>(p);
       // Sub group ...
    }
 }
 
 @short 
 This class is typically used like this: 

*/
@class QDataStream;

@interface KServiceGroup : KSycocaEntry 

/** 
 Construct a service and take all informations from a config file

*/
- initWithText: (NSString *)_fullpath _relpath: (NSString *)_relpath;

/** 

 The stream must already be positionned at the correct offset
   
*/
- initWithDataStream: (QDataStream *)_str offset: (int)offset deep: (BOOL)deep;
- (void) dealloc;

/** 

*/
- (BOOL) isValid;

/** 
 Name used for indexing.
   
*/
- (NSString *) name;
- (NSString *) relPath;

/** 

*/
- (NSString *) caption;

/** 

*/
- (NSString *) icon;

/** 

*/
- (NSString *) comment;

/** 

*/
- (int) childCount;

/** 

 Load the service from a stream.
   
*/
- load: (QDataStream *)arg1;

/** 

 Save the service to a stream.
   
*/
- save: (QDataStream *)arg1;

/** 
 List of all Services and ServiceGroups within this
 ServiceGroup

*/
//- (List) entries: (BOOL)sorted excludeNoDisplay: (BOOL)excludeNoDisplay;

/** 
 As above with excludeNoDisplay true.
   
*/
//- (List) entries: (BOOL)sorted;
//- (List) entries;

/** 

 The base group is defined by the X-KDE-BaseGroup key
 in the .directory file.
   
*/
- (NSString *) baseGroupName;

/** 

*/
+ (void*) baseGroup: (NSString *)baseGroupName;
+ (void*) root;
+ (void*) group: (NSString *)relPath;

/** 

 Add a service to this group
   
*/
- addEntry: (KSycocaEntry*)entry;
@end

#endif
