/***************************************************************************
                            KRegExp.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KREGEXP_H
#define KREGEXP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Regular expression (regexp) matching with back-references. 

 This was implemented
 because @ref QRegExp does not support back-references.

 Back-references are parts of a regexp grouped with parentheses. If a
 string matches the regexp, you can access the text that matched each
 group with the @ref group method. This is similar to regular expressions in Perl.

 Example:
 <pre>
  KRegExp ex( "([A-Za-z]+) (.+)" );
  ex.match( "42 Torben Weis" );
  -kdDebug << ex.group(0) << endl;
  -kdDebug << ex.group(1) << endl;
  -kdDebug << ex.group(2) << endl;
 </pre>
 Output:
 <pre>
  Torben Weis
  Torben
  Weis
 </pre>

 Please notice that KRegExp does @em not support unicode.

 @author Torben Weis <weis@kde.org>

 @version $Id: KRegExp.h,v 1.3 2002/03/15 02:12:22 rdale Exp $
 
 @short 
 Regular expression (regexp) matching with back-references.
*/
@interface  KRegExp : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates a KRegExp object without a default pattern.
   
*/
- init;

/** 
 Creates a KRegExp object.

*/
- initWithText: (NSString *)_pattern _mode: (NSString *)_mode;
- initWithText: (NSString *)_pattern ;
- (void) dealloc;

/** 
 Prepare a regular expression for subsequent matches.

*/
- (BOOL) compile: (NSString *)_pattern _mode: (NSString *)_mode;
- (BOOL) compile: (NSString *)_pattern ;

/** 
 Match a string to the last supplied regexp.

*/
- (BOOL) match: (NSString *)_string;

/** 

*/
- (NSString *) group: (int)_grp;

/** 

*/
- (int) groupStart: (int)_grp;

/** 

*/
- (int) groupEnd: (int)_grp;
@end

#endif
