/***************************************************************************
                            KRecentFilesAction.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KRECENTFILESACTION_H
#define KRECENTFILESACTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KListAction.h>

/**

  This class is an action to handle a recent files submenu.
  The best way to create the action is to use -[KStdAction openRecent].
  Then you simply need to call @ref loadEntries on startup, @ref saveEntries
  on shutdown, @ref addURL when your application loads/saves a file.

 @author Michael Koch

 @short Recent files action.
*/
@class KConfig; 
@class KURL; 
@class QIconSet; 
@class parse; 

@class QKeySequence; 

@class KShortcut; 

@interface KRecentFilesAction : KListAction 

/** 

*/
- initWithText: (NSString *)text cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name maxItems: (unsigned int)maxItems;
- initWithText: (NSString *)text cut: (KShortcut*)cut parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name maxItems: (unsigned int)maxItems;
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name maxItems: (unsigned int)maxItems;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name maxItems: (unsigned int)maxItems;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name maxItems: (unsigned int)maxItems;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name maxItems: (unsigned int)maxItems;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithObject: (QObject *)parent name: (NSString *)name maxItems: (unsigned int)maxItems;
- init;

/** 
  Destructor.
   
*/
- (void) dealloc;

/** 
  Returns the maximum of items in the recent files list.
   
*/
- (unsigned int) maxItems;

/** 
  Sets the maximum of items in the recent files list.
  The default for this value is 10 set in the constructor.

  If this value is lesser than the number of items currently
  in the recent files list the last items are deleted until
  the number of items are equal to the new maximum.
   
*/
- setMaxItems: (unsigned int)maxItems;

/** 
  Loads the recent files entries from a given KConfig object.
  You can provide the name of the group used to load the entries.
  If the groupname is empty, entries are load from a group called 'RecentFiles'

  This method does not effect the active group of KConfig.
   
*/
- loadEntries: (KConfig*)config groupname: (NSString *)groupname;
- loadEntries: (KConfig*)config ;

/** 
  Saves the current recent files entries to a given KConfig object.
  You can provide the name of the group used to load the entries.
  If the groupname is empty, entries are saved to a group called 'RecentFiles'

  This method does not effect the active group of KConfig.
   
*/
- saveEntries: (KConfig*)config groupname: (NSString *)groupname;
- saveEntries: (KConfig*)config ;

/** 
  Add URL to recent files list.

*/
- addURL: (KURL*)url;

/** 
  Remove an URL from the recent files list.

*/
- removeURL: (KURL*)url;

/** 
  Removes all entries from the recent files list.
   
*/
- clearURLList;

/** 

   
*/
- itemSelected: (NSString *)string;
@end

/** Override these methods in subclasses of KRecentFilesAction to customise event handling behaviour */
@protocol KRecentFilesActionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
