/***************************************************************************
                            KFontDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFONTDIALOG_H
#define KFONTDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 The KFontDialog provides a dialog for interactive font selection.
 It is basically a thin wrapper around the @ref KFontChooser widget,
 which can also be used standalone. In most cases, the simplest
 use of this class is the static method @ref -[KFontDialog getFont],
 which pops up the dialog, allows the user to select a font, and
 returns when the dialog is closed.

 Example:

 <pre>
      QFont myFont;
      int result = -[KFontDialog getFont]( myFont );
      if ( result == -[KFontDialog Accepted])
            ...
 </pre>

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontDialog.h,v 1.3 2002/03/15 02:12:20 rdale Exp $
 
 @short A font selection dialog.

*/

@interface KFontDialog : KDialogBase 

/** 
 Constructs a font selection dialog.

   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name onlyFixed: (BOOL)onlyFixed modal: (BOOL)modal fontlist: (NSArray *)fontlist makeFrame: (BOOL)makeFrame diff: (BOOL)diff sizeIsRelativeState: (int*)sizeIsRelativeState;
- init;

/** 
 Sets the currently selected font in the dialog.

*/
- setFont: (QFont *)font onlyFixed: (BOOL)onlyFixed;
- setFont: (QFont *)font ;

/** 

*/
- (QFont*) font;

/** 
 Sets the state of the checkbox indicating whether the font size
 is to be interpreted as relative size.
 NOTE: If parameter sizeIsRelative was not set in the constructor
       of the dialog this setting will be ignored.
   
*/
- setSizeIsRelative: (int)relative;

/** 

*/
- (int) sizeIsRelative;

/** 
 Sets the currently selected charset in the dialog.
   
*/
//- setCharset: (NSString *)charset;

/** 

*/
//- (NSString *) charset;

/** 
 Creates a modal font dialog, lets the user choose a font,
 and returns when the dialog is closed.

*/
+ (int) getFont: (QFont *)theFont onlyFixed: (BOOL)onlyFixed parent: (QWidget *)parent makeFrame: (BOOL)makeFrame sizeIsRelativeState: (int*)sizeIsRelativeState;
+ (int) getFont: (QFont *)theFont ;

/** 
 Creates a modal font difference dialog, lets the user choose a selection
 of changes that should be made to a set of fonts, and returns when the
 dialog is closed. Useful for choosing slight adjustments to the font set
 when the user would otherwise have to manually edit a number of fonts.

*/
+ (int) getFontDiff: (QFont *)theFont diffFlags: (int)diffFlags onlyFixed: (BOOL)onlyFixed parent: (QWidget *)parent makeFrame: (BOOL)makeFrame sizeIsRelativeState: (int*)sizeIsRelativeState;
+ (int) getFontDiff: (QFont *)theFont diffFlags: (int)diffFlags ;

/** 
 When you are not only interested in the font selected, but also
 in the example string typed in, you can call this method.

*/
+ (int) getFontAndText: (QFont *)theFont theString: (NSString *)theString onlyFixed: (BOOL)onlyFixed parent: (QWidget *)parent makeFrame: (BOOL)makeFrame sizeIsRelativeState: (int*)sizeIsRelativeState;
+ (int) getFontAndText: (QFont *)theFont theString: (NSString *)theString ;
@end

/** Override these methods in subclasses of KFontDialog to customise event handling behaviour */
@protocol KFontDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
