/***************************************************************************
                            HTMLMetaElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLMETAELEMENT_H
#define HTMLMETAELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 This contains generic meta-information about the document. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html edef]-META">
 META element definition </a> in HTML 4.0.

 
 @short 
 This contains generic meta-information about the document.
*/

@interface HTMLMetaElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Associated information. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-content">
 content attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) content;

/** 
 see @ref content
     
*/
- setContent: (NSString *)arg1;

/** 
 HTTP response header name. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-http-equiv">
 http-equiv attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) httpEquiv;

/** 
 see @ref httpEquiv
     
*/
- setHttpEquiv: (NSString *)arg1;

/** 
 Meta information name. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-name-META">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Select form of content. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-scheme">
 scheme attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) scheme;

/** 
 see @ref scheme
     
*/
- setScheme: (NSString *)arg1;
@end

#endif
