/***************************************************************************
                            KURIFilterData.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a basic message object used for exchanging filtering
 information between the filter plugins and the application
 whenever the application requires more information about the
 URI than just a filtered version of it.  Any application can
 create an instance of this class and send it to {@link KURIFilter}
 to have the filter plugins fill the necessary information.

 The above code should yield the following output:
 <pre>
   URI: kde.org
   Filtered URI: http://kde.org
   URI Type: 0            <== means NET_PROTOCOL
   Was Filtered: 1        <== means the URL was successfully filtered
 </pre>

 @short A message object for exchanging filtering URI info.

*/
public class  KURIFilterData implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KURIFilterData(Class dummy){}

	private native void newKURIFilterData();

/** 
 Default constructor.

 Creates a URIFilterData object.
     
*/
	public KURIFilterData() {
		newKURIFilterData();
	}
	private native void newKURIFilterData( KURL url);

/** 
 Creates a URIFilterData object from the given URL.

*/
	public KURIFilterData( KURL url) {
		newKURIFilterData( url);
	}
	private native void newKURIFilterData( String url);

/** 
 Creates a URIFilterData object from the given string.

*/
	public KURIFilterData( String url) {
		newKURIFilterData( url);
	}
	private native void newKURIFilterData( KURIFilterData arg1);

/** 
 Copy constructor.

 Creates a URIFilterData object from another
 URI filter data object.

*/
	public KURIFilterData( KURIFilterData arg1) {
		newKURIFilterData( arg1);
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 This method has been deprecated and will always return
 TRUE.  You should instead use the result from the
 {@link KURIFilter#filterURI} calls.

     
*/
	public native boolean hasBeenFiltered();

/** 
 Returns the filtered or the original URL.

 This function returns the filtered url if one
 of the plugins sucessfully filtered the original
 URL.  Otherwise, it returns the original URL.
 See {@link #hasBeenFiltered} and

*/
	public native KURL uri();

/** 
 Returns an error message.

 This functions returns the error message set
 by the plugin whenever the uri type is set to
 KURIFilterData.ERROR.  Otherwise, it returns
 a String.null.

*/
	public native String errorMsg();

/** 
 Returns the URI type.

 This method always returns KURIFilterData.UNKNOWN
 if the given URL was not filtered.
     
*/
	public native int uriType();

/** 
 Sets the URL to be filtered.

 Use this function to set the string to be
 filtered when you construct an empty filter
 object.

*/
	public native void setData( String url);

/** 
 Same as above except the argument is a URL.

 Use this function to set the string to be
 filtered when you construct an empty filter
 object.

*/
	public native void setData( KURL url);

/** 
 Sets the absolute path to be used whenever the supplied
 data is a relative local URL.

 NOTE: This function works only for a local resource and
 expects the absolute path to the relative URL set in this
 meta object.  If you are extracting the absolute path from
 a KURL object, make sure you always set the argument below
 using KURL.path() instead of KURL.url() so that "file:/"
 would not be appended! Otherwise, the filter might not be
 able to make correct determination whether the relative URL
 locally exists!

*/
	public native boolean setAbsolutePath( String arg1);

/** 
 Returns the absolute path if one has already been set.
     
*/
	public native String absolutePath();

/** 
 Returns true if the supplied data has an absolute path.
     
*/
	public native boolean hasAbsolutePath();

/** 
 Returns the command line options and arguments for a
 local resource when present.

*/
	public native String argsAndOptions();

/** 
 Returns true if the current data is a local resource with
 command line options and arguments.
     
*/
	public native boolean hasArgsAndOptions();

/** 
 Returns the name of the icon that matches
 the current filtered URL.

 NOTE that this function will return a NULL
 string by default and when no associated icon
 is found.

*/
	public native String iconName();

/** 
 Initializes the KURIFilterData on construction.
     
*/
	protected native void init( KURL url);
	protected native void init();
	public static final int NET_PROTOCOL = 0;
	public static final int LOCAL_FILE = 0;
	public static final int LOCAL_DIR = 1;
	public static final int EXECUTABLE = 2;
	public static final int HELP = 3;
	public static final int SHELL = 4;
	public static final int BLOCKED = 5;
	public static final int ERROR = 6;
	public static final int UNKNOWN = 7;
}
