/***************************************************************************
                            KInstance.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Access to KDE global objects for use in shared libraries.  In
 practical terms, this class is used in KDE components.  This allows
 components to store things that normally would be accessed by
 {@link KGlobal}.

 @author Torben Weis

 @version $Id: KInstance.java,v 1.7 2002/11/26 04:17:33 rdale Exp $
 
 @short *
 Access to KDE global objects for use in shared libraries.
*/
public class  KInstance implements QtSupport, KInstanceInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KInstance(Class dummy){}

	private native void newKInstance( String instanceName);

/** 
  Constructor.

*/
	public KInstance( String instanceName) {
		newKInstance( instanceName);
	}
	private native void newKInstance( KAboutData aboutData);

/** 
  Constructor.
  When building a KInstance that is not your KApplication,
  make sure that the KAboutData and the KInstance have the same life time.
  You have to destroy both, since the instance doesn't own the about data.
  Don't build a KAboutData on the stack in this case !
  Building a KAboutData on the stack is only ok for usage with
  KCmdLineArgs and KApplication (not destroyed until the app exits).

*/
	public KInstance( KAboutData aboutData) {
		newKInstance( aboutData);
	}
	private native void newKInstance( KInstanceInterface src);
	public KInstance( KInstanceInterface src) {
		newKInstance( src);
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the application standard dirs object.

*/
	public native KStandardDirs dirs();

/** 
 Returns the general config object ("appnamerc").

*/
	public native KConfig config();

/** 
  Returns an iconloader object.

*/
	public native KIconLoader iconLoader();

/** 
 Re-allocate the global iconloader.
     
*/
	public native void newIconLoader();
	public native KCharsets charsets();

/** 
  Returns the about data of this instance
  Warning, can be null

*/
	public native KAboutData aboutData();

/** 
 Returns the name of the instance

*/
	public native String instanceName();

/** 
 Returns the {@link KMimeSourceFactory} of the instance.
 Mainly added for API completeness and future extensibility.

*/
//	public native KMimeSourceFactory mimeSourceFactory();
//	private native void newKInstance( KInstanceInterface arg1);

/** 
  Copy Constructor is not allowed
     
*/
//	public KInstance( KInstanceInterface arg1) {
//		newKInstance( arg1);
//	}

/** 
 Set name of default config file.

*/
	protected native void setConfigName( String name);
	protected native void virtual_hook( int identifier, int data);
}
