/***************************************************************************
                            KIO.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class  KIO implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KIO(Class dummy){}


/** 
 Creates a job that changes permissions/ownership on several files or directories,
 optionally recursively.
 This version of chmod uses a KFileItemList so that it directly knows
 what to do with the items. TODO: a version that takes a KURL.List,
 and a general job that stats each url and returns a KFileItemList.

 Note that change of ownership is only supported for local files.

 Inside directories, the "x" bits will only be changed for files that had
 at least one "x" bit before, and for directories.
 This emulates the behaviour of chmod +X.

*/
//	public static native ChmodJob chmod( ArrayList lstItems, int permissions, int mask, String newOwner, String newGroup, boolean recursive, boolean showProgressInfo);
//	public static native ChmodJob chmod( ArrayList lstItems, int permissions, int mask, String newOwner, String newGroup, boolean recursive);
//	public static native DavJob* davPropFind( KURL url, QDomDocument properties, String depth, boolean showProgressInfo);
//	public static native DavJob* davPropFind( KURL url, QDomDocument properties, String depth);
//	public static native DavJob* davPropPatch( KURL url, QDomDocument properties, boolean showProgressInfo);
//	public static native DavJob* davPropPatch( KURL url, QDomDocument properties);
//	public static native DavJob* davSearch( KURL url, String nsURI, String qName, String query, boolean showProgressInfo);
//	public static native DavJob* davSearch( KURL url, String nsURI, String qName, String query);

/**
 Converts <code>size</code> from bytes to the string representation.

*/
	public static native String convertSize( int size);

/**
 Converts a size to a string representation
 Not unlike String.number(...)

*/
	public static native String number( int size);

/**
 Converts size from kilo-bytes to the string representation.

*/
	public static native String convertSizeFromKB( int kbSize);

/**
 Calculates remaining time from total size, processed size and speed.

*/
	public static native Date calculateRemaining( int totalSize, int processedSize, int speed);

/**
 Helper for showing information about a set of files and directories
 <code>items</code> = <code>files</code> + <code>dirs</code> + number of symlinks :)

*/
	public static native String itemsSummaryString( int items, int files, int dirs, int size, boolean showSize);

/**
 Encodes (from the text displayed to the real filename)
 This translates % into %% and / into %2f
 Used by KIO.link, for instance.

*/
	public static native String encodeFileName( String str);

/**
 Decodes (from the filename to the text displayed)
 This translates %2[fF] into / and %% into %

*/
	public static native String decodeFileName( String str);
	public static native String buildErrorString( int errorCode, String errorText);
	public static native String buildHTMLErrorString( int errorCode, String errorText, KURL reqUrl, int method);
	public static native String buildHTMLErrorString( int errorCode, String errorText);
	public static native byte[] rawErrorDetail( int errorCode, String errorText, KURL reqUrl, int method);
	public static native int parseCacheControl( String cacheControl);
	public static native String getCacheControlString( int cacheControl);

/**
 Returns the mount point where <code>device</code> is mounted
 right now. This means, it has to be mounted, not just
 defined in fstab.

*/
	public static native String findDeviceMountPoint( String device);

/**
 Returns the mount point on which resides <code>filename.</code>
 For instance if /home is a separate partition, findPathMountPoint("/home/user/blah")
 will return /home

*/
	public static native String findPathMountPoint( String filename);

/**
 checks if the path belongs to a file system that is probably
 slow. It checks for NFS or for paths belonging to automounted
 paths not yet mounted

*/
	public static native boolean probably_slow_mounted( String filename);

/**
 Creates a single directory.

*/
	public static native SimpleJob mkdir( KURL url, int permissions);
	public static native SimpleJob mkdir( KURL url);

/**
 Removes a single directory.

 The directory is assumed to be empty.

*/
	public static native SimpleJob rmdir( KURL url);

/**
 Changes permissions on a file or directory.
 See the other {@link #chmod} below for changing many files
 or directories.

*/
	public static native SimpleJob chmod( KURL url, int permissions);

/**
 Rename a file or directory.
 Warning: this operation fails if a direct renaming is not
 possible (like with files or dirs on separate partitions)
 Use move or file_move in this case.

*/
	public static native SimpleJob rename( KURL src, KURL dest, boolean overwrite);

/**
 Create or move a symlink.
 This is the lowlevel operation, similar to file_copy and file_move.
 It doesn't do any check (other than those the slave does)
 and it doesn't show rename and skip dialogs - use KIO.link for that.

*/
	public static native SimpleJob symlink( String target, KURL dest, boolean overwrite, boolean showProgressInfo);
	public static native SimpleJob symlink( String target, KURL dest, boolean overwrite);

/**
 Execute any command that is specific to one slave (protocol).

 Examples are : HTTP POST, mount and unmount (kio_file)

*/
	public static native SimpleJob special( KURL url, byte[] data, boolean showProgressInfo);
	public static native SimpleJob special( KURL url, byte[] data);

/**
 Mount filesystem.

 Special job for <code>kio_file.</code>

*/
	public static native SimpleJob mount( boolean ro, String fstype, String dev, String point, boolean showProgressInfo);
	public static native SimpleJob mount( boolean ro, String fstype, String dev, String point);

/**
 Unmount filesystem.

 Special job for <code>kio_file.</code>

*/
	public static native SimpleJob unmount( String point, boolean showProgressInfo);
	public static native SimpleJob unmount( String point);

/**
 HTTP cache update

*/
	public static native SimpleJob http_update_cache( KURL url, boolean no_cache, long expireDate);

/**
 Find all details for one file or directory.

*/
	public static native StatJob stat( KURL url, boolean showProgressInfo);
	public static native StatJob stat( KURL url);

/**
 Find all details for one file or directory.
 This version of the call includes two additional booleans, <code>sideIsSource</code> and <code>details.</code>

*/
	public static native StatJob stat( KURL url, boolean sideIsSource, short details, boolean showProgressInfo);
	public static native StatJob stat( KURL url, boolean sideIsSource, short details);

/**
 Get (a.k.a. read).

 The slave emits the data through {@link #data}.

*/
	public static native TransferJob get( KURL url, boolean reload, boolean showProgressInfo);
	public static TransferJob get( KURL url, boolean reload) {
		return get(url, reload, true);
	}
	public static native TransferJob get( KURL url);

/**
 Put (a.k.a. write)

*/
	public static native TransferJob put( KURL url, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static native TransferJob put( KURL url, int permissions, boolean overwrite, boolean resume);

/**
 HTTP POST (for form data).

 Example:
 <pre>
    job = KIO.http_post( url, postData, false );
    job.addMetaData("content-type", contentType );
    job.addMetaData("referrer", referrerURL);
 </pre>

 <code>postData</code> is the data that you want to send and
 <code>contentType</code> is the complete HTTP header line that
 specifies the content's MIME type, for example
 "Content-Type: text/xml".

 You MUST specify content-type!

 Often <code>contentType</code> is
 "Content-Type: application/x-www-form-urlencoded" and
 the <code>postData</code> is then an ASCII string (without null-termination!)
 with characters like space, linefeed and percent escaped like %20,
 %0A and %25.

*/
	public static native TransferJob http_post( KURL url, byte[] postData, boolean showProgressInfo);
	public static native TransferJob http_post( KURL url, byte[] postData);
//	public static native MultiGetJob multi_get( long identifier, KURL url, MetaData metaData);

/**
 Find mimetype for one file or directory.

*/
	public static native MimetypeJob mimetype( KURL url, boolean showProgressInfo);
	public static native MimetypeJob mimetype( KURL url);

/**
 Copy a single file.

 Uses either {@link SlaveBase#copy} if the slave supports that
 or {@link #get} and {@link #put} otherwise.

*/
	public static native FileCopyJob file_copy( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static FileCopyJob file_copy( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume) {
		return file_copy(src, dest, permissions, overwrite, resume, true);
	}
	public static FileCopyJob file_copy( KURL src, KURL dest, int permissions, boolean overwrite) {
		return file_copy(src, dest, permissions, overwrite, false, true);
	}
	public static FileCopyJob file_copy( KURL src, KURL dest, int permissions) {
		return file_copy(src, dest, permissions, false, false, true);
	}
	public static native FileCopyJob file_copy( KURL src, KURL dest);

/**
 Move a single file.

 Use either {@link SlaveBase#rename} if the slave supports that,
 or {@link #copy} and {@link #del} otherwise, or eventually get() & put() & del()

*/
	public static native FileCopyJob file_move( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static FileCopyJob file_move( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume) {
		return file_move(src, dest, permissions, overwrite, resume, true);
	}
	public static FileCopyJob file_move( KURL src, KURL dest, int permissions, boolean overwrite) {
		return file_move(src, dest, permissions, overwrite, false, true);
	}
	public static FileCopyJob file_move( KURL src, KURL dest, int permissions) {
		return file_move(src, dest, permissions, false, false, true);
	}
	public static native FileCopyJob file_move( KURL src, KURL dest);

/**
 Delete a single file.

*/
	public static native SimpleJob file_delete( KURL src, boolean showProgressInfo);
	public static native SimpleJob file_delete( KURL src);

/**
 List the contents of <code>url</code>, which is assumed to be a directory.

 "." and ".." are returned, filter them out if you don't want them.

 pass includeHidden = false to cull out UNIX hidden files/dirs
 (whose names start with .)

*/
	public static native ListJob listDir( KURL url, boolean showProgressInfo, boolean includeHidden);
	public static ListJob listDir( KURL url, boolean showProgressInfo) {
		return listDir(url, showProgressInfo, true);
	}
	public static native ListJob listDir( KURL url);

/**
 The same as the previous method, but recurses subdirectories.

 "." and ".." are returned but only for the toplevel directory.
 Filter them out if you don't want them.

 pass includeHidden = false to cull out UNIX hidden files/dirs
 (whose names start with .)

*/
	public static native ListJob listRecursive( KURL url, boolean showProgressInfo, boolean includeHidden);
	public static ListJob listRecursive( KURL url, boolean showProgressInfo) {
		return listRecursive(url, showProgressInfo, true);
	}
	public static native ListJob listRecursive( KURL url);

/**
 Copy a file or directory <code>src</code> into the destination @dest,
 which can be a file (including the final filename) or a directory
 (into which <code>src</code> will be copied).

 This emulates the <code>cp</code> command completely.

*/
	public static native CopyJob copy( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copy( KURL src, KURL dest);

/**
 Copy a file or directory <code>src</code> into the destination @dest,
 which is the destination name in any case, even for a directory.

 As opposed to {@link #copy}, this doesn't emulate <code>cp</code>, but is the only
 way to copy a directory, giving it a new name and getting an error
 box if a directory already exists with the same name.

*/
	public static native CopyJob copyAs( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copyAs( KURL src, KURL dest);

/**
 Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code>

*/
	public static native CopyJob copy( ArrayList src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copy( ArrayList src, KURL dest);

/**

*/
	public static native CopyJob move( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob move( KURL src, KURL dest);

/**

*/
	public static native CopyJob moveAs( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob moveAs( KURL src, KURL dest);

/**

*/
	public static native CopyJob move( ArrayList src, KURL dest, boolean showProgressInfo);
	public static native CopyJob move( ArrayList src, KURL dest);

/**
 Create a link.

*/
	public static native CopyJob link( KURL src, KURL destDir, boolean showProgressInfo);
	public static native CopyJob link( KURL src, KURL destDir);

/**

*/
	public static native CopyJob link( ArrayList src, KURL destDir, boolean showProgressInfo);
	public static native CopyJob link( ArrayList src, KURL destDir);

/**

*/
	public static native CopyJob linkAs( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob linkAs( KURL src, KURL dest);

/**
 Delete a file or directory.

*/
	public static native DeleteJob del( KURL src, boolean shred, boolean showProgressInfo);
	public static native DeleteJob del( KURL src);
	public static native DeleteJob del( ArrayList src, boolean shred, boolean showProgressInfo);
	public static native DeleteJob del( ArrayList src);

/**
 Retrieves meta information for the given items.

*/
//	public static native MetaInfoJob* fileMetaInfo( ArrayList items);

/**
 Same as above, but takes a URL list instead of KFileItemList

*/
//	public static native MetaInfoJob* fileMetaInfo( ArrayList items);
	public static native int pasteClipboard( KURL _dest_url, boolean move);
	public static native int pasteClipboard( KURL _dest_url);
	public static native void pasteData( KURL _dest_url, byte[] _data);
	public static native boolean isClipboardEmpty();

/**
 Generates or retrieves a preview image for the given URL.

*/
//	public static native PreviewJob filePreview( ArrayList items, int width, int height, int iconSize, int iconAlpha, boolean scale, boolean save, String[] enabledPlugins);
//	public static native PreviewJob filePreview( ArrayList items, int width);

/**
 Same as above, but takes a URL list instead of KFileItemList

*/
//	public static native PreviewJob filePreview( ArrayList items, int width, int height, int iconSize, int iconAlpha, boolean scale, boolean save, String[] enabledPlugins);
//	public static native PreviewJob filePreview( ArrayList items, int width);

/**
 \addtogroup renamedlg "RenameDlg related Functions"
  @{
 \relate KIO.RenameDlg
 Construct a modal, parent-less "rename" dialog, and return
 a result code, as well as the new dest. Much easier to use than the
 class {@link RenameDlg} directly.

 The following parameters bring optionnal information about <code>src</code> and <code>dest</code>


*/
//	public static native int open_RenameDlg( String caption, String src, String dest, int mode, String newDestPath, int arg1, int arg2, time_t ctimeSrc  -1 arg3, time_t ctimeDest  -1 arg4, time_t mtimeSrc  -1 arg5, time_t mtimeDest  -1 arg6);
	public static native int open_RenameDlg( String caption, String src, String dest, int mode, String newDestPath);
	public static native int open_SkipDlg( boolean _multi, String _error_text);
	public static native int open_SkipDlg( boolean _multi);
	public static final int ERR_CANNOT_OPEN_FOR_READING = 1;
	public static final int ERR_CANNOT_OPEN_FOR_WRITING = 2;
	public static final int ERR_CANNOT_LAUNCH_PROCESS = 3;
	public static final int ERR_INTERNAL = 4;
	public static final int ERR_MALFORMED_URL = 5;
	public static final int ERR_UNSUPPORTED_PROTOCOL = 6;
	public static final int ERR_NO_SOURCE_PROTOCOL = 7;
	public static final int ERR_UNSUPPORTED_ACTION = 8;
	public static final int ERR_IS_DIRECTORY = 9;
	public static final int ERR_IS_FILE = 10;
	public static final int ERR_DOES_NOT_EXIST = 11;
	public static final int ERR_FILE_ALREADY_EXIST = 12;
	public static final int ERR_DIR_ALREADY_EXIST = 13;
	public static final int ERR_UNKNOWN_HOST = 14;
	public static final int ERR_ACCESS_DENIED = 15;
	public static final int ERR_WRITE_ACCESS_DENIED = 16;
	public static final int ERR_CANNOT_ENTER_DIRECTORY = 17;
	public static final int ERR_PROTOCOL_IS_NOT_A_FILESYSTEM = 18;
	public static final int ERR_CYCLIC_LINK = 19;
	public static final int ERR_USER_CANCELED = 20;
	public static final int ERR_CYCLIC_COPY = 21;
	public static final int ERR_COULD_NOT_CREATE_SOCKET = 22;
	public static final int ERR_COULD_NOT_CONNECT = 23;
	public static final int ERR_CONNECTION_BROKEN = 24;
	public static final int ERR_NOT_FILTER_PROTOCOL = 25;
	public static final int ERR_COULD_NOT_MOUNT = 26;
	public static final int ERR_COULD_NOT_UNMOUNT = 27;
	public static final int ERR_COULD_NOT_READ = 28;
	public static final int ERR_COULD_NOT_WRITE = 29;
	public static final int ERR_COULD_NOT_BIND = 30;
	public static final int ERR_COULD_NOT_LISTEN = 31;
	public static final int ERR_COULD_NOT_ACCEPT = 32;
	public static final int ERR_COULD_NOT_LOGIN = 33;
	public static final int ERR_COULD_NOT_STAT = 34;
	public static final int ERR_COULD_NOT_CLOSEDIR = 35;
	public static final int ERR_COULD_NOT_MKDIR = 37;
	public static final int ERR_COULD_NOT_RMDIR = 38;
	public static final int ERR_CANNOT_RESUME = 39;
	public static final int ERR_CANNOT_RENAME = 40;
	public static final int ERR_CANNOT_CHMOD = 41;
	public static final int ERR_CANNOT_DELETE = 42;
	public static final int ERR_SLAVE_DIED = 43;
	public static final int ERR_OUT_OF_MEMORY = 44;
	public static final int ERR_UNKNOWN_PROXY_HOST = 45;
	public static final int ERR_COULD_NOT_AUTHENTICATE = 46;
	public static final int ERR_ABORTED = 47;
	public static final int ERR_INTERNAL_SERVER = 48;
	public static final int ERR_SERVER_TIMEOUT = 49;
	public static final int ERR_SERVICE_NOT_AVAILABLE = 50;
	public static final int ERR_UNKNOWN = 51;
	public static final int ERR_UNKNOWN_INTERRUPT = 53;
	public static final int ERR_CANNOT_DELETE_ORIGINAL = 54;
	public static final int ERR_CANNOT_DELETE_PARTIAL = 55;
	public static final int ERR_CANNOT_RENAME_ORIGINAL = 56;
	public static final int ERR_CANNOT_RENAME_PARTIAL = 57;
	public static final int ERR_NEED_PASSWD = 58;
	public static final int ERR_CANNOT_SYMLINK = 59;
	public static final int ERR_NO_CONTENT = 60;
	public static final int ERR_DISK_FULL = 61;
	public static final int ERR_IDENTICAL_FILES = 62;
	public static final int ERR_SLAVE_DEFINED = 63;
	public static final int ERR_UPGRADE_REQUIRED = 64;
	public static final int ERR_POST_DENIED = 65;
	public static final int UDS_STRING = 1;
	public static final int UDS_LONG = 2;
	public static final int UDS_TIME = 4|UDS_LONG;
	public static final int UDS_SIZE = 8|UDS_LONG;
	public static final int UDS_SIZE_LARGE = 32768|UDS_LONG;
	public static final int UDS_USER = 16|UDS_STRING;
	public static final int UDS_GROUP = 32|UDS_STRING;
	public static final int UDS_NAME = 64|UDS_STRING;
	public static final int UDS_ACCESS = 128|UDS_LONG;
	public static final int UDS_MODIFICATION_TIME = 256|UDS_TIME;
	public static final int UDS_ACCESS_TIME = 512|UDS_TIME;
	public static final int UDS_CREATION_TIME = 1024|UDS_TIME;
	public static final int UDS_FILE_TYPE = 2048|UDS_LONG;
	public static final int UDS_LINK_DEST = 4096|UDS_STRING;
	public static final int UDS_URL = 8192|UDS_STRING;
	public static final int UDS_MIME_TYPE = 16384|UDS_STRING;
	public static final int UDS_GUESSED_MIME_TYPE = 16392|UDS_STRING;
	public static final int UDS_XML_PROPERTIES = 32768|UDS_STRING;
	public static final int CC_CacheOnly = 0;
	public static final int CC_Cache = 1;
	public static final int CC_Verify = 2;
	public static final int CC_Refresh = 3;
	public static final int CC_Reload = 4;
	public static final int HTTP_GET = 0;
	public static final int HTTP_PUT = 1;
	public static final int HTTP_POST = 2;
	public static final int HTTP_HEAD = 3;
	public static final int HTTP_DELETE = 4;
	public static final int HTTP_OPTIONS = 5;
	public static final int DAV_PROPFIND = 6;
	public static final int DAV_PROPPATCH = 7;
	public static final int DAV_MKCOL = 8;
	public static final int DAV_COPY = 9;
	public static final int DAV_MOVE = 10;
	public static final int DAV_LOCK = 11;
	public static final int DAV_UNLOCK = 12;
	public static final int DAV_SEARCH = 13;
	public static final int DEFAULT = 1;
	public static final int STATUSBAR = 2;
	public static final int LIST = 3;
	public static final int M_OVERWRITE = 1;
	public static final int M_OVERWRITE_ITSELF = 2;
	public static final int M_SKIP = 4;
	public static final int M_SINGLE = 8;
	public static final int M_MULTI = 16;
	public static final int M_RESUME = 32;
	public static final int M_NORENAME = 64;
	public static final int R_RESUME = 6;
	public static final int R_RESUME_ALL = 7;
	public static final int R_OVERWRITE = 4;
	public static final int R_OVERWRITE_ALL = 5;
	public static final int R_SKIP = 2;
	public static final int R_AUTO_SKIP = 3;
	public static final int R_RENAME = 1;
	public static final int R_CANCEL = 0;
	public static final int S_SKIP = 1;
	public static final int S_AUTO_SKIP = 2;
	public static final int S_CANCEL = 0;
	public static final int CMD_HOST = '0';
	public static final int CMD_CONNECT = '1';
	public static final int CMD_DISCONNECT = '2';
	public static final int CMD_SLAVE_STATUS = '3';
	public static final int CMD_SLAVE_CONNECT = '4';
	public static final int CMD_SLAVE_HOLD = '5';
	public static final int CMD_NONE = 'A';
	public static final int CMD_TESTDIR = 'B';
	public static final int CMD_GET = 'C';
	public static final int CMD_PUT = 'D';
	public static final int CMD_STAT = 'E';
	public static final int CMD_MIMETYPE = 'F';
	public static final int CMD_LISTDIR = 'G';
	public static final int CMD_MKDIR = 'H';
	public static final int CMD_RENAME = 'I';
	public static final int CMD_COPY = 'J';
	public static final int CMD_DEL = 'K';
	public static final int CMD_CHMOD = 'L';
	public static final int CMD_SPECIAL = 'M';
	public static final int CMD_USERPASS = 'N';
	public static final int CMD_REPARSECONFIGURATION = 'O';
	public static final int CMD_META_DATA = 'P';
	public static final int CMD_SYMLINK = 'Q';
	public static final int CMD_SUBURL = 'R';
	public static final int CMD_MESSAGEBOXANSWER = 'S';
	public static final int CMD_RESUMEANSWER = 'T';
	public static final int CMD_CONFIG = 'U';
	public static final int CMD_MULTI_GET = 'V';
	public static final int INF_TOTAL_SIZE = 10;
	public static final int INF_PROCESSED_SIZE = 11;
	public static final int INF_SPEED = 0;
	public static final int INF_REDIRECTION = 20;
	public static final int INF_MIME_TYPE = 21;
	public static final int INF_ERROR_PAGE = 22;
	public static final int INF_WARNING = 23;
	public static final int INF_GETTING_FILE = 1;
	public static final int INF_NEED_PASSWD = 25;
	public static final int INF_INFOMESSAGE = 2;
	public static final int INF_META_DATA = 3;
	public static final int INF_NETWORK_STATUS = 4;
	public static final int INF_MESSAGEBOX = 5;
	public static final int MSG_DATA = 100;
	public static final int MSG_DATA_REQ = 0;
	public static final int MSG_ERROR = 1;
	public static final int MSG_CONNECTED = 2;
	public static final int MSG_FINISHED = 3;
	public static final int MSG_STAT_ENTRY = 4;
	public static final int MSG_LIST_ENTRIES = 5;
	public static final int MSG_RENAMED = 6;
	public static final int MSG_RESUME = 7;
	public static final int MSG_SLAVE_STATUS = 8;
	public static final int MSG_SLAVE_ACK = 9;
	public static final int MSG_NET_REQUEST = 10;
	public static final int MSG_NET_DROP = 11;
	public static final int MSG_NEED_SUBURL_DATA = 12;
	public static final int MSG_CANRESUME = 13;
	public static final int MSG_AUTH_KEY = 14;
	public static final int MSG_DEL_AUTH_KEY = 15;
}
