/***************************************************************************
                            KGlobalAccel.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KGlobalAccel allows you to have global accelerators that are independent of
 the focused window. Unlike {@link KAccel} it does not matter which window is 
 currently active.

 See {@link KGlobalAccelSignals} for signals emitted by KGlobalAccel.

 

 @short Configurable global shortcut support.
*/
public class KGlobalAccel extends QObject  {
	protected KGlobalAccel(Class dummy){super((Class) null);}

	private native void newKGlobalAccel( QObject pParent, String psName);

/** 
 Creates a new KGlobalAccel object with the given {@link pParent} and
 {@link psName}.

*/
	public KGlobalAccel( QObject pParent, String psName) {
		super((Class) null);
		newKGlobalAccel( pParent, psName);
	}
	private native void newKGlobalAccel( QObject pParent);
	public KGlobalAccel( QObject pParent) {
		super((Class) null);
		newKGlobalAccel( pParent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Checks whether the accelerators are enabled.

*/
	public native boolean isEnabled();

/** 
 Checks whether the accelerators are enabled.

*/
	public native void setEnabled( boolean bEnabled);

/** 
 Create an accelerator action.

 Usage:
<pre>
 insert( "Do Something", i18n("Do Something"),
   i18n("This action allows you to do something really great with this program to "
        "the currently open document."),
   ALT+CTRL+Key_Q, KKey.QtWIN+CTRL+Key_Q, this, SLOT("slotDoSomething()") );
</pre>

*/
	public native KAccelAction insert( String sAction, String sLabel, String sWhatsThis, KShortcut cutDef3, KShortcut cutDef4, QObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native KAccelAction insert( String sAction, String sLabel, String sWhatsThis, KShortcut cutDef3, KShortcut cutDef4, QObject pObjSlot, String psMethodSlot);

/** 
 Removes the accelerator action identified by the name.
 Remember to also call updateConnections().

*/
	public native boolean remove( String sAction);

/** 
 Use this to insert a label into the action list.  This will be
 displayed when the user configures shortcuts.

*/
	public native KAccelAction insert( String sName, String sLabel);

/** 
 Updates the connections of the accelerations after changing them. 

*/
	public native boolean updateConnections();

/** 
 Set the shortcut to be associated with the action named by <code>sAction.</code>

*/
	public native KShortcut shortcut( String sAction);

/** 
 Set the shortcut to be associated with the action named by <code>sAction.</code>

*/
	public native boolean setShortcut( String sAction, KShortcut shortcut);

/** 
 Set the slot to be called when the shortcut of the action named
 by <code>sAction</code> is pressed.

*/
	public native boolean setSlot( String sAction, QObject pObjSlot, String psMethodSlot);

/**  
 Enable or disable the action named by <code>sAction.</code>

*/
	public native boolean setEnabled( String sAction, boolean bEnabled);

/** 
 Returns the configuration group that is used to save the accelerators.

*/
	public native String configGroup();

/** 
 Sets the configuration group that is used to save the accelerators.

*/
	public native void setConfigGroup( String cg);

/** 
 Read all shortcuts from <code>pConfig</code>, or (if <code>pConfig</code>
 is zero) from the application's configuration file
 {@link KGlobal#config}.

*/
	public native boolean readSettings( KConfigBase pConfig);
	public native boolean readSettings();

/** 
 Write the current shortcuts to <code>pConfig</code>,
 or (if <code>pConfig</code> is zero) to the application's
 configuration file.

*/
	public native boolean writeSettings( KConfigBase pConfig);
	public native boolean writeSettings();

/** 
 Write the current shortcuts to <code>pConfig</code>,
 or (if <code>pConfig</code> is zero) to the application's
 configuration file.  Alternatively, if bGlobal is true, then write
 to kdeglobals.

*/
	public native boolean writeSettings( KConfigBase pConfig, boolean bGlobal);

/** 

 KAccelActions.useFourModifierKeys().
	 
*/
	public static native boolean useFourModifierKeys();
	protected native void virtual_hook( int identifier, int data);
}
