/***************************************************************************
                            kde_KStringHandler.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSTRINGHANDLER
#define KDE_KSTRINGHANDLER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class is @em not a substitute for the @ref QString class. What
 I tried to do with this class is provide an easy way to
 cut/slice/splice words inside sentences in whatever order desired.
 While the main focus of this class are words (ie characters
 separated by spaces/tabs), the two core functions here (@ref split()
 and @ref join() ) will function given any char to use as a separator.
 This will make it easy to redefine what a 'word' means in the
 future if needed.

 I freely stole some of the function names from python. I also think
 some of these were influenced by mIRC (yes, believe it if you will, I
 used to write a LOT of scripts in mIRC).

 The ranges are a fairly powerful way of getting/stripping words from
 a string. These ranges function, for the large part, as they would in
 python. See the @ref word(const QString&, int) and @ref remword(const QString&, int) functions for more detail.

 This class contains no data members of it own. All strings are cut
 on the fly and returned as new qstrings/qstringlists.

 Quick example on how to use:

 <pre>
 KStringHandler kstr;
 QString line = "This is a test of the strings";

 cout << "1> " << kstr.word( line , "4:" ) << "\n";
 cout << "2> " << kstr.remrange( line , "2:5" ) << "\n";
 cout << "2> " << kstr.reverse( line ) << "\n";
 cout << "2> " << kstr.center( kstr.word( line , 4 ) , 15 ) << "\n";
 </pre>

 and so forth.

 @author Ian Zepp <icszepp@islc.net>
 
 @short Class for manipulating words and sentences in strings.
*/

/** * Returns the nth word in the string if found
 Returns a EMPTY (not null) string otherwise.
 Note that the FIRST index is 0.

*/
qt_QString * kde_KStringHandler_word( qt_QString * text, unsigned int pos);

/** * Returns a range of words from that string.
 Ie:

 If you grok python, you're set.

*/
qt_QString * kde_KStringHandler_word1( qt_QString * text, char* range);

/** * Inserts a word into the string, and returns
 a new string with the word included. the first
 index is zero (0). If there are not @p pos words in the original 
 string, the new word will be appended to the end.

*/
qt_QString * kde_KStringHandler_insword( qt_QString * text, qt_QString * word, unsigned int pos);

/** * Replaces a word in the string, and returns
 a new string with the word included. the first
 index is zero (0). If there are not @p pos words in the original 
 string, the new word will be appended to the end.

*/
qt_QString * kde_KStringHandler_setword( qt_QString * text, qt_QString * word, unsigned int pos);

/** * Removes a word or ranges of words from the string,
 and returns a new string. The ranges definitions
 follow the definitions for the word() function.

*/
qt_QString * kde_KStringHandler_remrange( qt_QString * text, char* range);

/** * Removes a word at the given index, and returns a
 new string. The first index is zero (0).

*/
qt_QString * kde_KStringHandler_remword( qt_QString * text, unsigned int pos);

/** * Removes a matching word from the string, and returns
 a new string. Note that only ONE match is removed.

*/
qt_QString * kde_KStringHandler_remword1( qt_QString * text, qt_QString * word);

/** * Capitalizes each word in the string
 "hello there" becomes "Hello There"        (string)

*/
qt_QString * kde_KStringHandler_capwords( qt_QString * text);

/** * Capitalizes each word in the list
 [hello, there] becomes [Hello, There]    (list)

*/
qt_QStringList* kde_KStringHandler_capwords1( qt_QStringList* list);

/** * Reverses the order of the words in a string
 "hello there" becomes "there hello"        (string)

*/
qt_QString * kde_KStringHandler_reverse( qt_QString * text);

/** * Reverses the order of the words in a list
 [hello, there] becomes [there, hello]    (list)

*/
qt_QStringList* kde_KStringHandler_reverse1( qt_QStringList* list);

/** * Left-justifies a string and returns a string at least 'width' characters 
 wide.
 If the string is longer than the @p width, the original
 string is returned. It is never truncated.

*/
qt_QString * kde_KStringHandler_ljust( qt_QString * text, unsigned int width);

/** * Right-justifies a string and returns a string at least 'width' characters 
 wide.
 If the string is longer than the @p width, the original
 string is returned. It is never truncated.

*/
qt_QString * kde_KStringHandler_rjust( qt_QString * text, unsigned int width);

/** * Centers a string and returns a string at least 'width' characters 
 wide.
 If the string is longer than the @p width, the original
 string is returned. It is never truncated.

*/
qt_QString * kde_KStringHandler_center( qt_QString * text, unsigned int width);

/** * Substitute characters at the beginning of a string by "...".

*/
qt_QString * kde_KStringHandler_lsqueeze( qt_QString * str, unsigned int maxlen);

/** * Substitute characters at the middle of a string by "...".

*/
qt_QString * kde_KStringHandler_csqueeze( qt_QString * str, unsigned int maxlen);

/** * Substitute characters at the end of a string by "...".

*/
qt_QString * kde_KStringHandler_rsqueeze( qt_QString * str, unsigned int maxlen);

/** *
 Match a filename.

*/
int kde_KStringHandler_matchFileName( qt_QString * filename, qt_QString * pattern);

/** *
 Split a QString into a QStringList in a similar fashion to the static
 QStringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 <pre>
 perlSplit("__", "some__string__for__you__here", 4)
 QStringList contains: "some", "string", "for", "you__here"
 </pre>

*/
qt_QStringList* kde_KStringHandler_perlSplit( qt_QString * sep, qt_QString * s, unsigned int max);

/** *
 Split a QString into a QStringList in a similar fashion to the static
 QStringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 <pre>
 perlSplit(' ', "kparts reaches the parts other parts can't", 3)
 QStringList contains: "kparts", "reaches", "the pats other parts can't"
 </pre>

*/
qt_QStringList* kde_KStringHandler_perlSplit1( qt_QChar* sep, qt_QString * s, unsigned int max);

/** *
 Split a QString into a QStringList in a similar fashion to the static
 QStringList function in Qt, except you can specify a maximum number
 of tokens. If max is specified (!= 0) then only that number of tokens
 will be extracted. The final token will be the remainder of the string.

 Example:
 <pre>
 perlSplit(QRegExp("[! ]", "Split me up ! I'm bored ! OK ?", 3)
 QStringList contains: "Split", "me", "up ! I'm bored, OK ?"
 </pre>

*/
qt_QStringList* kde_KStringHandler_perlSplit2( qt_QRegExp* sep, qt_QString * s, unsigned int max);

/** *
 This method auto-detects URLs in strings, and adds HTML markup to them
 so that richtext or HTML-enabled widgets (such as KActiveLabel)
 will display the URL correctly.

*/
qt_QString * kde_KStringHandler_tagURLs( qt_QString * text);

#endif
