/***************************************************************************
                            kde_KEdit.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KEDIT
#define KDE_KEDIT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A simple text editor for the KDE project.

 @author Bernd Johannes Wuebben <wuebben@math.cornell.edu>, Waldo Bastian <bastian@kde.org>

 @short *
 A simple text editor for the KDE project.
*/
#define KEDIT_NONE	0
#define KEDIT_FORWARD	1
#define KEDIT_BACKWARD	2

/** *
 The usual constructor.

*/
kde_KEdit * kde_new_KEdit(qt_QWidget * _parent, char* name);
void kde_del_KEdit( kde_KEdit* p );

/** *
 Insert text from the text stream into the edit widget.

*/
void kde_KEdit_insertText(kde_KEdit* instPointer,qt_QTextStream* arg1);

/** *
 Save text from the edit widget to a text stream.
 If @p softWrap is false soft line wrappings are replaced with line-feeds
 If @p softWrap is true soft line wrappings are ignored.

*/
void kde_KEdit_saveText(kde_KEdit* instPointer,qt_QTextStream* arg1, int softWrap);
void kde_KEdit_saveText1(kde_KEdit* instPointer,qt_QTextStream* arg1);

/** *
  Let the user select a font and set the font of the textwidget to that
 selected font.

*/
void kde_KEdit_selectFont(kde_KEdit* instPointer);

/** *
 Present a search dialog to the user

*/
void kde_KEdit_search(kde_KEdit* instPointer);

/** *
 Repeat the last search specified on the search dialog.

  If the user hasn't searched for anything until now, this method
   will simply return without doing anything.

*/
int kde_KEdit_repeatSearch(kde_KEdit* instPointer);

/** *
 Present a Search and Replace Dialog to the user.

*/
void kde_KEdit_replace(kde_KEdit* instPointer);

/** *
 Present a "Goto Line" dialog to the user.
     
*/
void kde_KEdit_doGotoLine(kde_KEdit* instPointer);

/** *
 Clean up redundant whitespace from selected text.
     
*/
void kde_KEdit_cleanWhiteSpace(kde_KEdit* instPointer);

/** *
 Install a context menu for KEdit.

  The Popup Menu will be activated on a right mouse button press event.
     
*/
void kde_KEdit_installRBPopup(kde_KEdit* instPointer,qt_QPopupMenu* arg1);

/** *
 Retrieve the current line number.

 The current line is the line the cursor is on.

*/
int kde_KEdit_currentLine(kde_KEdit* instPointer);

/** *
 Retrieve the actual column number the cursor is on.

  This call differs
    from @ref QMultiLineEdit::getCursorPosition() in that it returns the actual cursor
    position and not the character position. Use @ref currentLine() and @ref currentColumn()
    if you want to display the current line or column in the status bar for
    example.
     
*/
int kde_KEdit_currentColumn(kde_KEdit* instPointer);

/** *
 Start spellchecking mode.
     
*/
void kde_KEdit_spellcheck_start(kde_KEdit* instPointer);

/** *
 Exit spellchecking mode.
     
*/
void kde_KEdit_spellcheck_stop(kde_KEdit* instPointer);

/** *
 Allow the user to toggle between insert mode and overwrite mode with
 the "Insert" key. See also @ref toggle_overwrite_signal();

 The default is false: the user can not toggle.
     
*/
void kde_KEdit_setOverwriteEnabled(kde_KEdit* instPointer,int b);
void kde_KEdit_computePosition(kde_KEdit* instPointer);
int kde_KEdit_doSearch(kde_KEdit* instPointer,qt_QString * s_pattern, int case_sensitive, int regex, int forward, int line, int col);
int kde_KEdit_doReplace(kde_KEdit* instPointer,qt_QString * s_pattern, int case_sensitive, int regex, int forward, int line, int col, int replace);

/** *
 Sets line and col to the position pos, considering word wrap.

*/
void kde_KEdit_posToRowCol(kde_KEdit* instPointer,unsigned int pos, unsigned int line, unsigned int col);

/** *
 Reimplemented for internal reasons, the API is not affected.
     
*/
void kde_KEdit_create(kde_KEdit* instPointer,unsigned int arg1, int initializeWindow, int destroyOldWindow);
void kde_KEdit_virtual_hook(kde_KEdit* instPointer,int identifier, void* data);

#endif
