/***************************************************************************
                            kde_KCodecs.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCODECS
#define KDE_KCODECS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A wrapper class for the most commonly used encoding and
 decoding algorithms.  Currently there is support for encoding
 and decoding input using base64, uu and the quoted-printable
 specifications.

 <PRE>
 QCString input = "Aladdin:open sesame";
 QCString result = KCodecs::base64Encode(input);
 cout << "Result: " << result.data() << endl;

 Output should be
 Result: QWxhZGRpbjpvcGVuIHNlc2FtZQ==
 </PRE>

 The above example makes use of the convenience functions
 (ones that accept/return null-terminated strings) to encode/decode
 a string.  If what you need is to encode or decode binary data, then
 it is highly recommended that you use the functions that take an input
 and output QByteArray as arguments.  These functions are specifically
 tailored for encoding and decoding binary data.

 @author Rik Hemsley <rik@kde.org>
 
 @short A collection of commonly used encoding and decoding algorithms.

*/

/** *
 Encodes the given data using the quoted-printable algorithm.

*/
qt_QCString* kde_KCodecs_quotedPrintableEncode( qt_QByteArray* in, int useCRLF);

/** *
 @overload

 Same as above except it accepts a null terminated
 string instead an array.

*/
qt_QCString* kde_KCodecs_quotedPrintableEncode1( qt_QCString* str, int useCRLF);

/** *
 Encodes the given data using the quoted-printable algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for encoding binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
void kde_KCodecs_quotedPrintableEncode2( qt_QByteArray* in, qt_QByteArray* out, int useCRLF);

/** *
 Decodes a quoted-printable encoded string.

 Accepts data with CRLF or standard unix line breaks.

*/
qt_QCString* kde_KCodecs_quotedPrintableDecode( qt_QByteArray* in);

/** *
 @overload

 Same as above except it accepts a null terminated
 string instead an array.

*/
qt_QCString* kde_KCodecs_quotedPrintableDecode1( qt_QCString* str);

/** *
 Decodes a quoted-printable encoded data.

 Accepts data with CRLF or standard unix line breaks.
 Use this function if you want the result of the decoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for decoding an encoded
 binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
void kde_KCodecs_quotedPrintableDecode2( qt_QByteArray* in, qt_QByteArray* out);

/** *
 Encodes the given data using the uuencode algorithm.

 The output is split into lines starting with the number of
 encoded octets in the line and ending with a newline.  No
 line is longer than 45 octets (60 characters), excluding the
 line terminator.

*/
qt_QCString* kde_KCodecs_uuencode( qt_QByteArray* in);

/** *
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
qt_QCString* kde_KCodecs_uuencode1( qt_QCString* str);

/** *
 Encodes the given data using the uuencode algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array and cut down the number of
 copy operation that have to be performed in the process.
 This is the preffered method for encoding binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
void kde_KCodecs_uuencode2( qt_QByteArray* in, qt_QByteArray* out);

/** *
 Decodes the given data using the uuencode algorithm.

 Any 'begin' and 'end' lines like those generated by
 the utilities in unix and unix-like OS will be
 automatically ignored.

*/
qt_QCString* kde_KCodecs_uudecode( qt_QByteArray* in);

/** *
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
qt_QCString* kde_KCodecs_uudecode1( qt_QCString* str);

/** *
 Decodes the given data using the uudecode algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is the preferred method for decoding binary data.

 Any 'begin' and 'end' lines like those generated by
 the utilities in unix and unix-like OS will be
 automatically ignored.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
void kde_KCodecs_uudecode2( qt_QByteArray* in, qt_QByteArray* out);

/** *
 Encodes the given data using the base64 algorithm.

 The boolean argument determines if the encoded data is
 going to be restricted to 76 characters or less per line
 as specified by RFC 2045.  If @p insertLFs is true, then
 there will be 76 characters or less per line.

*/
qt_QCString* kde_KCodecs_base64Encode( qt_QByteArray* in, int insertLFs);

/** *
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
qt_QCString* kde_KCodecs_base64Encode1( qt_QCString* str, int insertLFs);

/** *
 Encodes the given data using the base64 algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for encoding binary data.

 The boolean argument determines if the encoded data is going
 to be restricted to 76 characters or less per line as specified
 by RFC 2045.  If @p insertLFs is true, then there will be 76
 characters or less per line.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
void kde_KCodecs_base64Encode2( qt_QByteArray* in, qt_QByteArray* out, int insertLFs);

/** *
 Decodes the given data that was encoded using the
 base64 algorithm.

*/
qt_QCString* kde_KCodecs_base64Decode( qt_QByteArray* in);

/** *
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
qt_QCString* kde_KCodecs_base64Decode1( qt_QCString* str);

/** *
 Decodes the given data that was encoded with the base64
 algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for decoding an encoded
 binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
void kde_KCodecs_base64Decode2( qt_QByteArray* in, qt_QByteArray* out);

#endif
