class Q_EXPORT QWMatrix
{
public:
    QWMatrix();
    QWMatrix( const QWMatrix& matrix );    
    QWMatrix( double m11, double m12, double m21, double m22, double dx, double dy );

    void setMatrix( double m11, double m12, double m21, double m22, double dx,  double dy );
    double matrix(); // returns a list of doubles
    
    int	        map( int x, int y )	      const;  // Returns two ints
    double	map( double x, double y ) const; // Returns two doubles
    QPoint	map( const QPoint & )	const;
    QRect	map( const QRect & )	const;
    QPointArray map( const QPointArray & ) const;

    void	reset();

    Self translate( double dx, double dy );
    Self scale( double sx, double sy );
    Self shear( double sh, double sv );
    Self rotate( double a );

    QWMatrix	invert() const prop(invert);
    bool        isInvertable() const prop(invertable);
    
    bool	operator==( const QWMatrix & ) const;
    bool	operator!=( const QWMatrix & ) const;
    QWMatrix   &operator*=( const QWMatrix & );
};
