/*
 *   kdeprintfax - a small fax utility
 *   Copyright (C) 2001  Michael Goffioul
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef CONFSYSTEM_H
#define CONFSYSTEM_H

#include <qwidget.h>
#include <qstringlist.h>

class QLineEdit;
class QComboBox;

class ConfSystem : public QWidget
{
	Q_OBJECT
public:
	ConfSystem(QWidget *parent = 0, const char *name = 0);

	void load();
	void save();

protected slots:
	void slotSystemChanged(int);

private:
	QComboBox	*m_system, *m_device;
	QLineEdit	*m_command, *m_server;
	QStringList	m_commands;
	int		m_current;
};

#endif
