/***************************************************************************
                          glowconfigdialog.h  -  description
                             -------------------
    begin                : Thu Sep 12 2001
    copyright            : (C) 2001 by Henning Burchardt
    email                : h_burchardt@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GLOW_CONFIG_DIALOG_H
#define GLOW_CONFIG_DIALOG_H

#include <qvaluevector.h>
#include <qobject.h>

class QPushButton;
class QSignalMapper;
class QCheckBox;
class QComboBox;
class KConfig;
class KColorButton;

class GlowConfigDialog : public QObject
{
	Q_OBJECT

public:
	GlowConfigDialog( KConfig* conf, QWidget* parent );
	~GlowConfigDialog();

signals:
	void changed();

public slots:
	void load( KConfig* conf );
	void save( KConfig* conf );
	void defaults();

protected slots:
	void slotTitleButtonClicked(int);
	void slotColorButtonChanged(const QColor&);
	void slotTitlebarGradientTypeChanged(int);
	void slotResizeHandleCheckBoxChanged();

private:
	enum ButtonType{stickyButton, helpButton, iconifyButton, maximizeButton, closeButton };
	
	KConfig *m_glowConfig;

	bool m_showResizeHandle;
	KPixmapEffect::GradientType m_titlebarGradientType;

	QGroupBox *m_mainGroupBox;
	QGroupBox *m_buttonGlowColorGroupBox;

	QCheckBox *m_showResizeHandleCheckBox;
	QComboBox *m_titlebarGradientTypeComboBox;

	QPushButton *m_stickyButton;
	QPushButton *m_helpButton;
	QPushButton *m_iconifyButton;
	QPushButton *m_maximizeButton;
	QPushButton *m_closeButton;
	QSignalMapper *m_titleButtonMapper;

	QColor* m_buttonConfigMap;
	QValueVector<QPushButton*> m_titleButtonList;
	
	KColorButton *m_colorButton;
};

#endif
