#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/ioctl.h>
#include <string.h>

#include "cwkeyer.h"


int testmorse(void)
{
	int fd;
	int retval;
	char message[] = "TLF";

	fd = open("/dev/cwkeyer", O_RDWR );
    
	retval = ioctl(fd, CWKEYER_IOCSSPEED, 40);
	if	(retval)
	{
		printf("[%d] Unable to set speed\n", retval);
	}

/*	retval = ioctl(fd, CWKEYER_IOCSCALL, "PA3FKN");
	if	(retval)
	{
		printf("[%d] Unable to set call\n", retval);
	}

	retval = ioctl(fd, CWKEYER_IOCSRST, "599");
	if	(retval)
	{
		printf("[%d] Unable to set rst\n", retval);
	}

	retval = ioctl(fd, CWKEYER_IOCSQSONUMBER, "023");
	if	(retval)
	{
		printf("[%d] Unable to set call\n", retval);
	}
  */
	if	(ioctl(fd, CWKEYER_IOCSFREQ, 700))
	{
		printf("Unable to set sidetone freq.\n");
	}

	if	(ioctl(fd, CWKEYER_IOCSWEIGTH, 0))
	{
		printf("Unable to set weight\n");
	}

	if	(ioctl(fd, CWKEYER_IOCSTXDELAY, 50))
	{
		printf("Unable to set TX delay\n");
	}

	write( fd, message, strlen(message));

	sleep(3);

	retval = ioctl(fd, CWKEYER_IOCSFLUSH, NULL);
	if	(retval)
	{
		printf("[%d] Unable to flush\n", retval);
	}



	close(fd);
	
	return(0);
}


