.TH sane-canon630u 5 "06 Apr 2002"
.IX sane-canon630u
.SH NAME
sane-canon630u - SANE backend for the Canon 630u USB flatbed scanner
.SH DESCRIPTION
The
.B sane-canon
library implements a SANE (Scanner Access Now Easy) backend that
provides access to the following Canon flatbed scanners:
.PP
.RS
CanoScan 630u
.br
CanoScan 636u (hopefully)
.br
.RE
.PP
IMPORTANT: this is alpha code.  Although there are no known bugs at this
time, this code uses the Linux USB kernel drivers, which are currently
in active development.  So it may not work, your computer might even hang, and it cannot
be excluded (although I consider it extremely unprobable) that your scanner
will be damaged.
.PP
That said, TESTERS ARE WELCOME. Send your bug reports and comments to
Nathan Rutman <nathan@gordian.com>
.PP
.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is the path-name for the special device that corresponds to a USB scanner
or a symlink to such a device.  The program
.IR sane-find-scanner 
helps to find out the correct device. Under Linux, such a device name
could be
.I /dev/usb/scanner0
for example.  See sane-usb(5) for details.

.SH CONFIGURATION
The contents of the
.I canon630u.conf
file is a list of device names that correspond to Canon
USB scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  Only one device name can be listed in 
.IR canon630u.conf .

.SH NOTES
.PP
Due to Canon's unwillingness to provide scanner documentation, this
software was developed by analyzing the USB traffic of the Windows
2000 driver.  So things like the calibration procedure I kind of made up;
it seems to work for my scanner.  If you have complaints, let me know.
.PP
This driver requires the ability to send USB Control Messages, available in
kernel 2.4.12 or later. 
.PP
This scanner may not be recognized (yet) by the USB kernel driver.  Check
for "Driver=usbscanner" under /proc/bus/usb/devices.  If "Driver=(none)",
try forcing it with "modprobe scanner vendor=0x04a9 product=0x2204"
.PP
.SH FILES
.TP
.I @CONFIGDIR@/canon630u.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-canon630u.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-canon630u.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.TP
.I /tmp/canon.cal
The calibration file used to normalize pixel brightness.  This is
calculated every time the scanner is first used after it has lost power.
It can be forced to recalibrate by simply deleting this file. 
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_CANON630U
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  Higher
debug levels increase the verbosity of the output. 

Example: 
export SANE_DEBUG_CANON630U=10
.SH "SEE ALSO"
sane(7), sane\-usb(5), sane\-find\-scanner(1)
.br
http://canon-fb630u.sourceforge.net/
.br
.SH AUTHOR
Nathan Rutman

