#!/usr/bin/perl
##
## Example script to export ldap entries into an smbpasswd file format
## using the Mozilla PerLDAP module.
##
## writen by jerry@samba.org
##

use Mozilla::LDAP::Conn;
use Mozilla::LDAP::Entry;

######################################################
## Set these values to whatever you need for your site
##

$DN="ou=people,dc=plainjoe,dc=org";
$ROOTDN="cn=Manager,dc=plainjoe,dc=org";
$rootpw = "secret";
$LDAPSERVER="localhost";

##
## end local site variables
######################################################


$conn = new Mozilla::LDAP::Conn ("$LDAPSERVER", "389", $ROOTDN, $rootpw );
die "Unable to connect to LDAP server $LDAPSERVER" unless $conn;

print "##\n";
print "## Autogenerated smbpasswd file via ldapsearch\n";
print "## from $LDAPSERVER ($DN)\n";
print "##\n";

## scheck for the existence of the posixAccount first
$result = $conn->search ("$DN", "sub", "(objectclass=smbPasswordEntry)");
	
	
## loop over the entries we found
while ($result) {
	
	@uid         = $result->getValue("uid"); 
	@uidNumber   = $result->getValue("uidNumber"); 
	@lm_pw       = $result->getValue("lmpassword"); 
	@nt_pw       = $result->getValue("ntpassword"); 
	@acct        = $result->getValue("acctFlags"); 
	@pwdLastSet  = $result->getValue("pwdLastSet"); 
	
	if (($#uid+1) && ($#uidNumber+1)) {
	
		$lm_pw[0]      = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" if (! ($#lm_pw+1));
		$nt_pw[0]      = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" if (! ($#nt_pw+1));
		$acct[0]       = "[DU         ]" if (! ($#acct+1));
		$pwdLastSet[0] = "FFFFFFFF" if (! ($#pwdLastSet+1));
		
		print "$uid[0]:$uidNumber[0]:$lm_pw[0]:$nt_pw[0]:$acct[0]:LCT-$pwdLastSet[0]\n";
	}
	
	$result = $conn->nextEntry();		
	
}

$conn->close();
exit 0;
