#line 2 "scanner.cc"
/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/kde/koffice/lib/koscript/scanner.cc,v 1.6 2001/06/29 09:58:29 wtrobin Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define YY_USES_REJECT

#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 92
#define YY_END_OF_BUFFER 93
static yyconst short int yy_acclist[320] =
    {   0,
       93,   91,   92,    1,   91,   92,    2,   92,    1,   91,
       92,   24,   91,   92,   91,   92,   91,   92,   48,   91,
       92,   33,   91,   92,   38,   91,   92,   91,   92,   18,
       91,   92,   19,   91,   92,   31,   91,   92,   29,   91,
       92,   91,   92,   30,   91,   92,   44,   91,   92,   32,
       91,   92,   87,   91,   92,   86,   91,   92,   20,   91,
       92,   21,   91,   92,   42,   91,   92,   25,   91,   92,
       43,   91,   92,   79,   91,   92,   79,   91,   92,   79,
       91,   92,   16,   91,   92,   17,   91,   92,   37,   91,
       92,   79,   91,   92,   79,   91,   92,   79,   91,   92,

       79,   91,   92,   79,   91,   92,   79,   91,   92,   79,
       91,   92,   79,   91,   92,   79,   91,   92,   79,   91,
       92,   79,   91,   92,   79,   91,   92,   79,   91,   92,
       14,   91,   92,   36,   91,   92,   15,   91,   92,   34,
       91,   92,   23,   90,    5,    4,   47,   39,   76,   45,
       84,   77,   46,    3,16392,   87,   88,   86,   78,   28,
       40,   26,   22,   41,   27,    9,   79,   79,   79,   79,
       79,   79,   79,   79,   62,   79,   79,   79,   79,   79,
       79,   64,   79,   79,   59,   79,   79,   79,   79,   79,
       79,   79,   79,   79,   79,   35,    4,    9,   89,   13,

       89,16392,    3, 8200, 8200,    3,    3,   83,   82,   88,
       83,   79,   79,   79,   79,   79,   79,   79,   79,   79,
       79,   63,   79,   79,   79,   79,   79,   60,   79,   79,
       79,   79,   79,   79,   72,   79,   70,   79,   79,   10,
       13,   85,   83,   82,   83,    7,   79,   51,   79,   56,
       79,   79,   79,   79,   65,   79,   58,   79,   79,   79,
       75,   79,   79,   79,   66,   79,   79,   79,   79,   79,
       53,   79,   79,   83,   81,   80,   80,   83,   12,   50,
       79,   73,   79,   49,   79,   79,   52,   79,   79,   79,
       71,   79,   74,   79,   79,   79,   79,   61,   79,   83,

        6,   79,   79,   69,   79,   68,   79,   54,   79,   55,
       79,   11,   81,   82,   57,   79,   67,   79,   80
    } ;

static yyconst short int yy_accept[274] =
    {   0,
        1,    1,    1,    2,    4,    7,    9,   12,   15,   17,
       19,   22,   25,   28,   30,   33,   36,   39,   42,   44,
       47,   50,   53,   56,   59,   62,   65,   68,   71,   74,
       77,   80,   83,   86,   89,   92,   95,   98,  101,  104,
      107,  110,  113,  116,  119,  122,  125,  128,  131,  134,
      137,  140,  143,  143,  143,  144,  144,  145,  145,  145,
      146,  147,  147,  148,  149,  149,  149,  149,  149,  150,
      151,  152,  153,  154,  154,  156,  156,  156,  156,  157,
      157,  157,  158,  158,  158,  159,  160,  161,  162,  163,
      164,  164,  165,  166,  166,  168,  169,  170,  171,  172,

      173,  174,  175,  177,  178,  179,  180,  181,  182,  184,
      185,  187,  188,  189,  190,  191,  192,  193,  194,  195,
      196,  197,  197,  197,  197,  197,  198,  199,  200,  200,
      202,  202,  202,  202,  203,  205,  206,  207,  208,  208,
      209,  209,  210,  211,  211,  212,  212,  212,  212,  212,
      213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
      224,  225,  226,  227,  228,  230,  231,  232,  233,  234,
      235,  237,  239,  240,  240,  241,  241,  241,  242,  242,
      242,  242,  243,  243,  243,  244,  244,  245,  245,  246,
      246,  247,  247,  247,  247,  247,  248,  250,  252,  253,

      254,  255,  257,  259,  260,  261,  263,  264,  265,  267,
      268,  269,  270,  271,  273,  274,  274,  274,  274,  274,
      274,  275,  275,  276,  277,  279,  279,  279,  279,  279,
      280,  282,  284,  286,  287,  289,  290,  291,  293,  295,
      296,  297,  298,  300,  300,  300,  300,  301,  301,  301,
      301,  302,  302,  303,  304,  306,  308,  310,  312,  312,
      313,  313,  313,  315,  315,  317,  319,  319,  319,  319,
      320,  320,  320
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,    1,   29,   30,   30,   30,   31,   32,
       33,   33,   33,   33,   33,   34,   33,   33,   33,   33,
       33,   35,   36,   37,   38,   33,   33,   39,   33,   33,
       40,   41,   42,   43,   44,    1,   45,   46,   47,   48,

       49,   50,   33,   51,   52,   33,   33,   53,   54,   55,
       56,   57,   33,   58,   59,   60,   61,   62,   63,   64,
       65,   33,   66,   67,   68,   69,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[70] =
    {   0,
        1,    2,    2,    3,    3,    4,    1,    5,    1,    1,
        6,    7,    1,    1,    1,    1,    1,    7,    1,    8,
        8,    9,   10,    1,    1,    1,    1,    4,   11,   11,
       11,   11,   12,   12,   12,   12,   12,   12,   13,    1,
        4,    1,    1,   14,   15,   15,   11,   11,   11,   15,
       12,   12,   12,   12,   13,   12,   12,   13,   12,   13,
       12,   13,   12,   13,   12,    1,    1,    1,    1
    } ;

static yyconst short int yy_base[295] =
    {   0,
        0,    0,  871, 1065, 1065, 1065,  864,  793,   64,   68,
      772, 1065,  802,  105, 1065, 1065, 1065,   57,   54,   60,
       58,   62,  171,  178,  786, 1065,   62,  152,   58,  203,
      208,   61, 1065, 1065, 1065,    0,  150,  148,  185,  198,
      203,   53,  154,  156,  159,  151,   62,  152, 1065,  741,
     1065, 1065,  802,  798, 1065,  220, 1065,  224,  799, 1065,
      798,  228, 1065, 1065,  789,  788,  787,  239, 1065, 1065,
      244, 1065, 1065,  214,  303,  794,  262,   72,  207,  353,
      274,  413,  265,   79,    0, 1065, 1065, 1065, 1065, 1065,
      371, 1065, 1065,  277,  375,  767,    0,   68,   66,  347,

      222,  189,  766,  233,  212,  247,  352,  245,  765,  348,
      353,  349,  354,  356,  355,  358,  359,  360,  362,  370,
     1065,  785,  416,  406,    0,  789,  428, 1065,  780, 1065,
      382,    0,  449,  786,  471, 1065,    0,    0,  434,  471,
      483,  495,    0,  501,  487,  409,  249,  770,  780,  520,
      417,  155,  403,  357,  460,  412,  481,  411,  472,  497,
      498,  499,  500,  503,  758,  504,  505,  506,  371,  513,
      755,  754,  512,  527,  548,  539,  575, 1065,  533,  771,
      552,  555,  777,  578,  570,  567,  588,  606,  609,  261,
     1065,  777,  537,  771,  624,  583,  749,  748,  528,  557,

      573,  747,  746,  564,  438,  745,  365,  589,  740,  586,
      604,  556,  607,  739,  608,  756,  228,  632,  752,  621,
      643,  630,  646,  649,  668,  634,  636,  758,  658,  661,
      698,  694,  677,  647,  675,  658,  662,  627,  619,  664,
      665,  667,  610,  586,  687,  681,  690,  709,  693,  679,
     1065,  548,  668,  687,  521,  400,  252,  202,  712,  715,
      720,  723,  726,  729,  161,   79,  732,  735,  754,  755,
      745, 1065,  802,  817,  832,  837,  852,  865,  873,  884,
      896,  911,  921,  933,  946,  954,  962,  977,  987,  998,
     1008, 1023, 1034, 1049

    } ;

static yyconst short int yy_def[295] =
    {   0,
      272,    1,  272,  272,  272,  272,  273,  272,  274,  275,
      276,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  277,  273,   23,  272,  272,  272,  272,  272,  278,
      278,   31,  272,  272,  272,  279,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,  272,  272,
      272,  272,  273,  280,  272,  274,  272,  281,  275,  272,
      282,  276,  272,  272,  272,  283,  283,  284,  272,  272,
      272,  272,  272,  277,  272,  277,  273,  272,   23,   23,
      273,  273,  273,  272,   24,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  285,   31,  279,   31,   31,   31,

       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
      272,  280,  280,  274,  286,  282,  272,  272,  283,  272,
      272,  287,  272,  288,   75,  272,   75,  135,  273,  272,
      272,  273,   82,  273,  272,  272,  289,  272,  290,  285,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,  272,  272,  274,  274,  272,  272,  291,
      272,  272,  288,  273,  272,  272,  272,  273,  272,  289,
      272,  289,  292,  290,  290,   31,   31,   31,   31,   31,

       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,  293,  274,  274,  272,   23,
      272,  272,  272,   24,  272,  292,  294,  292,  272,  272,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,  293,  293,  272,  272,  272,  272,  294,
      272,  294,   31,   31,   31,   31,   31,   31,  272,  272,
      272,  272,  272,  272,   31,   31,  272,  272,  272,  272,
      272,    0,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272

    } ;

static yyconst short int yy_nxt[1135] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   24,   25,   26,   27,   28,   29,    4,   30,   30,
       30,   31,   30,   30,   30,   30,   32,   30,   30,   33,
        4,   34,   35,   36,   30,   30,   37,   38,   39,   40,
       30,   41,   30,   42,   30,   43,   30,   44,   45,   46,
       30,   47,   48,   30,   30,   49,   50,   51,   52,   57,
       60,   69,   61,   71,   71,   71,   72,   71,   71,   71,
       75,   96,   70,   92,   93,   73,   87,   88,   89,   96,
       96,  140,  140,  140,   96,   99,   96,  112,  145,  145,

      145,  151,   76,  152,   58,   65,  119,   96,   65,   65,
       65,   65,   65,   65,   65,   66,   65,   65,   65,   65,
       65,   65,   65,   65,   65,   65,   65,   65,   65,   65,
       65,   65,   65,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   65,   68,   65,   65,   65,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
       65,   65,   65,   65,   77,   54,   96,   90,   96,   96,
       96,   83,   96,   96,   96,  197,   78,   96,   78,   96,
       79,   79,   80,   84,  100,   84,  102,   85,   85,   85,

      114,   81,  120,  103,  115,  101,   53,   54,  118,   82,
       94,   53,   54,   96,  113,   94,   53,   96,  116,   81,
       91,  117,   95,   95,   95,   57,   96,   95,   95,   95,
       96,   96,  134,   57,   82,   94,   98,  104,  156,  105,
       96,   53,  106,  124,  124,   53,   97,  127,  127,  127,
       96,   97,  109,  107,   76,  108,  110,  111,  131,  131,
       58,   96,  125,   71,   71,   71,   54,  191,   58,   54,
       53,  272,  158,   96,  133,   96,  155,  132,   54,  191,
       96,  139,  139,  139,  144,  144,  144,  125,  141,  192,
      141,  157,  133,  142,  142,  142,  127,  127,  127,  159,

      161,  192,  132,  135,  135,  136,  137,  135,  135,  135,
      135,  135,  135,  135,  138,  135,  135,  135,  135,  135,
      138,  135,  138,  138,  138,  135,  135,  135,  135,  135,
      135,  138,  138,  138,  138,  138,  138,  138,  138,  138,
      138,  138,  135,  135,  135,  135,  138,  138,  138,  138,
      138,  138,  138,  138,  138,  138,  138,  138,  138,  138,
      138,  138,  138,  138,  138,  138,  138,  138,  135,  135,
      135,  135,   80,   80,  146,   96,   96,   96,   53,   54,
       96,   96,   96,   96,   96,   96,   96,   96,   96,  147,
       96,   53,  128,   96,   95,   95,   95,  149,   96,   96,

      164,  179,  179,  199,  162,  153,  154,  166,  163,  160,
      169,   57,  146,  165,  167,  168,   53,   54,   97,  172,
      170,  173,  237,  174,  171,  176,  176,  147,   96,  148,
      213,   96,  143,  143,  143,  175,  175,  175,   54,   96,
       96,  143,  143,  143,  143,   96,   58,  127,  127,  127,
      149,  198,  196,  184,  184,  184,  201,  143,  143,  143,
      143,  143,  143,  181,  203,  181,   96,  148,  182,  182,
      182,  138,  138,  272,  138,  138,  138,  138,  138,  138,
      138,  138,  236,  138,  138,  138,  138,  138,   96,  138,
      185,  185,  185,  138,  138,  138,  138,  138,  138,   54,

       96,  186,  187,  187,  187,   54,  189,  189,  189,   96,
      138,  138,  138,  138,  142,  142,  142,  186,  200,  186,
      188,  188,  188,   53,   54,   96,   96,   96,   96,  202,
      204,   96,   96,   96,   96,  186,  138,  138,  138,  138,
       96,   96,  272,  128,   57,  205,  175,  175,  175,   96,
      272,  206,   65,   65,  207,  227,   96,  209,  217,  217,
      208,  214,  210,   97,  215,  211,  212,  175,  175,  175,
      216,  182,  182,  182,  182,  182,  182,  228,  232,   58,
       57,  222,   54,  222,   96,   96,  223,  223,  223,  221,
      221,  221,   96,  272,  218,  218,  218,  220,  220,  220,

      186,   96,  241,  218,  218,  218,  218,  187,  187,  187,
       54,   96,  235,  231,   96,   58,  233,   96,  186,  218,
      218,  218,  218,  218,  218,  224,  224,  224,  225,  225,
      225,  229,   96,  234,  239,   96,   96,   57,   96,  186,
       53,   53,   53,  230,  230,  230,  246,   96,  238,  223,
      223,  223,  227,  242,  251,   96,  243,  186,   78,   53,
       78,  240,  247,  247,  247,  223,  223,  223,   53,   53,
       53,  249,   58,  248,  228,   96,  252,  230,  230,  230,
      230,  230,  230,   84,   53,   84,   96,  247,  247,  247,
       96,  248,   96,   96,  259,   96,   96,  251,  248,  253,

      261,  261,  261,   96,  254,   96,  260,  260,  260,  247,
      247,  247,  264,  264,  264,   96,  248,  258,  256,  252,
      186,  255,   96,  262,  257,  262,   96,  265,  263,  263,
      263,  260,  260,  260,  260,  260,  260,  266,  186,  267,
      267,  267,  263,  263,  263,  263,  263,  263,  268,  268,
      268,  269,  269,  269,  270,  270,  270,  246,  249,  141,
      272,  141,  128,  244,  187,  187,  187,   96,   96,   78,
       84,   78,   84,   96,   96,   96,   96,   96,  272,  272,
      183,  128,   96,   96,  271,  271,   96,  194,  193,  183,
      178,   60,  272,   96,   96,   96,  272,  130,   66,  128,

       60,   60,  271,  271,   53,  122,   54,  121,   86,   53,
       53,   64,   53,   53,   53,   63,   53,   56,   55,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   62,   62,   62,
       62,   62,   74,   74,   74,   74,   74,   74,   74,   74,
       74,   74,   74,   74,   74,   74,   74,   96,   54,   96,
      272,  272,   96,   96,  272,   96,   96,   96,   96,   96,
       97,   97,  272,   97,   97,   97,   97,   97,  123,  272,
      272,  272,  272,  272,  123,  123,  123,  272,  123,   56,

      272,   56,  272,   56,  272,  272,  272,  272,   56,  272,
       56,  126,  126,  126,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  129,  272,  272,  272,
      272,  129,  129,  129,  272,  129,   65,  272,   65,  272,
       65,  272,  272,  272,  272,   65,  272,   65,  150,  272,
      272,  272,  272,  150,  150,  150,  150,  150,  150,  150,
      150,  177,  177,  272,  177,  272,  272,  272,  177,  180,
      180,  272,  180,  272,  272,  272,  180,  136,  136,  136,
      136,  136,  136,  272,  272,  272,  136,  190,  190,  190,
      190,  190,  190,  190,  190,  190,  190,  190,  190,  190,

      190,  190,  195,  272,  272,  272,  272,  272,  195,  195,
      195,  272,  195,  219,  272,  219,  219,  272,  219,  272,
      272,  272,  219,  226,  226,  226,  226,  226,  226,  226,
      226,  226,  226,  226,  226,  226,  226,  226,  245,  272,
      272,  272,  272,  272,  245,  245,  245,  272,  245,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,    3,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,

      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272
    } ;

static yyconst short int yy_chk[1135] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    9,
       10,   18,   10,   19,   19,   19,   20,   21,   21,   21,
       22,   42,   18,   29,   29,   20,   27,   27,   27,   32,
       47,   78,   78,   78,   99,   32,   98,   42,   84,   84,

       84,   98,   22,   99,    9,   14,   47,  266,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   23,   23,   38,   28,   37,   46,
       48,   24,   43,  152,   44,  152,   23,   45,   23,  265,
       23,   23,   23,   24,   37,   24,   38,   24,   24,   24,

       44,   23,   48,   38,   44,   37,   30,   30,   46,   23,
       30,   31,   31,   39,   43,   31,   24,  102,   45,   23,
       28,   45,   30,   30,   30,   56,   40,   31,   31,   31,
      258,   41,   74,  217,   23,   62,   31,   39,  102,   39,
      105,   24,   40,   58,   58,   79,   30,   62,   62,   62,
      101,   31,   41,   40,   74,   40,   41,   41,   68,   68,
       56,  104,   58,   71,   71,   71,   77,  147,  217,   83,
       79,   62,  105,  108,   71,  106,  101,   68,   81,  190,
      257,   77,   77,   77,   83,   83,   83,   58,   81,  147,
       81,  104,   71,   81,   81,   81,   94,   94,   94,  106,

      108,  190,   68,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   80,   80,   91,  100,  110,  112,   95,   95,
      107,  111,  113,  115,  114,  154,  116,  117,  118,   91,
      119,   80,  131,  207,   95,   95,   95,   95,  120,  169,

      112,  131,  131,  154,  110,  100,  100,  114,  111,  107,
      117,  124,  146,  113,  115,  116,   80,   82,   95,  119,
      118,  120,  207,  123,  118,  124,  124,  146,  256,   91,
      169,  153,   82,   82,   82,  123,  123,  123,  139,  158,
      156,   82,   82,   82,   82,  151,  124,  127,  127,  127,
      127,  153,  151,  139,  139,  139,  156,   82,   82,   82,
       82,   82,   82,  133,  158,  133,  205,  146,  133,  133,
      133,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  205,  135,  135,  135,  135,  135,  155,  135,
      140,  140,  140,  135,  135,  135,  135,  135,  135,  142,

      159,  140,  141,  141,  141,  144,  145,  145,  145,  157,
      135,  135,  135,  135,  142,  142,  142,  145,  155,  140,
      144,  144,  144,  150,  150,  160,  161,  162,  163,  157,
      159,  164,  166,  167,  168,  145,  135,  135,  135,  135,
      173,  170,  150,  179,  176,  160,  174,  174,  174,  255,
      252,  161,  179,  179,  162,  193,  199,  164,  176,  176,
      163,  170,  166,  150,  173,  167,  168,  175,  175,  175,
      175,  181,  181,  181,  182,  182,  182,  193,  199,  176,
      177,  186,  184,  186,  212,  200,  186,  186,  186,  185,
      185,  185,  204,  244,  177,  177,  177,  184,  184,  184,

      185,  201,  212,  177,  177,  177,  177,  187,  187,  187,
      188,  196,  204,  196,  210,  177,  200,  208,  185,  177,
      177,  177,  177,  177,  177,  188,  188,  188,  189,  189,
      189,  195,  211,  201,  210,  213,  215,  218,  243,  189,
      220,  220,  220,  195,  195,  195,  221,  239,  208,  222,
      222,  222,  226,  213,  227,  238,  215,  189,  221,  220,
      221,  211,  221,  221,  221,  223,  223,  223,  224,  224,
      224,  225,  218,  221,  226,  234,  227,  229,  229,  229,
      230,  230,  230,  225,  220,  225,  236,  225,  225,  225,
      237,  221,  240,  241,  245,  242,  253,  250,  225,  234,

      246,  246,  246,  235,  236,  233,  245,  245,  245,  247,
      247,  247,  249,  249,  249,  254,  225,  242,  240,  250,
      247,  237,  232,  248,  241,  248,  231,  253,  248,  248,
      248,  259,  259,  259,  260,  260,  260,  254,  247,  261,
      261,  261,  262,  262,  262,  263,  263,  263,  264,  264,
      264,  267,  267,  267,  268,  268,  268,  269,  270,  271,
      228,  271,  219,  216,  271,  271,  271,  214,  209,  269,
      270,  269,  270,  206,  203,  202,  198,  197,  194,  192,
      183,  180,  172,  171,  269,  270,  165,  149,  148,  134,
      129,  126,  122,  109,  103,   96,   76,   67,   66,   65,

       61,   59,  269,  270,  273,   54,   53,   50,   25,  273,
      273,   13,  273,  273,  273,   11,  273,  274,    8,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  275,  275,  275,  275,  275,  275,  275,  275,
      275,  275,  275,  275,  275,  275,  275,  276,  276,  276,
      276,  276,  277,  277,  277,  277,  277,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  277,  278,    7,  278,
        3,    0,  278,  278,    0,  278,  278,  278,  278,  278,
      279,  279,    0,  279,  279,  279,  279,  279,  280,    0,
        0,    0,    0,    0,  280,  280,  280,    0,  280,  281,

        0,  281,    0,  281,    0,    0,    0,    0,  281,    0,
      281,  282,  282,  282,  282,  282,  282,  282,  282,  282,
      282,  282,  282,  282,  282,  282,  283,    0,    0,    0,
        0,  283,  283,  283,    0,  283,  284,    0,  284,    0,
      284,    0,    0,    0,    0,  284,    0,  284,  285,    0,
        0,    0,    0,  285,  285,  285,  285,  285,  285,  285,
      285,  286,  286,    0,  286,    0,    0,    0,  286,  287,
      287,    0,  287,    0,    0,    0,  287,  288,  288,  288,
      288,  288,  288,    0,    0,    0,  288,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,

      289,  289,  290,    0,    0,    0,    0,    0,  290,  290,
      290,    0,  290,  291,    0,  291,  291,    0,  291,    0,
        0,    0,  291,  292,  292,  292,  292,  292,  292,  292,
      292,  292,  292,  292,  292,  292,  292,  292,  293,    0,
        0,    0,    0,    0,  293,  293,  293,    0,  293,  294,
      294,  294,  294,  294,  294,  294,  294,  294,  294,  294,
      294,  294,  294,  294,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,

      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272
    } ;

static yy_state_type yy_state_buf[YY_BUF_SIZE + 2], *yy_state_ptr;
static char *yy_full_match;
static int yy_lp;
static int yy_looking_for_trail_begin = 0;
static int yy_full_lp;
static int *yy_full_state;
#define YY_TRAILING_MASK 0x2000
#define YY_TRAILING_HEAD_MASK 0x4000
#define REJECT \
{ \
*yy_cp = yy_hold_char; /* undo effects of setting up yytext */ \
yy_cp = yy_full_match; /* restore poss. backed-over text */ \
yy_lp = yy_full_lp; /* restore orig. accepting pos. */ \
yy_state_ptr = yy_full_state; /* restore orig. state */ \
yy_current_state = *yy_state_ptr; /* restore curr. state */ \
++yy_lp; \
goto find_rule; \
}
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "scanner.ll"
#define INITIAL 0
#line 2 "scanner.ll"

#define YY_NO_UNPUT
#include <stdlib.h>
#include <ctype.h>

#include "koscript_parsenode.h"
#include "koscript_types.h"
#include "koscript_synext.h"
#include "koscript_locale.h"

#include <klocale.h>

#ifndef KDE_USE_FINAL
#include "yacc.cc.h"
#endif

extern int idl_line_no;

static bool s_kspread;
KLocale* s_koscript_locale = 0;
static KLocale* s_defaultLocale = 0;

#include <qstring.h>

static KScript::Long ascii_to_longlong( long base, const char *s )
{
  KScript::Long ll = 0;
  while( *s != '\0' ) {
    char c = *s++;
    if( c >= 'a' )
      c -= 'a' - 'A';
    c -= '0';
    if( c > 9 )
      c -= 'A' - '0' - 10;
    ll = ll * base + c;
  }
  return ll;
}

static KScript::Double ascii_to_longdouble (const char *s)
{
  KScript::Double d;
#ifdef HAVE_SCANF_LF
  sscanf (s, "%Lf", &d);
#else
  /*
   * this is only an approximation and will probably break fixed<>
   * parameter calculation on systems where
   * sizeof(double) < sizeof(long double). but fortunately all
   * systems where scanf("%Lf") is known to be broken (Linux/Alpha
   * and HPUX) have sizeof(double) == sizeof(long double).
   */
  d = strtod (s, NULL);
#endif
  return d;
}

static char translate_char( const char *s )
{
  char c = *s++;

  if( c != '\\' )
    return c;
  c = *s++;
  switch( c ) {
  case 'n':
    return '\n';
  case 't':
    return '\t';
  case 'v':
    return '\v';
  case 'b':
    return '\b';
  case 'r':
    return '\r';
  case 'f':
    return '\f';
  case 'a':
    return '\a';
  case '\\':
    return '\\';
  case '?':
    return '\?';
  case '\'':
    return '\'';
  case '"':
    return '"';
  case 'x':
  case 'X':
    return (char) ascii_to_longlong( 16, s );
  default:
    // Gotta be an octal
    return (char) ascii_to_longlong( 8, s );
  }
}

static QChar translate_unichar( const QChar *s )
{
  QChar c = *s++;

  if( c != '\\' )
    return c;
  c = *s++;
  switch( c.latin1() ) {
  case 'n':
    return '\n';
  case 't':
    return '\t';
  case 'v':
    return '\v';
  case 'b':
    return '\b';
  case 'r':
    return '\r';
  case 'f':
    return '\f';
  case 'a':
    return '\a';
  case '\\':
    return '\\';
  case '?':
    return '\?';
  case '\'':
    return '\'';
  case '"':
    return '"';
  default:
    return c;
  }
}

static void translate_string( QString& str )
{
	int pos = 0;
	while( ( pos = str.find( '\\', pos ) ) != -1 )
	{
		QChar ch = translate_unichar( str.unicode() + pos );
		str.replace( pos, 2, &ch, 1 );
	}
}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#line 911 "scanner.cc"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp = NULL, *yy_bp = NULL;
	register int yy_act;

#line 182 "scanner.ll"


#line 1065 "scanner.cc"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		yy_state_ptr = yy_state_buf;
		*yy_state_ptr++ = yy_current_state;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 273 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			*yy_state_ptr++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_current_state != 272 );

yy_find_action:
		yy_current_state = *--yy_state_ptr;
		yy_lp = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( yy_lp && yy_lp < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[yy_lp];
				if ( yy_act & YY_TRAILING_HEAD_MASK ||
				     yy_looking_for_trail_begin )
					{
					if ( yy_act == yy_looking_for_trail_begin )
						{
						yy_looking_for_trail_begin = 0;
						yy_act &= ~YY_TRAILING_HEAD_MASK;
						break;
						}
					}
				else if ( yy_act & YY_TRAILING_MASK )
					{
					yy_looking_for_trail_begin = yy_act & ~YY_TRAILING_MASK;
					yy_looking_for_trail_begin |= YY_TRAILING_HEAD_MASK;
					}
				else
					{
					yy_full_match = yy_cp;
					yy_full_state = yy_state_ptr;
					yy_full_lp = yy_lp;
					break;
					}
				++yy_lp;
				goto find_rule;
				}
			--yy_cp;
			yy_current_state = *--yy_state_ptr;
			yy_lp = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
#line 184 "scanner.ll"
;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 185 "scanner.ll"
{ idl_line_no++; return T_SEMICOLON; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 186 "scanner.ll"
;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 187 "scanner.ll"
;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 188 "scanner.ll"
;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 190 "scanner.ll"
{
						  const char *c = yytext + 2;
						  while( isspace( *c ) ) ++c;
						  ++c; ++c;
			 			  yylval._str = new QString( c );
						  yylval._str->truncate( yylval._str->length() - 1 );
						  return T_SUBST;
						}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 198 "scanner.ll"
{
						  const char *c = yytext + 2;
						  while( isspace( *c ) ) ++c;
						  ++c;
			 			  yylval._str = new QString( c );
						  yylval._str->truncate( yylval._str->length() - 1 );
						  return T_MATCH;
						}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 206 "scanner.ll"
{
			 			  yylval._str = new QString( yytext + 1 );
						  yylval._str->truncate( yylval._str->length() - 1 );
						  return T_MATCH_LINE;
						}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 212 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_CELL;
		       };
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 222 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_CELL;
		       };
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 232 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_RANGE;
		       };
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 242 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_RANGE;
		       };
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 252 "scanner.ll"
{
			  if ( !s_kspread )
			  {
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			  }
                          yylval._str = new QString( yytext );
			  return T_RANGE;
		       };
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 261 "scanner.ll"
return T_LEFT_CURLY_BRACKET;
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 262 "scanner.ll"
return T_RIGHT_CURLY_BRACKET;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 263 "scanner.ll"
return T_LEFT_SQUARE_BRACKET;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 264 "scanner.ll"
return T_RIGHT_SQUARE_BRACKET;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 265 "scanner.ll"
return T_LEFT_PARANTHESIS;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 266 "scanner.ll"
return T_RIGHT_PARANTHESIS;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 267 "scanner.ll"
return T_COLON;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 268 "scanner.ll"
return T_COMMA;
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 269 "scanner.ll"
return T_EQUAL;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 270 "scanner.ll"
return T_NOTEQUAL;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 271 "scanner.ll"
return T_NOT;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 272 "scanner.ll"
return T_ASSIGN;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 273 "scanner.ll"
return T_INPUT;
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 274 "scanner.ll"
return T_SHIFTRIGHT;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 275 "scanner.ll"
return T_SHIFTLEFT;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 276 "scanner.ll"
return T_PLUS_SIGN;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 277 "scanner.ll"
return T_MINUS_SIGN;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 278 "scanner.ll"
return T_ASTERISK;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 279 "scanner.ll"
return T_SOLIDUS;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 280 "scanner.ll"
return T_PERCENT_SIGN;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 281 "scanner.ll"
return T_TILDE;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 282 "scanner.ll"
return T_OR;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 283 "scanner.ll"
return T_VERTICAL_LINE;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 284 "scanner.ll"
return T_CIRCUMFLEX;
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 285 "scanner.ll"
return T_AMPERSAND;
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 286 "scanner.ll"
return T_AND;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 287 "scanner.ll"
return T_LESS_OR_EQUAL;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 288 "scanner.ll"
return T_GREATER_OR_EQUAL;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 289 "scanner.ll"
return T_LESS_THAN_SIGN;
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 290 "scanner.ll"
return T_GREATER_THAN_SIGN;
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 291 "scanner.ll"
return T_MEMBER;
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 292 "scanner.ll"
return T_PLUS_ASSIGN;
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 293 "scanner.ll"
return T_MINUS_ASSIGN;
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 294 "scanner.ll"
return T_LINE;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 295 "scanner.ll"
return T_DOLLAR;
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 297 "scanner.ll"
return T_CONST;
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 298 "scanner.ll"
return T_FALSE;
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 299 "scanner.ll"
return T_TRUE;
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 300 "scanner.ll"
return T_FALSE;
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 301 "scanner.ll"
return T_TRUE;
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 302 "scanner.ll"
return T_STRUCT;
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 303 "scanner.ll"
return T_SWITCH;
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 304 "scanner.ll"
return T_CASE;
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 305 "scanner.ll"
return T_DEFAULT;
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 306 "scanner.ll"
return T_ENUM;
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 307 "scanner.ll"
return T_IN;
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 308 "scanner.ll"
return T_OUT;
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 309 "scanner.ll"
return T_WHILE;
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 310 "scanner.ll"
return T_DO;
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 311 "scanner.ll"
return T_FOR;
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 312 "scanner.ll"
{
				if ( !s_kspread )
					return T_IF;
			  	yylval.ident = new QString( yytext );
			  	return T_IDENTIFIER;
			}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 318 "scanner.ll"
return T_ELSE;
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 319 "scanner.ll"
return T_MAIN;
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 320 "scanner.ll"
return T_FOREACH;
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 321 "scanner.ll"
return T_RETURN;
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 322 "scanner.ll"
return T_IMPORT;
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 323 "scanner.ll"
return T_VAR;
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 324 "scanner.ll"
return T_INOUT;
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 325 "scanner.ll"
return T_TRY;
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 326 "scanner.ll"
return T_CATCH;
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 327 "scanner.ll"
return T_RAISE;
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 328 "scanner.ll"
return T_FROM;
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 330 "scanner.ll"
return T_INCR;
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 331 "scanner.ll"
return T_DECR;
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 332 "scanner.ll"
return T_SCOPE;
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 336 "scanner.ll"
{
			  yylval.ident = new QString( yytext );
			  return T_IDENTIFIER;
			}
	YY_BREAK
case 80:
#line 341 "scanner.ll"
case 81:
#line 342 "scanner.ll"
case 82:
#line 343 "scanner.ll"
case 83:
#line 344 "scanner.ll"
case 84:
#line 345 "scanner.ll"
case 85:
YY_RULE_SETUP
#line 345 "scanner.ll"
{
			  QString s( yytext );
			  bool ok = TRUE;
                          double f = s_koscript_locale->readNumber( s, &ok );
			  // if ( !ok )
			  //	f = s.toDouble( &ok );
			  if ( !ok )
				return T_UNKNOWN;
			  int i = (int)f;
			  if ( i == f )
			  {
			      yylval._int = i;
			      return T_INTEGER_LITERAL;
		  	  }
			  yylval._float = f;
			  return T_FLOATING_PT_LITERAL;
			}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 362 "scanner.ll"
{
			  yylval._int = ascii_to_longlong( 10, yytext );
			  return T_INTEGER_LITERAL;
			}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 366 "scanner.ll"
{
			  yylval._int = ascii_to_longlong( 8, yytext );
			  return T_INTEGER_LITERAL;
			}
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 370 "scanner.ll"
{
			  yylval._int = ascii_to_longlong( 16, yytext + 2 );
			  return T_INTEGER_LITERAL;
			}
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 374 "scanner.ll"
{
                          QCString s( yytext );
	                  s = s.mid( 1, s.length() - 2 );
			  yylval._char = translate_char( s );
			  return T_CHARACTER_LITERAL;
			}
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 380 "scanner.ll"
{
                          QString s( yytext );
                          yylval._str = new QString( s.mid( 1, s.length() - 2 ) );
			  if ( yylval._str->isNull() )
				*(yylval._str) = "";
			  translate_string( *(yylval._str) );
			  return T_STRING_LITERAL;
			}
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 388 "scanner.ll"
{
                          return T_UNKNOWN;
                        }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 392 "scanner.ll"
ECHO;
	YY_BREAK
#line 1719 "scanner.cc"
			case YY_STATE_EOF(INITIAL):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;
	yy_state_ptr = yy_state_buf;
	*yy_state_ptr++ = yy_current_state;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 273 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		*yy_state_ptr++ = yy_current_state;
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;

	register YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 273 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 272);
	if ( ! yy_is_jam )
		*yy_state_ptr++ = yy_current_state;

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 392 "scanner.ll"


void kscriptInitFlex( const char *_code, int extension, KLocale* locale )
{
   s_koscript_locale = locale;
   if ( !s_koscript_locale )
   {
	if ( !s_defaultLocale )
		s_defaultLocale = new KSLocale;
       s_koscript_locale = s_defaultLocale;
   }
   if ( extension == KSCRIPT_EXTENSION_KSPREAD )
	s_kspread = TRUE;
   else
	s_kspread = FALSE;
   yy_switch_to_buffer( yy_scan_string( _code ) );
}

void kscriptInitFlex( int extension, KLocale* locale )
{
   s_koscript_locale = locale;
   if ( !s_koscript_locale )
   {
	if ( !s_defaultLocale )
		s_defaultLocale = new KSLocale;
       s_koscript_locale = s_defaultLocale;
   }
   if ( extension == KSCRIPT_EXTENSION_KSPREAD )
	s_kspread = TRUE;
   else
	s_kspread = FALSE;
}
