/*
 * pcmcia.h
 *
 * Copyright (c) 1999 Paul Campbell <paul@taniwha.com>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __POWERCONFIG_H__
#define __POWERCONFIG_H__

#include <kcmodule.h>
#include <qstring.h>

class QWidget;
class QButtonGroup;
class QRadioButton;
class QSpinBox;
class KConfig;

class PowerConfig : public KCModule
{
  Q_OBJECT
public:
  PowerConfig( QWidget *parent=0, const char* name=0);

  void save( void );
  void load();
  void defaults();

  virtual QString quickHelp() const;

private slots:

  void configChanged();

    
private:
       
  int  getPower();
  int  getNoPower();
  void setPower( int, int );

  QButtonGroup *nopowerBox;
  QRadioButton *nopowerStandby, *nopowerSuspend, *nopowerOff, *nopowerHibernate;
  QButtonGroup *powerBox;
  QRadioButton *powerStandby, *powerSuspend, *powerOff, *powerHibernate;
  QSpinBox *noeditwait;
  QSpinBox *editwait;
  int edit_wait, noedit_wait;

  KConfig *config;
  int power, nopower, apm;
};

#endif

