#ifndef KJVIS_H
#define KJVIS_H

#include "kjwidget.h"
class KJLoader;
class KPixmap;

class KJVisScope : public KJWidget
{
public:
	KJVisScope(KJLoader *parent) : KJWidget(parent) {}
	enum Visuals { Null=0, FFT, Mono };
	void swapScope(Visuals newOne);
};

// dummy-scope displaying nothing
class KJNullScope : public KJVisScope
{
public:
	KJNullScope(const QStringList &, KJLoader *parent);
	virtual void paint(QPainter *p, const QRect &);
	virtual bool mousePress(const QPoint&);

private:
	KPixmap *mBack;

};

// analyzer-like scope
class KJVis : public KJVisScope, public MonoFFTScope
{
public:
	KJVis(const QStringList &, KJLoader *parent);
	virtual void paint(QPainter *p, const QRect &);
	virtual void scopeEvent(float *d, int size);

	virtual bool mousePress(const QPoint&);

private:
	QColor mColor;
	KPixmap *mGradient;
	KPixmap *mBack;
	KPixmap *mAnalyzer;
	int mMultiples;
};

// oscilloscope showing waveform
class KJScope : public KJVisScope, public MonoScope
{
public:
	KJScope ( const QStringList &, KJLoader *parent);
	virtual void paint(QPainter *p, const QRect &);
	virtual void scopeEvent(float *d, int size);

	virtual bool mousePress(const QPoint&);

private:
	QColor mColor;
	KPixmap *mBack;
	KPixmap *mOsci;
	int mMultiples;
	int mWidth;
	int mHeight;
	unsigned int blurnum;
};

#endif
