/*
    Copyright (C) 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef _OPTION_DIALOG_H_
#define _OPTION_DIALOG_H_

#include <qwidget.h>
#include <qgroupbox.h>
#include <qframe.h>

class QLabel;
class QComboBox;
class QCheckBox;
class KURLRequester;

#include <kdialogbase.h>

class COptionDialog : public KDialogBase {
  Q_OBJECT

public:
	COptionDialog( QWidget *parent=0, const char *name = 0, bool modal = true );
  ~COptionDialog( void );

  QComboBox *QComboBox_cdwriterdev;
  QComboBox *QComboBox_cdreaderdev;
  QComboBox *QComboBox_Fifosize;
  QCheckBox *QCheckBox_disableStartlogo;
  QCheckBox *QCheckBox_BurnProof;
  KURLRequester *KURLRequester_cdrecord_path;
  KURLRequester *KURLRequester_readcd_path;
  KURLRequester *KURLRequester_cdrdao_path;
  KURLRequester *KURLRequester_mkisofs_path;
  KURLRequester *KURLRequester_mpg123_path;
  KURLRequester *KURLRequester_ogg123_path;
  QPushButton *QPushButton_adduser;
  QPushButton *QPushButton_deleteuser;
  QListBox *QListBox_users;

private:
  void setupDevices();
  void setupOptions();
  void setupPaths();
  void setupUsers();
	void rootOptions();

protected slots:
  virtual void slotOk( void );
  virtual void slotApply( void );
  virtual void slotDefault( void );
  virtual void slotUser1( void );
	void slot_addUser();
	void slot_deleteUser();

signals:
  void valueChanged( void );
};

#endif
