/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef COPYCD_H
#define COPYCD_H

#include <qwidget.h>

#include <kprocess.h>
#include <kconfig.h>

#include <copycd_gui.h>

#include "processoutput.h"
#include "imgprocout.h"

/**
  *@author Kai Heitkamp
  */

class CopyCD : public CopyCD_GUI  {
   Q_OBJECT

public:
	CopyCD(QWidget *parent=0, const char *name=0);
	~CopyCD();

	QString cdrecord, readcd;

protected:
	ProcessOutput procoutdlg;
	ImgProcOut imgprocoutdlg;
	KProcess process;
	KConfig *config;
	bool oneDrive;

protected slots:
	void slot_toggleDaO();
	void slot_toggleTaO();
	void slot_start();
	void slot_writeCD();
	void slot_createImage();
	void slot_writeCDonthefly();
	void slot_quit();
	void abort_handler();
	void slotRecStderr( KProcess *proc, char *buffer, int buflen);
	void slotImageStderr( KProcess *, char *buffer, int buflen);
	void slotProcessExited(KProcess *rcproc);
	void slotImageExited(KProcess *rcproc);
};

#endif
