#ifndef COMMON_MISC_UI_H
#define COMMON_MISC_UI_H

#include <qframe.h>
#include <qcanvas.h>
#include <qpainter.h>
#include <qhbox.h>
#include <qptrvector.h>


class BaseBoard;

/*****************************************************************************/
class ShowNextPiece : public QCanvasView
{
 Q_OBJECT
 public:
    ShowNextPiece(BaseBoard *, QWidget *parent);

	QSize sizeHint() const;
	QSizePolicy sizePolicy() const;

 private slots:
    void blockSizeChanged() { updateGeometry(); }
};

/*****************************************************************************/
class Shadow : public QWidget
{
 Q_OBJECT
 public:
    Shadow(BaseBoard *, QWidget *parent);

	QSize sizeHint() const;
	QSizePolicy sizePolicy() const;

    void setDisplay(bool show);

 private slots:
	void blockSizeChanged() { updateGeometry(); }

 private:
	int              _xOffset;
	const BaseBoard *_board;
    bool             _show;

    void paintEvent(QPaintEvent *);
};

/****************************************************************************/
class GiftShower : public QWidget
{
 Q_OBJECT
 public:
    GiftShower(QWidget *parent);

	QSize sizeHint() const;
	QSizePolicy sizePolicy() const;

 public slots:
    void set();

 protected:
	void paintEvent(QPaintEvent *);

 private slots:
    void timeout();

 private:
	bool _state;
};

/*****************************************************************************/
class Led;

class GiftPool : public QHBox
{
 Q_OBJECT
 public:
    GiftPool(QWidget *parent);

	QSize sizeHint() const;
	QSizePolicy sizePolicy() const;

    void reset();
	void put(uint);
	uint take();
	bool pending() const { return ready; }

 private slots:
    void timeout() { ready = true; }

 private:
	QPtrVector<Led> leds;
	uint         _timeout, nb;
	bool         ready;
};

#endif
