/***************************************************************************
                          keducaprefs.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keducaprefs.h"
#include "keducaprefs.moc"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kconfig.h>

#include <qlayout.h>
#include <qvbox.h>
#include <qbuttongroup.h>


keducaprefs::keducaprefs(QWidget *parent, const char *name, bool modal ) : KDialogBase(IconList, i18n("Configure"), Ok|Cancel, Ok, parent, name, modal, true)
{
	setPageGeneral();
	configRead();
}

keducaprefs::~keducaprefs(){}

/** Set page general */
void keducaprefs::setPageGeneral()
{
	QVBox *mainFrame = addVBoxPage( i18n("Miscellaneous"), i18n("Various settings"), DesktopIcon("misc"));

	QButtonGroup *ButtonGroup1 = new QButtonGroup( mainFrame, "ButtonGroup1" );
	ButtonGroup1->setTitle( i18n( "General" ) );
	ButtonGroup1->setColumnLayout(0, Qt::Vertical );
	ButtonGroup1->layout()->setSpacing( 0 );
	ButtonGroup1->layout()->setMargin( 0 );
	QVBoxLayout *ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
	ButtonGroup1Layout->setAlignment( Qt::AlignTop );
	ButtonGroup1Layout->setSpacing( 6 );
	ButtonGroup1Layout->setMargin( 11 );

	result_afternext = new QRadioButton( ButtonGroup1, "RadioButton1" );
	result_afternext->setText( i18n( "Show results of the answer after press next" ) );
	ButtonGroup1Layout->addWidget( result_afternext );

	result_afterfinish = new QRadioButton( ButtonGroup1, "RadioButton2" );
	result_afterfinish->setText( i18n( "Show results when finish the test" ) );
	ButtonGroup1Layout->addWidget( result_afterfinish );

//	mainFrame->addWidget( ButtonGroup1 );
//	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
//	spacer->add( mainFrame );
}

/** Read settings */
void keducaprefs::configRead()
{
  KConfig *config = KGlobal::config();
	config->setGroup("Options");
	QSize defaultSize(500,400);
	this->resize( config->readSizeEntry("Geometry", &defaultSize ) );
	config->readBoolEntry("ResultFinish", true ) ? result_afterfinish->setChecked(true) : result_afternext->setChecked(true);
}

/** Write settings */
void keducaprefs::configWrite()
{
  KConfig *config = KGlobal::config();
	config->setGroup("Options");
	config->writeEntry("Geometry", this->size() );
	config->writeEntry("ResultFinish", result_afterfinish->isChecked() );
	config->sync();
}

/** Push ok button */
void keducaprefs::slotOk()
{
	configWrite();
	this->accept();
}
