/***************************************************************************
                            KDockWidgetHeader.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDOCKWIDGETHEADER_H
#define KDOCKWIDGETHEADER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDockWidgetAbstractHeader.h>

/**

 The header (additional bar) for a @ref KDockWidget s (and member of the dockwidget class set).
 It have got the buttons located there. And it is for recording and reading the button states.
 More or less a minor helper class for the dockwidget class set.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short 
 The header (additional bar) for a @ref KDockWidget s (and member of the dockwidget class set).
*/
@class KConfig; 
@class KDockWidget; 
@class KDockWidgetHeaderDrag; 

@interface KDockWidgetHeader : KDockWidgetAbstractHeader 

/** 
 Constructs this.

*/
- initWithDockWidget: (KDockWidget*)parent name: (NSString *)name;
- initWithDockWidget: (KDockWidget*)parent ;

/** 
 Destructs this.
   
*/
- (void) dealloc;

/** 
 Hides the close button and stay button when switching to toplevel or vice versa shows them.

*/
- setTopLevel: (BOOL)t;

/** 
 Sets the drag panel of this header.

*/
- setDragPanel: (KDockWidgetHeaderDrag*)nd;
- (BOOL) dragEnabled;
- setDragEnabled: (BOOL)b;

/** 
 Saves the current button state to a KDE config container object.

*/
- saveConfig: (KConfig*)c;

/** 
 Loads the current button state from a KDE config container object.

*/
- loadConfig: (KConfig*)arg1;

/** 
 Sets dragging the dockwidget off when the stay button is pressed down and vice versa.
   
*/
- slotStayClicked;
@end

/** Override these methods in subclasses of KDockWidgetHeader to customise event handling behaviour */
@protocol KDockWidgetHeaderEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
